/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "Sin_Wave" (Input) (Subroutine)                          */
/* Author: Steve Thorpe,IAC                                              */
/* Date Created: Tue Nov 24 17:24:58 1992                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* output 0 "vector_field" field 1D 1-space 1-vector uniform float       */
/* param 0 "npoints" idial 128 0 359                                     */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int Sin_Wave_desc()
{

	int in_port, out_port, param;
	extern int Sin_Wave_compute();

	AVSset_module_name("Sin_Wave", MODULE_DATA);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("vector_field", 
		"field 1D 1-space 1-vector uniform float");

	/* Parameter Specifications                */
	param = AVSadd_parameter("npoints", "integer", 128, 1, 360);
	AVSconnect_widget(param, "idial");

	AVSset_compute_proc(Sin_Wave_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int Sin_Wave_compute( vector_field, npoints)
	AVSfield_float **vector_field;
	int npoints;
{

/*  THIS IS A 'HINTS' AREA - YOU MAY CUT AND PASTE AT WILL FROM IT       */
		int i;
		int dims0[1];
		float *fp;
/*                                                                       */
/* Free old field data                                                   */
	if (*vector_field) AVSfield_free(*vector_field);
/* Allocate space for new field output                                   */
	dims0[0] = npoints;
	*vector_field = (AVSfield_float *) 
		AVSdata_alloc("field 1D 1-space 1-vector uniform float", 
		dims0);
	if (*vector_field == NULL) {
	    AVSerror("Allocation of output field failed.");
	    return(0);
	}
/*  FILL IN THE OUTPUT FIELD  Here!                                      */
/* free any locally allocated data                                       */
/* THIS IS THE END OF THE 'HINTS' AREA. ADD YOUR OWN CODE BETWEEN THE    */
/* FOLLOWING COMMENTS. THE CODE YOU SUPPLY WILL NOT BE OVERWRITTEN.      */

	fp = (float *) (*vector_field)->data;
	for (i = 0; i < npoints; i++)
		{
		fp[i] = sin(((double)i)/(2.0*M_PI));
		/*printf("sin(%3d) == %f\n", i, sin(((double)i)/(2.0*M_PI)));*/
		}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */
/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	Sin_Wave_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
