/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "read_tiff" (Input) (Subroutine)                         */
/* Author:  Steve Thorpe, International AVS Center, NCSC                 */
/* Date Created: Fri Mar 13 15:45:15 1992                                */
/*                                                                       */
/* output 0 "image" field 2D 2-space 4-vector byte                       */
/* param 0 "Choose a TIFF file" browser  :                               */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
 
/* *****************************************/
/*  Module Specification                   */
/* *****************************************/
int read_tiff_spec()
{

	int in_port, out_port, param;
	extern int read_tiff_compute();

	AVSset_module_name("Read_TIFF", MODULE_DATA);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("image", 
		"field 2D 2-space 4-vector byte");

	/* Parameter Specifications                */
	param = AVSadd_parameter("Choose a TIFF file", "string", " ", 
		"", ":");
	AVSconnect_widget(param, "browser");

	AVSset_compute_proc(read_tiff_compute);

	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int read_tiff_compute( image, tiffFile)
	AVSfield_char **image;
	char *tiffFile;
{
/*	extern int read_tiff_into_AVS(char *, char *);*/
 	int dims0[2]; 
	FILE *fp;
	unsigned long xdim, ydim;
	int t;

 	if (*image) AVSfield_free(*image);                                   

	/* open and convert the TIFF file to an AVS file */
	if (t = read_tiff_into_AVS(tiffFile, "/tmp/tempAVS.x"))
		{
		fprintf(stderr, "Couldn't convert file to AVS format!\n");
		return 0;
		}

	/* now open the AVS file and check out the dimensions */
	if (((fp = fopen("/tmp/tempAVS.x", "rb")) == NULL) ||
	    ((fread(&xdim, sizeof(xdim), 1, fp)) != 1) ||
	    ((fread(&ydim, sizeof(ydim), 1, fp)) != 1))
		{
		fprintf(stderr, "Couldn't read the AVS formatted file!\n");
		return 0;
		}
	

	/* Allocate space for new field output */
 	dims0[0] = xdim;
 	dims0[1] = ydim;
 	*image = (AVSfield_char *) 
		  AVSdata_alloc("field 2D 2-space 4-vector byte", dims0);
 
	/* Read the AVS image data from the file */
	if (fread((*image)->data, (int) xdim, (int) (ydim*4), fp) != ydim*4)
		{
		fprintf(stderr, "Couldn't read the AVS image!\n");
		return 0;
		}
		
	return 1;
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*filter_mod_list[])()) = {
	read_tiff_spec,
};
#define NMODS (sizeof(filter_mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(filter_mod_list, NMODS);
}
 
