/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "case_read" (Input) (Subroutine)                         */
/* Author: Mike Rangitsch                                                */
/* Date Created: Thu Dec  7 11:07:00 1995                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* output 0 "case_data" field 2D 9-vector uniform float                  */
/* param 0 "Case_file" browser "" "" ".case1"                            */
/* param 1 "Case_number" idial 0 0 31                                    */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int case_read_desc()
{

	int in_port, out_port, param, iresult;
	extern int case_read_compute();

	AVSset_module_name("case_read", MODULE_DATA);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("case_data", 
		"field 2D 9-vector uniform float");

	/* Parameter Specifications                */
	param = AVSadd_parameter("Case_file", "string", "", "", ".case1");
	AVSconnect_widget(param, "browser");
	param = AVSadd_parameter("Case_number", "integer", 0, 0, 31);
	AVSconnect_widget(param, "idial");

	AVSset_compute_proc(case_read_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int case_read_compute( case_data, Case_file, Case_number)
	AVSfield_float **case_data;
	char *Case_file;
	int Case_number;
{

/*  THIS IS A 'HINTS' AREA - YOU MAY CUT AND PASTE AT WILL FROM IT       */
/* THIS IS THE END OF THE 'HINTS' AREA. ADD YOUR OWN CODE BETWEEN THE    */
/* FOLLOWING COMMENTS. THE CODE YOU SUPPLY WILL NOT BE OVERWRITTEN.      */
 
/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */

 FILE   *casefile;
 int     dims0[2], i, j, k, ncases, nvals[64], nmaxvals;
 int     count;
 char    message[30],line[150];
 float   *alldata=NULL;
 float   maxvals[13], minvals[13], tvals[14];


 if( Case_file == NULL )
  return(1);

 if( AVSparameter_changed("Case_file") || 
     AVSparameter_changed("Case_number") )
  {
   if( (casefile = fopen(Case_file,"r")) == (FILE *) NULL )
   {
     printf("Couldn't open %s for reading.\n", Case_file);
     return(0);
   }
   else
   {
    sprintf(message,"case read starting");
    AVSmodule_status(message,1);
    ncases = 0;

    rewind(casefile);

    while ( fgets(line,150,casefile) != NULL )
     {
      if(line[0] == '=') ncases = ncases + 1;
     }

    AVSmodify_parameter("Case_number",AVS_MAXVAL,NULL,NULL,ncases-1);

    rewind(casefile);

    for( i = 0; i < 64; i++ ) nvals[i] = 0;
    nmaxvals = 0;

    fgets(line,150,casefile);
    for ( i = 0; i < ncases; i++ )
    {
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     while( fgets(line,150,casefile) != NULL && line[0] != '=' )
     {
      nvals[i] = nvals[i] + 1;
     }
     nmaxvals = nvals[i] > nmaxvals ? nvals[i]:nmaxvals;
    }

    rewind(casefile);

    if( alldata ) free(alldata);

    alldata = (float *)malloc( 14*nmaxvals*sizeof(float) );

    count = 0;


/*  find the min and maximum for each data value */

    for ( k = 0; k < 13; k++ )
    {
     minvals[k] =  1.E10;
     maxvals[k] = -1.E10;
    }

    for ( i = 0; i < ncases; i++ )
    {
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     for ( j = 0; j < nvals[i]; j++ )
      {
       fgets(line,150,casefile);
       sscanf(line,"%f %f %f %f %f %f %f %f %f %f %f %f %f %f",
             &tvals[ 0],&tvals[ 1],&tvals[ 2],&tvals[ 3],
             &tvals[ 4],&tvals[ 5],&tvals[ 6],&tvals[ 7],
             &tvals[ 8],&tvals[ 9],&tvals[10],&tvals[11],
             &tvals[12],&tvals[13]);
       for ( k = 1; k < 14; k++ )
        {
         maxvals[k-1] = maxvals[k-1] > tvals[k] ? maxvals[k-1] : tvals[k];
         minvals[k-1] = minvals[k-1] < tvals[k] ? minvals[k-1] : tvals[k];
        }
       }
    }

    rewind(casefile);

/*  skip to the case we want, then input it */

    for ( i = 0; i < Case_number; i++ )
    {
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     for ( j = 0; j < nvals[i]; j++ )
      {
       fgets(line,150,casefile);
       }
    }

     fgets(line,150,casefile);
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     fgets(line,150,casefile);
     for ( j = 0; j < nvals[Case_number]; j++ )
      {
       fgets(line,150,casefile);
       sscanf(line,"%f %f %f %f %f %f %f %f %f %f %f %f %f %f",
             &alldata[count   ],&alldata[count+ 1],&alldata[count+ 2],&alldata[count+ 3],
             &alldata[count+ 4],&alldata[count+ 5],&alldata[count+ 6],&alldata[count+ 7],
             &alldata[count+ 8],&alldata[count+ 9],&alldata[count+10],&alldata[count+11],
             &alldata[count+12],&alldata[count+13]);
        count = count+14;
       } 

    dims0[0] = 2;
    dims0[1] = nvals[Case_number];

/*                                                                       */
/* Free old field data                                                   */

    if (*case_data) {
       AVSfield_free(*case_data);
      *case_data = NULL;
     }

   *case_data = (AVSfield_float *) AVSdata_alloc("field 2D 13-vector uniform float", 
               dims0);

    if (*case_data == NULL) {
        AVSerror("Allocation of output field failed.");
        return(0);
       }


    for ( j = 0; j < nvals[Case_number]; j++ )
     for ( k = 0; k < 13; k++ )
     {
      I2DV(*case_data,0,j)[k] = alldata[j*14      ];
      I2DV(*case_data,1,j)[k] = alldata[j*14+(k+1)];
     }
   
    AVSfield_set_labels(*case_data,
      "T1;Time;Tbasal;P;Conv;yield;C1;C2;C3;C4;C5;C6;C7",";");

    AVSfield_set_units(*case_data,"R;min;R;Pa;%;%;X;X;X;X;X;X;X",";");

    AVSfield_set_minmax(*case_data,minvals,maxvals);

   }
  }
/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
static int ((*mod_list[])()) = {
	case_read_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
