/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "conv_read" (Input) (Subroutine)                         */
/* Author: Mike Rangitsch                                                */
/* Date Created: Thu Dec  7 11:07:00 1995                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* output 0 "log_data" field 2D 12-vector uniform float                  */
/* param 0 "log_file" browser "" "" ".log"                               */
/* param 1 "minval" idial 0 8 0                                          */
/* param 2 "maxval" idial 8 8 0                                          */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int conv_read_desc()
{

	int in_port, out_port, param, iresult;
	extern int conv_read_compute();

	AVSset_module_name("conv_read", MODULE_DATA);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("log_data", 
		"field 2D 12-vector uniform float");

	/* Parameter Specifications                */
	param = AVSadd_parameter("log_file", "string", "", "", ".log");
	AVSconnect_widget(param, "browser");

        param = AVSadd_parameter("minval","integer",0,0,8);
        AVSconnect_widget(param,"idial");

        param = AVSadd_parameter("maxval","integer",8,0,8);
        AVSconnect_widget(param,"idial");

	AVSset_compute_proc(conv_read_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int conv_read_compute( log_data, log_file, minval, maxval)
	AVSfield_float **log_data;
	char *log_file;
        int minval,maxval;
{

/*  THIS IS A 'HINTS' AREA - YOU MAY CUT AND PASTE AT WILL FROM IT       */
/* THIS IS THE END OF THE 'HINTS' AREA. ADD YOUR OWN CODE BETWEEN THE    */
/* FOLLOWING COMMENTS. THE CODE YOU SUPPLY WILL NOT BE OVERWRITTEN.      */
 
/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */

 FILE   *tubefile;
 int     dims0[2], i, j, k;
 int     count;
 char    message[30],line[150], word[20];
 float   *alldata=NULL;
 float   maxvals[12], minvals[12];
 float   resmax,resu,resv,resw,resp,resm,restoc,omb;
 float   conv,rested,resh,resf,resg,reseta,resget,r_af;
 int     niter,idum,num;


 if( log_file == NULL )
  return(1);

 if( AVSparameter_changed("log_file") ||
     AVSparameter_changed("minval")   ||
     AVSparameter_changed("maxval")     )
  {
   if( (tubefile = fopen(log_file,"r")) == (FILE *) NULL )
   {
     printf("Couldn't open %s for reading.\n", log_file);
     return(0);
   }
   else
   {
    sprintf(message,"log file read starting");
    AVSmodule_status(message,1);

    rewind(tubefile);

    sprintf(word,"START");
    while ( strcmp("NITER",word) != 0 )
     {
      fgets(line,150,tubefile);
      sscanf(line,"%s",word);
     }

    while ( fgets(line,150,tubefile) != NULL )
    {
     num = sscanf(line,"%d %f %f %d %f %d %f %d %f %d %f %d %f %d %f %d",
                  &niter,&resmax,&resu,&idum,&resv,&idum,&resw,&idum,&resp,&idum,
                  &resm,&idum,&restoc,&idum,&omb,&idum);
     if( num == 16 )
     {
      fgets(line,150,tubefile);
      sscanf(line,"%f %d %f %d %f %d %f %d %f %d %f %d %f %d %f %d",
             &conv,&idum,&rested,&idum,&resh,&idum,&resf,&idum,&resg,&idum,
             &reseta,&idum,&resget,&idum,&r_af,&idum);
     }
    }

    rewind(tubefile);

    if( alldata ) free(alldata);
    alldata = (float *)malloc( 12*niter*sizeof(float) );

    for ( k = 0; k < 12; k++ )
    {
     minvals[k] =  minval;
     maxvals[k] =  maxval;
    }

    count = 0;

    sprintf(word,"START");
    while ( strcmp("NITER",word) != 0 )
     {
      fgets(line,150,tubefile);
      sscanf(line,"%s",word);
     }

    while ( fgets(line,150,tubefile) != NULL )
    {
     num = sscanf(line,"%d %f %f %d %f %d %f %d %f %d %f %d %f %d %f %d",
                  &idum,&resmax,&alldata[count   ],&idum,&alldata[count+ 1],&idum,
                                &alldata[count+ 2],&idum,&alldata[count+ 3],&idum,
                                &alldata[count+ 4],&idum,&alldata[count+ 5],&idum,
                                &omb,&idum);
     if( num == 16 )
     {
      fgets(line,150,tubefile);
      sscanf(line,"%f %d %f %d %f %d %f %d %f %d %f %d %f %d %f %d",
             &conv,&idum,&alldata[count+ 6],&idum,&alldata[count+ 7],&idum,
                         &alldata[count+ 8],&idum,&alldata[count+ 9],&idum,
                         &alldata[count+10],&idum,&alldata[count+11],&r_af,&idum);
      count = count + 12;
     }
    }

    dims0[0] = 2;
    dims0[1] = niter;

/*                                                                       */
/* Free old field data                                                   */

    if (*log_data) {
       AVSfield_free(*log_data);
      *log_data = NULL;
     }

   *log_data = (AVSfield_float *) AVSdata_alloc("field 2D 12-vector uniform float", 
               dims0);

    if (*log_data == NULL) {
        AVSerror("Allocation of output field failed.");
        return(0);
       }


    for ( j = 0; j < niter; j++ )
     for ( k = 0; k < 12; k++ )
     {
      I2DV(*log_data,0,j)[k] = j;
      I2DV(*log_data,1,j)[k] = alldata[j*12+k];
     }
   
    AVSfield_set_labels(*log_data,
      "res u;res v;res w;res p;res m;res ToC;res TED;res h;res f;res g;res eta;res get",";");

    AVSfield_set_minmax(*log_data,minvals,maxvals);

   }
  }
/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
static int ((*mod_list[])()) = {
	conv_read_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
