/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/******************************************************/
/* Bit Movie Module                                   */
/******************************************************/
/*
 * bit_movie - display one-bit pixmap movies 
 *
 * Author: Ian Curington, AVS/UNIRAS
 *
 * Revision History:
 *  6 Dec  93    ianc: Original (from Trace Render)
 *  7 Dec  93    ianc: Update for GC
 *  9 Dec  93    ianc: Added replay loop
 * 10 Dec  93    ianc: Bug fix, events
 * 27 Jan  93    ianc: fixed event refresh of animation
 *
 */

/******************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
/******************************************************/




/******************************************************/
/* GLOBAL VARIABLES                                   */
/******************************************************/

/* window default size, place */
#define	XWIN	260
#define	YWIN	42
#define	WWIN    500	
#define	HWIN	500
#define	BWIN    5	

#define MAX_PIXMAP 1000

/* global X context */
Window window;
int screen;
unsigned int depth;
int class;
Pixmap pixmap[ MAX_PIXMAP ];
Display *display;
GC gc, pix_gc, rev_pix_gc;
XGCValues gcvalues;
int myexposeproc();
XImage *bit_image;
int mode_select;
char *c_mode_select;
int pixmap_count;
int single_bit;
int replay_speed;
int dummy;
int expose_mask;

/* input field pointer */
AVSfield_float *input = NULL;


/* Window actual size, place */
int xwin=XWIN;
int ywin=YWIN;
unsigned int wwin=(WWIN+2*BWIN);
unsigned int hwin=(HWIN+2*BWIN);
unsigned int bwin=BWIN;


/******************************************************/
/* Main Program Entry Point for Coroutine             */
/******************************************************/

main (argc, argv)

int argc;
char **argv;

{
	int x, y, w, h;
	XSetWindowAttributes xwa;
	XSizeHints xsh;
	XEvent event;
        int X_event;
        Status      result;
	int mask, x_event;
	int AVS_event;
	int bit_movie_desc();

        /******************************************************/
        /* Initialize  Coroutine                              */
        /******************************************************/
	AVScorout_init (argc, argv, bit_movie_desc);
        AVScorout_set_sync(1);  /* Run synchronous with the flow-exec */


        /******************************************************/
        /* Get Current AVS Parmeters, Input data              */
        /******************************************************/
	AVScorout_input (&input,
                         &c_mode_select,
                         &replay_speed,
                         &dummy);

        /* allocate the memory the first time */
        if ( input )
        {
            wwin=( MAXX(input) );
            hwin=( MAXY(input) );
        }
        mode_select = AVSchoice_number("Mode",c_mode_select);

        /******************************************************/
        /* Setup the X-Window Display                         */
        /******************************************************/
	display = XOpenDisplay (NULL);
	if (display == NULL) {
		fprintf (stderr, 
			"bit_movie: Unable to connect to X server.\n");
		exit (1);
	}

	screen= DefaultScreen( display );
        depth = DisplayPlanes (display, screen);

	xwa.background_pixel = BlackPixel (display, screen);
	xwa.border_pixel = WhitePixel (display, screen);
	window = XCreateWindow (display, RootWindow(display, screen),
					xwin, ywin, wwin, hwin,
					bwin, depth,
					InputOutput,
					DefaultVisual(display, screen), 
					(CWBackPixel|CWBorderPixel), &xwa);
	if (window == NULL) {
		fprintf (stderr, "bit_movie: Unable to create window.\n");
		exit (1);
	}

        /* Set Visible Window GC */
	gcvalues.graphics_exposures = False;
	gc = XCreateGC (display, window, GCGraphicsExposures, &gcvalues);
	xsh.width = wwin;
	xsh.height = hwin;
	xsh.flags = USSize;
	XSetNormalHints (display, window, &xsh);
	XSetStandardProperties (display, window, argv[0], argv[0], None,
				argv, argc, &xsh);
	XSetBackground(display,gc, BlackPixel (display, screen));
	XSetForeground(display,gc, WhitePixel (display, screen));


        
        /* Create an offscreen pixmap */
        single_bit = 1;
        pixmap_count = 1;
        pixmap[0] = XCreatePixmap(display,
                           DefaultRootWindow(display),
                           wwin, hwin, single_bit);

        /* Set offscreen Pixmap GC's */
        /* one for drawing, one for clearing */
	pix_gc = XCreateGC (display, pixmap[0], 0, 0);
	XSetBackground(display,pix_gc, BlackPixel (display, screen));
	XSetForeground(display,pix_gc, WhitePixel (display, screen));
	rev_pix_gc = XCreateGC (display, pixmap[0], 0, 0);
	XSetBackground(display,rev_pix_gc, WhitePixel (display, screen));
	XSetForeground(display,rev_pix_gc, BlackPixel (display, screen));


        /* Create a Client Image struct */
        bit_image = XCreateImage(display,
                                 DefaultVisual(display, screen),
                                 single_bit,
                                 ZPixmap,
                                 0, 0, wwin, hwin, 
                                 32, 0 );
        bit_image->data = malloc( bit_image->bytes_per_line * hwin );



/****
 Nothing implemented for mouse interaction yet,

	XSelectInput (display, window, ExposureMask
					| KeyPressMask
					| ButtonPressMask
					| ButtonMotionMask
					| ButtonReleaseMask);
 ****/
	XSelectInput (display, window, ExposureMask );

	XMapWindow (display, window);

        /* trigger an initial draw */
        mydraw();
        mypaint();
	XMapWindow (display, window);
	XSync (display, False);

        /******************************************************/
        /* Primary Event Loop, wait for AVS or Window         */
        /******************************************************/
	while (1)
        {
		/* This will block until either X or AVS or both */
		mask = COROUT_WAIT;
		X_event = AVScorout_X_wait(display, NULL, &mask);

		if (mask)
                {
	                AVScorout_input (&input,
                                         &c_mode_select,
                                         &replay_speed,
                                         &dummy);
                        mode_select = AVSchoice_number("Mode",c_mode_select);


			AVS_event = 0;
			expose_mask = 0;

	        	/********************************/
		        /* Process an AVS trigger       */
       		 	/********************************/
			if (AVSinput_changed ("Input Trace", 0))
                        {
				mydraw();
				mypaint();
			}
                        if (AVSparameter_changed("Mode"))
                        {
                                if ( mode_select == 1 )
                                    pixmap_clean();

                                if ( mode_select < 3  )
                                    mydraw();

                                AVSmodify_parameter("Stored Frames",
                                       AVS_VALUE, pixmap_count, 1, MAX_PIXMAP );


				mypaint();
			}
		}
        	/********************************/
	        /* Process an X window trigger  */
       	 	/********************************/
		if (X_event) {
			expose_mask = 1;
			do {
			XNextEvent (display, &event);
			switch (event.type) {
			case Expose:
				myexposeproc (window, &event);
				break;
			case KeyPress:
				break;
			case ButtonPress:
			case ButtonRelease:
			case MotionNotify:
				buttonmotionproc (window, &event);
				break;
			default:
				break;
			}
			} while (XPending (display));
		}
	}
}

/******************************************************/
/* AVS Description Routine                            */
/******************************************************/
int bit_movie_desc()

{
	int  in_port, out_port;
        int  param;

	int quitproc();

	AVSset_module_name ("Bit Movie", MODULE_RENDER);
	AVSset_destroy_proc (quitproc);

	in_port = AVScreate_input_port ("Input Trace",
                  "field 2D uniform scalar byte", REQUIRED);

        param = AVSadd_parameter("Mode","choice",
                "Clear",
                "Clear#Store#Replay Once#Replay Loop","#");

        param = AVSadd_parameter("Speed","integer",100,1,100);

        param = AVSadd_parameter("Stored Frames","integer",1,1,MAX_PIXMAP);
        AVSconnect_widget(param, "typein_integer");

        return(1);
}

/******************************************************/
/* Utility to make bit map structure from Input Field   */
/******************************************************/
int make_bitmap(image,field)

   XImage *image;
   AVSfield_char *field;

{
    int i, j;
    int status;
    long white_pixel;
    long black_pixel;
    int index;

    white_pixel = WhitePixel (display, screen);
    black_pixel = BlackPixel (display, screen);

    for ( j=0; j < MAXY(field); j++ )
      for ( i=0; i < MAXX(field); i++ )
      {
          index = j*MAXX(field)+i;
          if ( field->data[ index ] >= 128 )
              status = XPutPixel ( image, i, j, white_pixel );
          else
              status = XPutPixel ( image, i, j, black_pixel );
      }
}

/******************************************************/
/*  Expose event processing                           */
/******************************************************/
int
myexposeproc(window, event)

Window window;
XExposeEvent *event;

{
	Window root;
	int x, y;
	unsigned int w, h, b, d;


	if (event->type != Expose) return;

        /* detect if window has changed size, if so recreate pixmap */

	XGetGeometry (display, window, &root, &x, &y, &w, &h, &b, &d);
	xwin = x;
	ywin = y;
	if (w != wwin || h != hwin) {
/**
   don't allow resize for now....
		wwin = w;
		hwin = h;

		if (pixmap[0]) XFreePixmap (display, pixmap[0]);
		pixmap[0] = XCreatePixmap (display, 
					window,
                                        wwin, hwin,
                                        single_bit);
 **/
                pixmap_clean();
		mydraw();
		mypaint();
	}
	if (window == window && event->count == 0) {
		mypaint();
	}
}

/******************************************************/
/*  button motion  event processing                   */
/******************************************************/
int
buttonmotionproc(window, event)

Window window;
XButtonEvent *event;

{
	static int button = 0;
	int i;
	XButtonEvent levent;

	switch (event->type) {
	case MotionNotify:
		while (XPending(display)) {
			XNextEvent (display, &levent);
			if (levent.window == window 
					&& levent.type == MotionNotify) {
				event = &levent;
				continue;
			} else {
				XPutBackEvent (display, &levent);
				break;
			}
		}
		switch (button) {
		case Button1:
			mypaint();
			break;
		case Button2:
			mypaint();
			break;
		case Button3:
			mypaint();
			break;
		default:
			break;
		}
		break;
	case ButtonPress:
		button = event->button;
		switch (button) {
		case Button1:
			mypaint();
			break;
		case Button2:
			mypaint();
			break;
		case Button3:
			mypaint();
			break;
		default:
			break;
		}
		break;
	case ButtonRelease:
		break;
	default:
		break;
	}
}

/******************************************************/
/*  mypaint - display the traces again                */
/******************************************************/
int
mypaint()

{
        unsigned long plane;
        int i, j, k, start, end;
        int repeat_count;

        plane = 0x0001;
        end = pixmap_count - 1;

        if ( mode_select >= 3 && !expose_mask) /* replay loop */
          start = 0;
        else
          start = end;

        if ( mode_select == 4 && !expose_mask) repeat_count = 100;
        else                    repeat_count = 1;

        for (i=0; i < repeat_count; i++ )
        {
            if ( mode_select == 4 )
            {
/***
                AVScorout_mark_changed();
                AVScorout_wait();
                AVScorout_input (&input,
                                 &c_mode_select,
                                 &replay_speed,
                                 &dummy);
                AVScorout_input (&input, &c_mode_select, &replay_speed);
                mode_select = AVSchoice_number("Mode",c_mode_select);
 **/
            }
            else
                repeat_count = 1;

            /* === High Speed Animation Loop === */

            for ( j=start; j <=end; j++ )
            {
                XCopyPlane(display,       /* display */
                      pixmap[j],          /* src */
                      window,             /* dest */
                      gc,                 /* GC of dest */
                      0, 0, wwin, hwin,   /* src area spec */
                      0, 0,               /* dest corner */
                      plane );

                if ( replay_speed < 100 )
                for (k = 0; k < 100-replay_speed; k++)
                    XSync(display, 0);
            }
        }


        XMapWindow(display, window);
}

/******************************************************/
/*  destroy the application window                    */
/******************************************************/
int quitproc()

{
        pixmap_clean();

	XFreePixmap (display, pixmap[0]);

/* IAC CODE CHANGE :         free ( bit_image->data ); */
         free(bit_image->data );
        XDestroyImage( bit_image);

	exit (0);
}

/******************************************************/
/*  Graphics Drawing Function                         */
/* Create the graphics in the off-screen data struct  */
/******************************************************/
int mydraw()

{
        int i;

        /* fill the Ximage structure from the input field */
        make_bitmap( bit_image, input );

        if ( mode_select == 2 &&
             pixmap_count < MAX_PIXMAP  )  /* store */
        {
            pixmap[ pixmap_count ] = XCreatePixmap(display,
                        DefaultRootWindow(display),
                        wwin, hwin, single_bit);
            i = pixmap_count;
            pixmap_count++;


        }
        else
            i = 0;

        AVSmodify_parameter("Stored Frames",
                            AVS_VALUE, pixmap_count, 1, MAX_PIXMAP );

        /* Copy the bit map over to the offscreen pixmap */
        XPutImage( display,
                   pixmap[i], pix_gc,
                   bit_image,
                   0, 0, 0, 0,
                   wwin, hwin );

}

/******************************************************/
/*  Clean Up extra Pixmaps                            */
/******************************************************/
pixmap_clean()
{
        int i;

        for ( i = 1; i < pixmap_count; i++ )
	XFreePixmap (display, pixmap[i]);
        pixmap_count = 1;

}

