/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

*****************************************************************************/
/* line clipping algorithm from Foley & van Dam, p. 149 */

#include <stdio.h>
#define YES 1
#define NO 0


static int out1 = 0;
static int out2 = 0;
static float x1 = 0.;
static float y1 = 0.;
static float x2 = 0.;
static float y2 = 0.;

int clip(fx1, fy1, fx2, fy2, xmin, ymin, xmax, ymax)
float *fx1, *fy1, *fx2, *fy2;
float xmin, ymin, xmax, ymax;
{
char accept, reject, done;

x1 = *fx1;
y1 = *fy1;
x2 = *fx2;
y2 = *fy2;

accept = reject = done = NO;
while (!done)
	{
	outcode(xmin, ymin, xmax, ymax);
	reject = treject();
	if (reject)
		done = YES;
	else
		{
		accept = taccept();
		if (accept)
			done = YES;
		else
			{
			if (!out1)
				swap();
			if (out1 & 010)
				{
				x1 = x1 + (x2 - x1) * (ymax - y1)/(y2 - y1);
				y1 = ymax;
				}
			else if (out1 & 04)
				{
				x1 = x1 + (x2 - x1) * (ymin - y1)/(y2 - y1);
				y1 = ymin;
				}
			else if (out1 & 02)
				{
				y1 = y1 + (y2 - y1) * (xmax - x1)/(x2 - x1);
				x1 = xmax;
				}
			else if (out1 & 01)
				{
				y1 = y1 + (y2 - y1) * (xmin - x1)/(x2 - x1);
				x1 = xmin;
				}
			}
		}
	}
if (accept)
	{
	*fx1 = x1;
	*fy1 = y1;
	*fx2 = x2;
	*fy2 = y2;
	return(1);
	}
return(0);
}

outcode(xmin, ymin, xmax, ymax)
float xmin, ymin, xmax, ymax;
{
out1 = out2 = 0;

if (y1 > ymax)
	out1 |= YES << 3;
if (y1 < ymin)
	out1 |= YES << 2;
if (x1 > xmax)
	out1 |= YES << 1;
if (x1 < xmin)
	out1 |= YES << 0;
if (y2 > ymax)
	out2 |= YES << 3;
if (y2 < ymin)
	out2 |= YES << 2;
if (x2 > xmax)
	out2 |= YES << 1;
if (x2 < xmin)
	out2 |= YES << 0;
return;
}

int treject()
{
if ((out1 & out2) != 0)
	return(YES);
else
	return(NO);
}

int taccept()
{
if ((out1 == 0) && (out2 == 0))
	return(YES);
else
	return(NO);
}

swap()
{
float xtemp, ytemp;
int otemp;

xtemp = x1;
ytemp = y1;
x1 = x2;
y1 = y2;
x2 = xtemp;
y2 = ytemp;
otemp = out1;
out1 = out2;
out2 = otemp;
return;
}
