/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

*****************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "Draw Map" (Output) (Subroutine)                   */
/* Author: Jeff Wang,NCSC,248-9242                                       */
/* Date Created: Mon Jul 19 14:27:14 1993                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "draw_usmap.h"

#define max(a,b) (((a)>(b)) ? (a):(b))
#define min(a,b) (((a)<(b)) ? (a):(b))

/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
int plist[] = {5, 1, 2, 3, 4, 5, 0};
GEOMobj *obj0, *obj1, *background;
static float xdraw22, ydraw22, xdraw21, ydraw21;
static float color1[15];
static float color2[15];
static float color3[15];

/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int Draw_Map_desc()
{

	int in_port, out_port, param;
	extern int Draw_Map_compute();

	AVSset_module_name("Draw Map", MODULE_RENDER);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("OutMAP", "geom");

	/* Parameter Specifications                */
	param = AVSadd_parameter("Draw Map", "boolean", 0, 1, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("county files", "string", " ", " ", ":");
	AVSconnect_widget(param, "browser");
	param = AVSadd_parameter("state files", "string", " ", " ", ":");
	AVSconnect_widget(param, "browser");
	param = AVSadd_parameter("map utm zone", "integer", 0, 0, 100000);
	AVSconnect_widget(param, "typein_integer");
	param = AVSadd_float_parameter("Map SW X Coordinate", 0.0, FLOAT_UNBOUND,
	       FLOAT_UNBOUND);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("MAP NE X Coordinate", 0.0, FLOAT_UNBOUND,
	        FLOAT_UNBOUND);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("MAP SW Y Coordinate", 0.0, FLOAT_UNBOUND,
	        FLOAT_UNBOUND);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("MAP NE Y Coordinate", 0.0, FLOAT_UNBOUND,
	        FLOAT_UNBOUND);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("Domain SW X Coordinate", 0.0, FLOAT_UNBOUND,
	        FLOAT_UNBOUND);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("Domain NE X Coordinate", 0.0, FLOAT_UNBOUND,
	        FLOAT_UNBOUND);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("Domain SW Y Coordinate", 0.0, FLOAT_UNBOUND,
	        FLOAT_UNBOUND);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("Domain NE Y Coordinate", 0.0, FLOAT_UNBOUND,
	        FLOAT_UNBOUND);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("County R", 1.0, 0.0, 1.0);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("County G", 1.0, 0.0, 1.0);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("County B", 1.0, 0.0, 1.0);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("State R", 1.0, 0.0, 1.0);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("State G", 0.0, 0.0, 1.0);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("State B", 0.0, 0.0, 1.0);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("Background R", 0.0, 0.0, 1.0);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("Background G", 0.0, 0.0, 1.0);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("Background B", 1.0, 0.0, 1.0);
	AVSconnect_widget(param, "typein_real");

	AVSset_compute_proc(Draw_Map_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int Draw_Map_compute( 
OutMAP, 
Draw_Map,
county_files, 
state_files, 
map_utm_zone,
clip_minx, clip_maxx, 
clip_miny, clip_maxy,
domain_minx, domain_maxx, 
domain_miny, domain_maxy,
colorR_1, colorG_1, colorB_1,
colorR_2, colorG_2, colorB_2,
colorR_3, colorG_3, colorB_3
)
	GEOMedit_list *OutMAP;
        int Draw_Map;
	char *county_files;
	char *state_files;
	int map_utm_zone;
        float *clip_minx, *clip_maxx; 
        float *clip_miny, *clip_maxy;
        float *domain_minx, *domain_maxx;
        float *domain_miny, *domain_maxy;
        float *colorR_1, *colorG_1, *colorB_1;
        float *colorR_2, *colorG_2, *colorB_2;
        float *colorR_3, *colorG_3, *colorB_3;
{
   char      line[LINESIZE],fileName[LINESIZE];
   static char      countyfile[LINESIZE], statefile[LINESIZE];
   int       i, k, n, j, jj, bWrite, iv;
   WordType  word1, word2, Pname, Wname, Sname;
   FilePtr   fpin1, fpin2;
   FilePtr   fpout4;
   static float backgrd_verts[15];
   static float domain_verts[15];
   static float clipminx, clipmaxx, clipminy, clipmaxy;
   static float domainminx, domainmaxx, domainminy, domainmaxy;
   int ivert;

   /* Initialize the color to save time */
   color1[0] = color1[3] = color1[6] = color1[9] = color1[12] =  *colorR_1;
   color1[1] = color1[4] = color1[7] = color1[10] = color1[13] = *colorG_1;
   color1[2] = color1[5] = color1[8] = color1[11] = color1[14] = *colorB_1;

   color2[0] = color2[3] = color2[6] = color2[9] = color2[12] =  *colorR_2;
   color2[1] = color2[4] = color2[7] = color2[10] = color2[13] = *colorG_2;
   color2[2] = color2[5] = color2[8] = color2[11] = color2[14] = *colorB_2;

   color3[0] = color3[3] = color3[6] = color3[9] = color3[12] =  *colorR_3;
   color3[1] = color3[4] = color3[7] = color3[10] = color3[13] = *colorG_3;
   color3[2] = color3[5] = color3[8] = color3[11] = color3[14] = *colorB_3;

/*  THIS IS A 'HINTS' AREA - YOU MAY CUT AND PASTE AT WILL FROM IT       */
/*                                                                       */
/* THIS IS THE END OF THE 'HINTS' AREA. ADD YOUR OWN CODE BETWEEN THE    */
/* FOLLOWING COMMENTS. THE CODE YOU SUPPLY WILL NOT BE OVERWRITTEN.      */
 
/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */
   /* start the raw data preprocessing */
   if (AVSparameter_changed("county files"))
   {
      sprintf(countyfile, "%s\0", county_files);
   }

   if (AVSparameter_changed("state files"))
   {
      sprintf(statefile, "%s\0", state_files);
   }
   
   /* reset domain area */
   clipminx = *clip_minx;
   clipmaxx = *clip_maxx;
   clipminy = *clip_miny;
   clipmaxy = *clip_maxy;
   domainminx = *domain_minx;
   domainmaxx = *domain_maxx;
   domainminy = *domain_miny;
   domainmaxy = *domain_maxy;
   if (domainminx < clipminx ) 
   {
      domainminx = clipminx;
      AVSmodify_float_parameter("Domain SW X Coordinate", AVS_VALUE,
                          domainminx, FLOAT_UNBOUND, FLOAT_UNBOUND); 
   }
   if (domainminx > clipmaxx ) 
   {
      domainminx = clipmaxx;
      AVSmodify_float_parameter("Domain SW X Coordinate", AVS_VALUE,
                          domainminx, FLOAT_UNBOUND, FLOAT_UNBOUND); 
   }
   if (domainmaxx > clipmaxx )
   {
      domainmaxx = clipmaxx;
      AVSmodify_float_parameter("Domain NE X Coordinate", AVS_VALUE,
                          domainmaxx, FLOAT_UNBOUND, FLOAT_UNBOUND); 
   }
   if (domainmaxx < clipminx )
   {
      domainmaxx = clipminx;
      AVSmodify_float_parameter("Domain NE X Coordinate", AVS_VALUE,
                          domainmaxx, FLOAT_UNBOUND, FLOAT_UNBOUND); 
   }
   if (domainminy < clipminy )
   {
      domainminy = clipminy;
      AVSmodify_float_parameter("Domain SW Y Coordinate", AVS_VALUE,
                          domainminy, FLOAT_UNBOUND, FLOAT_UNBOUND); 
   }
   if (domainminy > clipmaxy )
   {
      domainminy = clipmaxy;
      AVSmodify_float_parameter("Domain SW Y Coordinate", AVS_VALUE,
                          domainminy, FLOAT_UNBOUND, FLOAT_UNBOUND); 
   }
   if (domainmaxy > clipmaxy )
   {
      domainmaxy = clipmaxy;
      AVSmodify_float_parameter("Domain NE Y Coordinate", AVS_VALUE,
                          domainmaxy, FLOAT_UNBOUND, FLOAT_UNBOUND); 
   }
   if (domainmaxy < clipminy ) 
   {
      domainmaxy = clipminy;
      AVSmodify_float_parameter("Domain NE Y Coordinate", AVS_VALUE,
                          domainmaxy, FLOAT_UNBOUND, FLOAT_UNBOUND); 
   }

   if (Draw_Map)
   {
/*                                                                       */
/* Create the OutMAP object                                            */
/* Choose one of the following 3 ways to create a GEOM_POLYHEDRON        */
   /* add border of clipping rectangle */
   ivert = 0;

   backgrd_verts[ivert++] = clipminx;
   backgrd_verts[ivert++] = clipminy;
   backgrd_verts[ivert++] = 0.0;

   backgrd_verts[ivert++] = clipmaxx;
   backgrd_verts[ivert++] = clipminy;
   backgrd_verts[ivert++] = 0.0;

   backgrd_verts[ivert++] = clipmaxx;
   backgrd_verts[ivert++] = clipmaxy;
   backgrd_verts[ivert++] = 0.0;

   backgrd_verts[ivert++] = clipminx;
   backgrd_verts[ivert++] = clipmaxy;
   backgrd_verts[ivert++] = 0.0;

   backgrd_verts[ivert++] = clipminx;
   backgrd_verts[ivert++] = clipminy;
   backgrd_verts[ivert++] = 0.0;

   background = GEOMcreate_polyh_with_data(GEOM_NULL, backgrd_verts,
                GEOM_NULL, GEOM_NULL, 5, plist, GEOM_CONVEX,
                GEOM_COPY_DATA);
   GEOMadd_float_colors(background,color3,5,GEOM_COPY_DATA);

   /* add border of map area */
   obj1 = GEOMcreate_obj(GEOM_POLYTRI, GEOM_NULL);
   GEOMadd_polyline(obj1, backgrd_verts, color2, 5, GEOM_COPY_DATA);

   ivert = 0;

   domain_verts[ivert++] = domainminx;
   domain_verts[ivert++] = domainminy;
   domain_verts[ivert++] = 1.0;

   domain_verts[ivert++] = domainmaxx;
   domain_verts[ivert++] = domainminy;
   domain_verts[ivert++] = 1.0;

   domain_verts[ivert++] = domainmaxx;
   domain_verts[ivert++] = domainmaxy;
   domain_verts[ivert++] = 1.0;

   domain_verts[ivert++] = domainminx;
   domain_verts[ivert++] = domainmaxy;
   domain_verts[ivert++] = 1.0;

   domain_verts[ivert++] = domainminx;
   domain_verts[ivert++] = domainminy;
   domain_verts[ivert++] = 1.0;

   GEOMadd_polyline(obj1, domain_verts, color2, 5, GEOM_COPY_DATA);

   obj0 = GEOMcreate_obj(GEOM_POLYTRI, GEOM_NULL);

   icounty = 0;
   
   /* Draw the County Map */
   fpin1 = fopen(countyfile, "r");
   k = 0; i = 0; bdrSize = 0;

   sprintf(fileName, "work1.ind\0");
   fpout4 = fopen (fileName, "w");
   while( fgets(line, LINESIZE, fpin1) != NULL )
   {
      if ( strchr(line,DENOMINATOR) != NULL )
      {
	 /* reset the state boundary points count */
	 bWrite = 0; k = 0; j = 0;
	 sscanf( line, "%[^,]%*1s %s", Sname, word2);
	 n = atoi(word2);
	 strncpy( Wname, Sname, 6 );
	 Wname[6] = '\0'; 
         for(jj=0; jj<6; jj++)
         {
            if (jj > 0) Pname[jj-1] = Wname[jj];
         }
	 Pname[5] = '\0'; 
	 bWrite = 0;
	 bWrite = stateWrite( -1, icounty, Pname, bWrite );
	 if ( bWrite == 1 )
	 {
	    /* add the statesize */
	    i = i + 1;
            fprintf( fpout4, "'%s' %d\n", Pname, n );
	 }
      }
      else
      {
	 j = 0;
	 sscanf( line, "%[^,]%*1s %s", Sname, word2);
	 if ( bWrite == 1 )
	 {
	    k = k + 1; bdrSize = bdrSize + 1;
            fprintf( fpout4, "%s %s\n", Sname, word2 );
         }
      }
      if (k > maxBdrSize) maxBdrSize = k;
   }
   stateSize = i;
   bdrSize = bdrSize + 1;
   fclose(fpout4);
   fclose(fpin1);
   /* end of the raw data preprocessing */

   /* now start the drawing */
   iPrint = 0;
   /* First open a blunch of temp. files */
   sprintf(fileName, "work1.ind");
   fpin2  = fopen ( fileName, READONLY  );

   /*    Data Handling     */
   setup_map( fpin2, map_utm_zone,
              clipminx, clipminy, clipmaxx, clipmaxy,
              color1);

   /* Close All the Files */
   fclose(fpin2);
   /* end of the processing */

   /* Draw the State Map */
   fpin1 = fopen(statefile, "r");
   k = 0; i = 0; bdrSize = 0;

   sprintf(fileName, "work2.ind\0");
   fpout4 = fopen (fileName, "w");
   while( fgets(line, LINESIZE, fpin1) != NULL )
   {
      if ( strchr(line,DENOMINATOR) != NULL )
      {
	 /* reset the state boundary points count */
	 bWrite = 0; k = 0; j = 0;
	 sscanf( line, "%[^,]%*1s %s", Sname, word2);
	 n = atoi(word2);
	 strncpy( Wname, Sname, 3 );
	 Wname[3] = '\0'; 
         for(jj=0; jj<3; jj++)
         {
            if (jj > 0) Pname[jj-1] = Wname[jj];
         }
	 Pname[2] = '\0'; 
	 bWrite = 1;
	 bWrite = stateWrite( 0, icounty, Pname, bWrite );
	 if ( bWrite == 1 )
	 {
	    /* add the statesize */
	    i = i + 1;
            fprintf( fpout4, "'%s' %d\n", Pname, n );
	 }
      }
      else
      {
	 j = 0;
	 sscanf( line, "%[^,]%*1s %s", Sname, word2);
	 if ( bWrite == 1 )
	 {
	    k = k + 1; bdrSize = bdrSize + 1;
            fprintf( fpout4, "%s %s\n", Sname, word2 );
         }
      }
      if (k > maxBdrSize) maxBdrSize = k;
   }
   stateSize = i;
   bdrSize = bdrSize + 1;
   fclose(fpout4);
   fclose(fpin1);

   /* First open a blunch of temp. files */
   sprintf(fileName, "work2.ind");
   fpin2  = fopen ( fileName, READONLY  );

   /*    Data Handling     */
   setup_map( fpin2, map_utm_zone,
              clipminx, clipminy, clipmaxx, clipmaxy,
              color2);

   /* Close All the Files */
   fclose(fpin2);
   /* end of the processing */

   /* Create the GEOM Edit List for OutMAP                                */
   *OutMAP = GEOMinit_edit_list(*OutMAP);
   GEOMedit_geometry(*OutMAP, "OutMAP", background);
   GEOMdestroy_obj(background);
   GEOMedit_geometry(*OutMAP, "OutMAP", obj0);
   GEOMdestroy_obj(obj0);
   GEOMedit_geometry(*OutMAP, "OutMAP", obj1);
   GEOMdestroy_obj(obj1);
   }
/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	Draw_Map_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/

/* IAC CODE CHANGE - replace ANSI style function arguments */
GraType get_boundary( line, j )
char line[LINESIZE]; 
int j;
{
  float       xx, yy;
  WordType    word1, word2;
  GraType     Token;

  sscanf( line, "%s %s\n",  word1, word2 );
  xx = atof(word1); yy = atof(word2);
  Token.Xw = 10000*xx;
  Token.Yw = 10000*yy;
  Token.Next = j + 1;
  return( Token );
}

/* IAC CODE CHANGE - replace ANSI style function arguments */
int get_usmap( Name, n1, n2, 
               map_utm,
               regn_xmin, regn_ymin,
               regn_xmax, regn_ymax,
               color)
	       WordType Name; int n1; int n2; 
               int map_utm;
               float regn_xmin; float regn_ymin;
               float regn_xmax; float regn_ymax;
               float color[15];
{
  int         i, ii, n, jj, i1, i2, nn, nn1, idvt, idct, j,
	      NextJ, *IdBrk, inindc, same, PrevJ, Pcount;
  float       Xwk1, Ywk1, Xwk2, Ywk2, Xwk3, Ywk3, S, A, Area,
              Dist, TDist;
  int         Xwork1, Ywork1, Xwork2, Ywork2, nidct, Pj2,
              xs0, ys0, xs1, ys1, xs2, ys2, xs3, ys3,
              ins, icode, imode, itype;
  float       xp, yp, xp1, yp1, xp2, yp2, xp3, yp3;
  int         xdraw, ydraw;
  int ivert;
  float base, height;
  static float verts[15];
  UTMcoordinate temputm;
  float xl0, yl0;
  float xl1, yl1;
  float xl, yl;

  /* Allocate enough memory */
  if( (IdBrk = (int *)calloc( 400, sizeof(int) )
       ) == (int *)NULL )
     { printf("IdBrk: Not Enough Memory.");
       exit(0); }

  xp3 = 10000.;  yp3 = 10000.;
  nn = 0;  ii = 0;
  for ( j=n1; j<=n2; j++ )
  {
     xp = State[j].Xw/xp3; yp = State[j].Yw/yp3;
     if ( j == n1 )
     {
        temputm = map_latlon_to_utm( xp, yp, map_utm );
        xdraw22 = temputm.x;
        ydraw22 = temputm.y;
        ii = ii + 1;
        IdBrk[ii] = j;
        idvt = 0;
     }
     else
     {
        if ( idvt == 1 )
        {
           temputm = map_latlon_to_utm(xp, yp, map_utm);
           xdraw22 = temputm.x;
           ydraw22 = temputm.y;
           State[j-1].Next = IdBrk[ii];
           State[IdBrk[ii]].Prev = j-1;
           ii = ii + 1;
           IdBrk[ii] = j;
           idvt = 0;
        }
        idct = 0;

        for ( i=n1; i<=j-1; i++ )
        {
           xp1 = State[i].Xw/xp3; yp1 = State[i].Yw/yp3;
           if( xp == xp1 && yp == yp1 )
           {
               idct = 1; nn = nn + 1;
               temputm = map_latlon_to_utm(xp, yp, map_utm);
               xdraw21 = temputm.x;
               ydraw21 = temputm.y;
               /* Add Link */
               xl0 = xdraw22;
               yl0 = ydraw22;
               xl1 = xdraw21;
               yl1 = ydraw21;
               if (clip(&xl0, &yl0, &xl1, &yl1,
                   regn_xmin, regn_ymin, regn_xmax, regn_ymax))
               {
               ivert = 0;
               verts[ivert++] = xl0;
               verts[ivert++] = yl0;
               verts[ivert++] = 1.0;
               verts[ivert++] = xl1;
               verts[ivert++] = yl1;
               verts[ivert++] = 1.0;
               GEOMadd_disjoint_line(obj0, verts, color,
                               2, GEOM_COPY_DATA);
               }
               xdraw22 = xdraw21;
               ydraw22 = ydraw21;
        }  }

        if (idct == 1 && nn >= 1 )
           idvt = 1;
        else
        {
            temputm = map_latlon_to_utm(xp, yp, map_utm);
            xdraw21 = temputm.x;
            ydraw21 = temputm.y;
            /* Add Link */
            xl0 = xdraw22;
            yl0 = ydraw22;
            xl1 = xdraw21;
            yl1 = ydraw21;
            if (clip(&xl0, &yl0, &xl1, &yl1,
                   regn_xmin, regn_ymin, regn_xmax, regn_ymax))
            {
               ivert = 0;
               verts[ivert++] = xl0;
               verts[ivert++] = yl0;
               verts[ivert++] = 1.0;
               verts[ivert++] = xl1;
               verts[ivert++] = yl1;
               verts[ivert++] = 1.0;
               GEOMadd_disjoint_line(obj0, verts, color,
                               2, GEOM_COPY_DATA);
            }
               xdraw22 = xdraw21;
               ydraw22 = ydraw21;
        }
     }   
  }
  /* reset the Breaker */
  if ( ii == 1 )
  {
     ii=2;
     IdBrk[1] = n1;
     IdBrk[2] = n2 + 1;
  }

/* IAC CODE CHANGE :   free( (void *)IdBrk ); */
   free(IdBrk );
  return( n );
}

/* IAC CODE CHANGE - replace ANSI style function arguments */
void setup_map(fpin2, map_utm, 
               regn_xmin, regn_ymin,
               regn_xmax, regn_ymax,
               color)
               FILE * fpin2; int map_utm; 
               float regn_xmin; float regn_ymin;
               float regn_xmax; float regn_ymax;
               float color[15];
{
   int           i, j, ih, n, nn, iwd, icolor, k, *n1, *n2;
   char          line[LINESIZE], dummy;
   WordType      word2, word1, dum1;
   TitleType     word11, word12, word13, word14,
		 word15, word16, word17, word18;
   float         xp, yp, Xmin1, Ymin1, Xmax1, Ymax1;

   /*   The Us Map data handling */
   rewind( fpin2 ); 

   /* Claim The Enough Memory */
   if( (n1 = (int *)calloc(stateSize+1, sizeof(int))
       ) == (int *)NULL )
     { printf("n1: Not Enough Memory.");
       exit(0); }

   if( (n2 = (int *)calloc(stateSize+1, sizeof(int))
       ) == (int *)NULL )
     { printf("n2: Not Enough Memory.");
       exit(0); }

   if( (UsName = (WordType *)calloc(stateSize+1, sizeof(WordType))
       ) == (WordType *)NULL )
     { printf(" UsName: Not Enough Memory.");
       exit(0); }

   if( (State = (GraType *)calloc( bdrSize, sizeof(GraType))
       ) == (GraType *)NULL )
     { printf("State: Not Enough Memory.");
       exit(0); }

   k = 0; i = 0;
   do {
       i = i + 1;
       if( fgets(line, LINESIZE, fpin2) == NULL )
	  n = 9999;
       else
       {
          sscanf( line, "%*1s%[^'\"]%*1s %s\n", word1, word2);
          sprintf( UsName[i], "%s\0", word1 ); n = atoi(word2);
          if ( n != 0 )
          {
             for ( j=1; j<=n; j++ )
             {
                k = k + 1;
                fgets( line, LINESIZE, fpin2 );
                State[k] = ( *get_boundary)( line, k );
                if( j == 1) n1[i] = k;
                if( j == n) n2[i] = k;
             }
          }
          State[n1[i]].Prev = n2[i];
          State[n2[i]].Next = n1[i];
       }
   } while( n != 9999 && i <= stateSize+1 );
   Sno = i - 1;

   /* draw out the map */
   for ( i = 1; i <= Sno; i++ )
   {
       get_usmap( UsName[i], n1[i], n2[i], map_utm,
                  regn_xmin, regn_ymin, regn_xmax, regn_ymax,
                  color);
   }

/* IAC CODE CHANGE :    free( (void *)n1 ); */
    free(n1 );

/* IAC CODE CHANGE :    free( (void *)n2 ); */
    free(n2 );

/* IAC CODE CHANGE :    free( (void *)UsName ); */
    free(UsName );

/* IAC CODE CHANGE :    free( (GraType *)State ); */
    free(State );
}

/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */


