/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include "wr_ucd.h"
/*-----------------------------------------------------*
 *                                                     *
 *               ****  add_cell  ****                  *
 *                                                     *
 * add a cell topology to the ucd structure.           *
 *-----------------------------------------------------*/

add_cell (model, cell, cell_id, ucd_cell_type, n, rnode_list, mat_id) 
     
     int cell, cell_id, ucd_cell_type, n, *rnode_list, mat_id;
     
     UCD_structure **model;
{
  
  static char *cell_type[] = {"pt", "line", "tri", "quad", "tet",
				"pyr", "prism", "hex"};
  
  int i, num_me_nodes, num_nodes, me_flag, node_list[UCD_MAX_NODE_PER_CELL];
  
  /**************
   ***  body  ***
   **************/
  
  if (ucd_cell_type < UCD_NUM_CELL_TYPES) {
    me_flag = 0;
    num_nodes = UCD_num_nodes[ucd_cell_type];
    
    
    /*  if the number of nodes read (n) is equal to the number of
	nodes without mid-side nodes then send the read node list.  
	else set the mid-edge flag to indicate which edges have 
	mide-edge nodes.                                            */
    for (i = 0; i < num_nodes; i++) { 
      node_list[i] = rnode_list[i];
    }
    
    if (n != num_nodes) {
      for (i = num_nodes, num_me_nodes = 0; i < n; i++) {
	node_list[num_nodes + num_me_nodes] = rnode_list[i];
	me_flag = me_flag | (0x1 << (i - num_nodes)); 
	num_me_nodes++;
      }
    }

    UCDcell_set_information (*model, cell, cell_id, cell_type[ucd_cell_type], 
			     mat_id, ucd_cell_type, me_flag, node_list); 
  }
}
