/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#define STORAGE
#include "wr_ucd.h"

#define cb "\
panel \"$Module\" -p ui -xy 700,100 -wh 306,771\n\
manip \"$Module:First step\" -xy 8,626\n\
manip \"$Module:Current step\" -xy 107,626\n\
manip \"$Module:Last step\" -xy 208,626\n\
"


int fv[3] = {UCD_ASCII_FILE,UCD_BINARY_3_0, UCD_BINARY_3_5};

AVSinit_modules()

{
        int read_ucd_desc();

        AVSmodule_from_desc(read_ucd_desc);
}
static int first_pass=1;
compute(input,file_name,file_list,version_str,snp,snd,scd,smd,mode_str,sleep,
  fs,cs,ls)
UCD_structure *input;
char *file_name,*file_list,*mode_str,*version_str;
int sleep,fs,cs,ls;
int snp,snd,scd,smd;
{
  int read_ucd_desc();
  char *ptr;
  static int md=SEQ_NUM;
  static int loaded=0;
  int cur_step,first_step,last_step;
  char *ob,*eb;

  if(first_pass) {
    AVScommand("kernel",cb,&ob,&eb);
    first_pass=0;
#ifdef DEBUG
    if(ob) printf("%s\n",ob); 
    if(eb) printf("%s\n",eb); 
#endif
    AVSparameter_visible("File list",0);
    prev_step= -1;
  }

 
  if(AVSparameter_changed("File select mode")) {
    md=AVSchoice_number("File select mode",mode_str)-1;
    AVSparameter_visible("File list",md==FILE_LIST);
  }


  if(AVSparameter_changed("File type")) {
    file_version=fv[AVSchoice_number("File type",version_str)-1];
#ifdef DEBUG
  printf("File version & choice : %d %d %s",
    file_version,AVSchoice_number("File type",version_str),version_str);
#endif
  }

  if(!input) return(0);
  if(!file_name) return(0);

  first_step=fs;
  cur_step=cs;
  last_step=ls;


  if(!loaded ||
     AVSparameter_changed("File name") || 
     AVSparameter_changed("File list")) {

      StoreNodePos=snp;
      StoreNodeData=snd;
      StoreCellData=scd;
      StoreModelData=smd;

      max_step=0;
      mode=md;
      if(mode == FILE_LIST && !file_list) {
        AVSerror("No file list selected");
        return(0);
      }

      free_all();
#ifdef DEBUG
  printf("File version %d\n",file_version);
#endif
      wr_ucd(input,file_name);
      cur_step=0;
      if(mode == SAME_FILE) {
         get_file_pos(last_step);
      }
     
      loaded=1;
  }
    
  if (  AVSparameter_changed("First step")
     || AVSparameter_changed("Last step")) {
    if(cur_step >last_step) {
      cur_step=last_step;
    }
    if(cur_step < first_step) {
      cur_step=first_step;
    }
      AVSmodify_parameter("First step",AVS_MAXVAL+AVS_VALUE,
                         cur_step,0,last_step);
      AVSmodify_parameter("Current step",AVS_MAXVAL+AVS_VALUE,
                         cur_step,0,last_step);
      AVSmodify_parameter("Last step",AVS_MAXVAL+AVS_VALUE,
                         last_step,0,last_step);
  }

  if(cur_step <first_step) return(0);
  if(sleep) return(0);

  if(cur_step > last_step) {
    AVSmodify_parameter("Sleep",AVS_VALUE,1,0,0);
  }
  else {
    (mode == FILE_LIST) ? (ptr=file_list) : (ptr=file_name);
    if( wr_step(input,ptr,cur_step)) {
#ifdef DEBUG
  printf("Problem with step file");
#endif
      last_step= cur_step-1;
      AVSmodify_parameter("Sleep",AVS_VALUE,1,0,0);
      if(last_step < 0) AVSerror("No data supplied");
      else {
        AVSmodify_parameter("First step",
           AVS_MAXVAL, 0,0,ls);
        AVSmodify_parameter("Current step",
           AVS_MAXVAL+AVS_VALUE, last_step,0,ls);
        AVSmodify_parameter("Last step",
           AVS_MAXVAL+AVS_VALUE,last_step,0,ls);
      }
      AVSmodify_parameter("Sleep",AVS_VALUE,1,0,0);
    }
    else {
      cur_step++;
      if(cur_step > max_step) max_step=cur_step;
      AVSmodify_parameter("Current step",AVS_VALUE|AVS_MAXVAL,
         cur_step,0,max_step);
    }
  }
  return(1);
}




/*-----------------------------------------------------*
 *                                                     *
 *          ****  read_ucd_init  ****                  *
 *                                                     *
 *-----------------------------------------------------*/

read_ucd_init()
{
  AVSstatic = (char *)0;
  file_version=UCD_ASCII_FILE;

}


/*-----------------------------------------------------*
 *                                                     *
 *          ****  read_ucd_finis  ****                 *
 *                                                     *
 *-----------------------------------------------------*/

read_ucd_finis()
{
  
  free_all();
  if (AVSstatic == NULL) return;
  
  free (AVSstatic);
}



read_ucd_desc()
{
  char label[UCD_LABEL_LEN];
  
  int compute(), param;
  
  
  /**************
   ***  body  ***
   **************/
  
  AVSset_module_name ("WrUcdAnim", MODULE_RENDER);
  
  AVScreate_input_port ("tet output", "ucd",OPTIONAL);
  
  param = AVSadd_parameter ("File name", "string", 0, 0, ".inp");
  AVSconnect_widget (param, "browser");
  param = AVSadd_parameter ("File list", "string", 0, 0, ".list");
  AVSconnect_widget (param, "browser");

  param = AVSadd_parameter ("File type", "choice",
          "Ascii","Ascii^Binary3.0^Binary3.5+","^");
  param = AVSadd_parameter ("StoreNodePos", "boolean", 0, 0, 1);
  param = AVSadd_parameter ("StoreNodeData", "boolean", 1, 0, 1);
  param = AVSadd_parameter ("StoreCellData", "boolean", 1, 0, 1);
  param = AVSadd_parameter ("StoreModelData", "boolean", 1, 0, 1);
  param = AVSadd_parameter ("File select mode", "choice",
          "Sequence num.","One file^Sequence num.^File list","^");
  param = AVSadd_parameter ("Sleep", "boolean", 0, 0, 1);
  param = AVSadd_parameter ("First step", "integer", 0, 0, 256);
  param = AVSadd_parameter ("Current step", "integer", 0, 0, 1);
  param = AVSadd_parameter ("Last step", "integer", 256, 0, 256);
  
  AVSset_init_proc (read_ucd_init);
  
  AVSset_destroy_proc (read_ucd_finis);
  
  AVSset_compute_proc (compute);
  
#ifndef sep_exe
  AVSset_module_flags (COOPERATIVE);
#endif
}
