/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include "wr_ucd.h"

static FILE *fp=NULL;
static int prvstep = -2;

get_step_name(string,file_name,step)
char *string,*file_name;
int step;
{
  int i;
  switch(mode) {
    case SAME_FILE:
      strcpy(string,file_name);
      break;
    case SEQ_NUM:
      if(strchr(file_name,'%')) {
        sprintf(string,file_name,step);
      }
      else 
        sprintf(string,"%s.%02d",file_name,step);
      break;
    case FILE_LIST:
      if(step == prvstep +1) {
        fscanf(fp,"%s\n",file_name);
      }
      else
      {
        if(fp) fclose(fp);
        fp=fopen(file_name,"r");
        for(i=0;i<=step;i++) {
          if(fscanf(fp,"%s\n",string) != 1)
            return(1);
        }
      }
      break;
    default:
      AVSerror("Invalid selection mode : %d",mode);
  }
#ifdef DEBUG
  printf("Selected file : %s (mode %d)\n",string,mode);
#endif
  return(0);

}

