/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include "wr_ucd.h"

/*-----------------------------------------------------*
 *                                                     *
 *               ****  wr_ascii  ****                *
 *                                                     *
 * read a ucd ascii file.                              *
 *-----------------------------------------------------*/

wr_ascii (input)
UCD_structure *input;
{
    int name,mat_type,cell_type,me_flag;
    int *node_list;
    char el_type[100];
  
  int node,  cell, n, k, *node_ids, *node_ind,
  cell_id, mat_id, i, node_lst[UCD_MAX_NODE_PER_CELL], 
  util_flag, data_len, j, sum,
  ucd_cell_type, num_nlist_nodes;
  
  Ntype *cell_nlists;
  
  static char *cell_list[] = {"pt", "line", "tri", "quad", "tet",
				"pyr", "prism", "hex"};
  
  /**************
   ***  body  ***
   **************/
  
  
  rewind(anim_desc);

  put_header();

  for (node = 0; node < model_stats.num_nodes; node++) {
    fprintf (anim_desc, "%d %f %f %f\n", node,
      model_stats.xc[node],model_stats.yc[node],model_stats.zc[node]);
  }
  
  for (cell = 0; cell < model_stats.num_cells; cell++) {
   
    UCDcell_get_information(input,cell,&name,el_type,&mat_type,&cell_type,
    &me_flag,&node_list);
    fprintf(anim_desc,"%d %d %s ",name,mat_type,cell_list[cell_type]);
    for(i=0;i<UCD_num_nodes[cell_type];i++) {
      fprintf(anim_desc,"%d ",node_list[i]);
    }
    for(i=0;i<UCD_num_nodes[cell_type];i++) {
      if(!me_flag) break;
      if( me_flag &  (0x1 << i)) {
        fprintf(anim_desc,"%d ",node_list[i]);
        me_flag &= ! (0x1 << i) ;
      }
    }

    fprintf(anim_desc,"\n");
  }
  if (!wr_data (anim_desc, 
    model_stats.node_data_labels, model_stats.nd_delim,model_stats.node_data_units,
     model_stats.nu_delim, &model_stats.num_node_comp, model_stats.node_comp_list, 
    model_stats.num_node_data )) {
    fclose (anim_desc);
    anim_desc=0;
    return(0);
  }
    
  if (!wr_data (anim_desc,
    model_stats.cell_data_labels, model_stats.cd_delim,model_stats.cell_data_units,
    model_stats.cu_delim, &model_stats.num_cell_comp, model_stats.cell_comp_list,
    model_stats.num_cell_data)) {
    fclose (anim_desc);
    anim_desc=0;
    return(0);
  }
    
  if (!wr_data (anim_desc,
    model_stats.model_data_labels,  model_stats.md_delim,model_stats.model_data_units,
    model_stats.mu_delim, &model_stats.num_model_comp, model_stats.model_comp_list,
    model_stats.num_model_data)) {
    fclose (anim_desc);
    anim_desc=0;
    return(0);
  }
  return(1);
}
