/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include "wr_ucd.h"

wr_binary3_0 (input)
UCD_structure *input;
{
  char 	magic=5;
  
  Ctype *cells;
  
  int me_flag;
  char el_type[100];
  
  float *xc, *yc, *zc, *node_data, *cell_data, *model_data, x, y, z,
  *min_node_data, *max_node_data, *min_cell_data, *max_cell_data,
  *min_model_data, *max_model_data;
  
  int node, cell, n, num_node_data, 
  num_cell_data, num_model_data, cell_id, mat_id, i, node_list[UCD_MAX_NODE_PER_CELL],
  pos, util_flag, data_len, j, *cell_list,  
  *cell_nlists,*ptr;

  int blank[20],tab[20];
  
  /**************
   ***  body  ***
   **************/
  
#ifdef DEBUG
  printf("Wr_bin_3.0\n");
#endif

  for(i=0;i<20;i++) blank[i]=0;

  
  fwrite ((char *)&magic, sizeof(char), 1, anim_desc);
  
  fwrite ((char *)model_stats.node_data_labels, sizeof(char), 100, anim_desc);
  fwrite ((char *)model_stats.cell_data_labels, sizeof(char), 100, anim_desc);
  fwrite ((char *)model_stats.model_data_labels, sizeof(char), 100, anim_desc);
  fwrite ((char *)model_stats.node_data_units, sizeof(char), 100, anim_desc);
  fwrite ((char *)model_stats.cell_data_units, sizeof(char), 100, anim_desc);
  fwrite ((char *)model_stats.model_data_units, sizeof(char), 100, anim_desc);
  
  fwrite ((char *)(&model_stats.num_nodes), sizeof(int), 1, anim_desc);
  fwrite ((char *)(&model_stats.num_cells), sizeof(int), 1, anim_desc);
  fwrite ((char *)(&model_stats.num_node_data), sizeof(int), 1, anim_desc);
  fwrite ((char *)(&model_stats.num_cell_data), sizeof(int), 1, anim_desc);
  fwrite ((char *)(&model_stats.num_model_data), sizeof(int), 1, anim_desc);
  
  if(model_stats.num_node_data)
    fwrite ((char *)model_stats.node_active_list, sizeof(int), 20, anim_desc);
  else
    fwrite ((char *)blank, sizeof(int), 20, anim_desc);
  if(model_stats.num_cell_data)
    fwrite ((char *)model_stats.cell_active_list, sizeof(int), 20, anim_desc);
  else
    fwrite ((char *)blank, sizeof(int), 20, anim_desc);
  if(model_stats.num_model_data)
    fwrite ((char *)model_stats.model_active_list, sizeof(int), 20, anim_desc);
  else
    fwrite ((char *)blank, sizeof(int), 20, anim_desc);
  
  fwrite ((char *)(&model_stats.num_node_comp), sizeof(int), 1, anim_desc);
  if(model_stats.num_node_data)
    fwrite ((char *)model_stats.node_comp_list, sizeof(int), 20, anim_desc);
  else
    fwrite ((char *)blank, sizeof(int), 20, anim_desc);
  fwrite ((char *)(&model_stats.num_cell_comp), sizeof(int), 1, anim_desc);
  if(model_stats.num_cell_data)
    fwrite ((char *)model_stats.cell_comp_list, sizeof(int), 20, anim_desc);
  else
    fwrite ((char *)blank, sizeof(int), 20, anim_desc);
  fwrite ((char *)(&model_stats.num_model_comp), sizeof(int), 1, anim_desc);
  if(model_stats.num_model_data)
    fwrite ((char *)model_stats.model_comp_list, sizeof(int), 20, anim_desc);
  else
    fwrite ((char *)blank, sizeof(int), 20, anim_desc);
  

  model_stats.num_nlist_nodes=input->node_conn_size;
  cells=(Ctype *) malloc(model_stats.num_cells*sizeof(Ctype));
  cell_nlists=(int *) malloc(sizeof(int) * input->node_conn_size);

  pos=0;
  for(i=0;i<model_stats.num_cells;i++) {
    ptr= tab;
    UCDcell_get_information(input,i,&cells[i].id,el_type,&cells[i].mat,
      &cells[i].cell_type,&me_flag,&ptr);
      cells[i].n=UCD_num_nodes[cells[i].cell_type];
       for(j=0;j<UCD_num_nodes[cells[i].cell_type];j++) {
        cell_nlists[pos++] = *ptr++ +1;
      } 
  }

  model_stats.num_nlist_nodes=pos;

  fwrite ((char *)&model_stats.num_nlist_nodes, sizeof(int), 1, anim_desc);
  fwrite  ((char *)cells, sizeof(Ctype), model_stats.num_cells, anim_desc);
  fwrite  ((char *)cell_nlists, sizeof(int), model_stats.num_nlist_nodes, anim_desc);
  
  free(cells);
  free(cell_nlists);

  fwrite ((char *)model_stats.xc, sizeof(float), model_stats.num_nodes, anim_desc);
  fwrite ((char *)model_stats.yc, sizeof(float), model_stats.num_nodes, anim_desc);
  fwrite ((char *)model_stats.zc, sizeof(float), model_stats.num_nodes, anim_desc);

    fwrite ((char *)model_stats.min_node_data, sizeof(float), model_stats.num_node_data, anim_desc);
    fwrite ((char *)model_stats.max_node_data, sizeof(float), model_stats.num_node_data, anim_desc);
    fwrite ((char *)model_stats.node_data, sizeof(float), model_stats.num_node_data * model_stats.num_nodes, anim_desc);
    fwrite ((char *)model_stats.min_cell_data, sizeof(float), model_stats.num_cell_data, anim_desc);
    fwrite ((char *)model_stats.max_cell_data, sizeof(float), model_stats.num_cell_data, anim_desc);
    fwrite ((char *)model_stats.cell_data, sizeof(float), model_stats.num_cell_data * model_stats.num_cells, anim_desc);
    fwrite ((char *)model_stats.min_model_data, sizeof(float), model_stats.num_model_data, anim_desc);
    fwrite ((char *)model_stats.max_model_data, sizeof(float), model_stats.num_model_data, anim_desc);
    fwrite ((char *)model_stats.model_data, sizeof(float), model_stats.num_model_data, anim_desc);

  
  return(1);
}
