/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include "wr_ucd.h"
wr_step(input,file_name,step)
UCD_structure *input;
int step;
char *file_name;
{

  int stat=0;

  FILE *fp;

  char string[256];

  if(get_step_name(string,file_name,step)) return(1);
  if(mode == SAME_FILE) {
    fp=anim_desc;
    if(step != prev_step+1)  {
#ifdef DEBUG
    printf("File pos : %x; moving from step %d to %d\n",
      FilePos,prev_step,step);
#endif
      if(FilePos[step]) fseek(fp,FilePos[step],SEEK_SET);
      else {
        AVSerror("Move in single file only with preload");
        return(1);
      }
    }
    else {
      FilePos[step]=ftell(fp);
    }
  }
  else {
    fp=fopen(string,RwMode);
    if(!fp) {
      perror("Open");
      AVSerror("Can`t open %s for step %d",string,step);
      return(1);
    }
  }

#ifdef DEBUG
  printf("Wr_step %d @ %x %s, version %d\n", step,input,file_name,file_version);
#endif

  get_ucd(input);
  if (file_version == UCD_ASCII_FILE) {
    wr_step_ascii(fp);
  }
  else if (file_version == UCD_BINARY_3_0
         ||file_version == UCD_BINARY_3_5) {
   stat=wr_step_binary3_0(fp);

  }
  if(mode == SAME_FILE) {
    if(!FilePos[step+1]) FilePos[step+1]=ftell(fp);
  }
  else fclose(fp);

  prev_step=step;
  return(stat);
}
