/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include "wr_ucd.h"
/*-----------------------------------------------------*
 *                                                     *
 *               ****  wr_ucd  ****                  *
 *                                                     *
 * write a file (ascii or binary) in the ucd format.    *
 * if the file is binary then it is assumed it was     *
 * created using the ucd_write module.                 *
 *                                                     *
 *-----------------------------------------------------*/

/*--------------------------------------------------------------------
 *      Read UCD module
 *--------------------------------------------------------------------*/
wr_ucd (input, file_name)
     char *file_name;
     UCD_structure *input;
{
  
  char data_labels[UCD_LABEL_LEN], cell_labels[UCD_LABEL_LEN],
  node_labels[UCD_LABEL_LEN], node_units[UCD_LABEL_LEN], 
  cell_units[UCD_LABEL_LEN],	data_units[UCD_LABEL_LEN], *model_name, tmp_str[80];
  
  float x, y, z, xmin, xmax, ymin, ymax, zmin, zmax, min_extent[3], 
  max_extent[3];
  
  int node, num_mats, *node_id, cell, n, i, 
  node_list[UCD_MAX_NODE_PER_CELL], 
  util_flag, j, ucd_flags, cell_tsize, node_csize; 
  
  Ctype *cells;
  
  float extent[6], *xc, *yc, *zc;
  
  int active_list[10], comp_list[10], 
  num_nodes, num_cells, num_node_data, num_cell_data, num_model_data,
  *bcell_nlists;
  int 	*node_active_list, *cell_active_list, *model_active_list,
  num_node_comp, *node_comp_list, num_cell_comp, *cell_comp_list,
  num_model_comp, *model_comp_list;
  
  Ntype *cell_nlists;
  
  static int clist[] = {1, 2, 3, 4}; 
  
  Ucd_Stats_Type *ucd_stats;
  
  /**************
   ***  body  ***
   **************/
  
  if (!file_name) 
    return(0);

  anim_desc=fopen(file_name,RwMode);
#ifdef DEBUG
  printf("Wr_ucd : File=%s; descr=%x\n",file_name,anim_desc);
#endif
  if(!anim_desc) {
      AVSerror (" Error in wr_ucd: can't write file.\n%s\n", file_name);
      return (0);
  }

  
    get_ucd(input);
    
    switch(file_version) {
      case UCD_ASCII_FILE:
        if (!wr_ascii (input)) {
  	AVSerror (" Error in wr_ucd: can't write file.\n%s\n", file_name);
  	return (0);
        }
        break;
      case UCD_BINARY_3_0:
        if (!wr_binary3_0 (input)) {
  	AVSerror (" Error in wr_ucd: can't write bin file.\n%s\n", file_name);
  	return (0);
        }
        put_header();
        break;
      case UCD_BINARY_3_5:
        if (!wr_binary3_5 (input)) {
  	AVSerror (" Error in wr_ucd: can't write bin file.\n%s\n", file_name);
  	return (0);
        }
        put_header();
        break;
    }
    return(1);
}
