/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "avs2vrml" (Output) (Subroutine)                         */
/* Author: John Evans                                                    */
/* Date Created: Mon Aug 14 10:12:21 1995                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* input 0 "geom" geom REQUIRED                                          */
/* param 0 "filename" browser "fname" "" ":"                             */
/* param 1 "draw_polylines" toggle 0 0 1                                      */
/* param 2 "draw_djpolylines" toggle 0 0 1                                    */
/* param 3 "draw_label" toggle 0 0 1                                     */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
 
#include <avs/geom_edit.h>

#define TRUE 1
#define FALSE 0
/*
 * These variables determine whether or not we want to take a chance and
 * try writing out Ascii_Text nodes as well as polylines.  Default is NO.
 */
static int No_Ascii,
           No_Polylines,
           No_Disjoint_Polylines;


void ProcessEditList ( GEOMedit *geom, char *fNBase );


/*
 * These routines provide the basic logic to interpret the various data
 * structures. 
 */
void mesh_2_vrml ( GEOMobj *obj, FILE *vrml_fp );
void polytri_2_vrml ( GEOMobj *obj, FILE *vrml_fp );
void polyhedron_2_vrml ( GEOMobj *obj, FILE *vrml_fp );
void sphere_2_vrml ( GEOMobj *obj, FILE *vrml_fp );
void label_2_vrml ( GEOMobj *obj, FILE *vrml_fp );

/*
 * The polytriangle data structure is a little more complicated than
 * others, so some extra routines are provided to respectively handle the
 * polytriangle strips, polylines, and disjoint polylines.
 */
void write_pt_verts_nodes ( GEOMobj *obj, FILE *vrml_fp );
void write_pt_polyline_nodes ( GEOMobj *obj, FILE *vrml_fp );
void write_pt_disjoint_polyline_node ( GEOMobj *obj, FILE *vrml_fp );




/*
 * These routines define VRML Coord, Material, Normal, and Info nodes.
 * They are accessible from all the above routines.
 */
void write_coords ( GEOMobj       *object, 
		    GEOMvert_list *vertex_list, 
		    int            vertex_list_index, 
		    FILE          *vrml_file );

void write_colors ( GEOMobj       *object, 
		    GEOMvert_list *color_list, 
		    int            color_list_index, 
		    FILE          *vrml_file );

void write_normals ( GEOMobj       *obj,
		     GEOMvert_list *normal_list,
		     int            normal_list_index,
		     FILE          *vrml_fp );

void write_face_connectivity( GEOMobj *obj,
			      int obj_index,
			      FILE *vrml_fp );

void write_object_information ( GEOMobj *obj, 
				FILE *vrml_fp );



/*
 * The following routines are very low level.  They merely print out the
 * vertices and their indices in various fashions.
 */
void print_vertex_list ( GEOMvert_list *v, 
			int num_objects,
			FILE *vrml_fp );
void print_pt_indices ( GEOMvert_list *v, 
			int num_objects,
			FILE *vrml_fp );
void print_ph_indices ( GEOMpolyh *ph,
			FILE *vrml_fp ); 
void print_mesh_indices ( GEOMmesh *mesh, 
			  FILE *vrml_fp );
void print_disjoint_line_indices ( GEOMvert_list *line, 
				  FILE *vrml_fp );




/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int avs2vrml_desc()
{

	int in_port, out_port, param, iresult;
	extern int avs2vrml_compute();

	AVSset_module_name("avs2vrml", MODULE_RENDER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("Geom_In", "geom", REQUIRED);

	/* Parameter Specifications                */
	param = AVSadd_parameter("VRML filename", "string", "fname.wrl", "", 
		"");
	AVSconnect_widget(param, "browser");
	param = AVSadd_parameter("draw_polylines", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("draw_djpolylines", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("draw_label", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	AVSset_compute_proc(avs2vrml_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int avs2vrml_compute( GEOMedit_list Geom_In, 
		      char *VRML_filename, 
		      int draw_polylines, 
		      int draw_djpolylines,
		      int draw_label)
{

/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */

  /*
   * Set the global flags.
   */
  No_Ascii = 1 - draw_label;
  No_Polylines = 1 - draw_polylines;
  No_Disjoint_Polylines = 1 - draw_djpolylines;


        if ((Geom_In == NULL) || (Geom_In->l == NULL)) {
                fprintf(stderr, "avs2vrml_compute:  null edit list.\n");
        }
        else {
                ProcessEditList(Geom_In->l, VRML_filename );
        }

/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
static int ((*mod_list[])()) = {
	avs2vrml_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 





/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/

/*
 * ProcessEditList
 *
 * This routine cycles through the avs geometry, writing vrml translations as
 * it goes.
 */
void ProcessEditList ( GEOMedit *geom, char *fNBase )
{

   FILE *vrml_fp;                  /* VRML file to write.                 */

   GEOMobj *obj = NULL;            /* Allows us to access geometry types. */

   time_t now;                     /* For the info node.                  */
   char str_time[80],              /* For the info node. */
        *new_line_ptr;             /* Points to newline character in a
				      string. */

   /*
    * Write out the required VRML header
    */ 
   if ( (vrml_fp = fopen ( fNBase, "w" )) == NULL ) {
      fprintf ( stderr, "Can't create vrml file %s.\n", fNBase );
      exit ( EXIT_FAILURE );
   }
  
   fprintf ( vrml_fp, "#VRML V1.0 ascii\n\n" );
   


   /*
    * Write out the information node.
    */
   fprintf ( vrml_fp, "Info {\n" );
   fprintf ( vrml_fp, "\tstring \n\t\"\n\tCreated by avs2vrml\n" );
   fprintf ( vrml_fp, "\tcontact:  John Evans\n" );
   fprintf ( vrml_fp, "\tUnited States Geological Survey\n" );
   fprintf ( vrml_fp, "\tBranch of Atlantic Marine Geology\n" );
   fprintf ( vrml_fp, "\t384 Woods Hole Road, Quissett Campus\n" );
   fprintf ( vrml_fp, "\tWoods Hole, MA  02543-1598\n" );
   fprintf ( vrml_fp, "\tE-mail:  jevans@usgs.gov\n" );
   time ( &now );
   strcpy ( str_time, ctime ( &now ) );

   /*
    * Get rid of offending newline character returned by ctime
    */
   new_line_ptr = strchr ( str_time, '\n' );
   if ( new_line_ptr != (char *)NULL )
     *new_line_ptr = '\0';

   fprintf ( vrml_fp, "\t%s\n\t\"\n", str_time );
   fprintf ( vrml_fp, "}\n\n\n" );
	    


   /*
    * While moredata 
    */
   while ( geom != NULL ) {
      
      if ( geom->type == GEOM_EDIT_GEOMETRY ) {
	 obj = (GEOMobj *)(geom->data);

	 if (obj == NULL) {
	    fprintf(stderr, "avs2vrml:  null GEOMobj.\n");
	    return;
	 }
	 
	 switch (obj->type) {
	 case GEOM_MESH:
	    mesh_2_vrml ( obj, vrml_fp );
	    /* not implemented */
	    break;

	 case GEOM_POLYTRI:
	    polytri_2_vrml ( obj, vrml_fp );
	    break;

	 case GEOM_POLYHEDRON:
	    polyhedron_2_vrml ( obj, vrml_fp );
	    break;

	 case GEOM_SPHERE:
	    sphere_2_vrml ( obj, vrml_fp );
	    break;

	 case GEOM_LABEL:
	    label_2_vrml ( obj, vrml_fp );
	    break;

	 default:
	    fprintf(stderr,
		    "avs2vrml:  strange object type.\n");
	    break;
	 };

 

      }

      geom = geom->next;


   /*
    * end while
    */
   }


   /*
    * close the vrml file
    */
   fclose ( vrml_fp );

}






/* ******************************************************************
 * 
 * The following five routines provide the basic logic for 
 * interrogating the avs GEOMobj possibilities.
 *
 * ****************************************************************** */
 


/*
 * mesh_2_vrml
 *
 * Since there aren't too many meshes around to play with,
 * I'm assuming that the color information is done the same
 * way here as it is with polytriangle strips.
 */
void mesh_2_vrml ( GEOMobj *obj, FILE *vrml_fp )
{

   GEOMmesh *mesh = &(obj->d.m);      /* The actual mesh information
					 is here.                    */
                                


   fprintf ( vrml_fp, "Separator {\n\n" );
   write_object_information ( obj, vrml_fp );
   write_coords ( obj, &(mesh->verts), 0, vrml_fp );
   if ( mesh->colors.n > 0 )
       write_colors (obj, &(mesh->colors), 0, vrml_fp );
   if ( mesh->normals.n > 0 )
       write_normals (obj, &(mesh->normals), 0, vrml_fp );
   write_face_connectivity( obj, 0, vrml_fp );
   fprintf ( vrml_fp, "}\n" );   

}





/*
 * polytri_2_vrml
 *
 * Converts an avs polytriangle data structure to vrml
 */
void polytri_2_vrml ( GEOMobj *obj, FILE *vrml_fp )
{
   int i, j;                      /* indices */
   
   GEOMpolytri *pt = &(obj->d.pt);



   /*
    * create a node and it's information
    */
   fprintf ( vrml_fp, "Separator {\n\n" );
   write_object_information ( obj, vrml_fp );

   
   /*
    * If one or more polytriangle objects, print them out.
    */
   if ( pt->npts > 0 )
       write_pt_verts_nodes ( obj, vrml_fp );

   /*
    * If one or more polyline objects, print them out.
    */
   if ( pt->npls > 0 )
       write_pt_polyline_nodes ( obj, vrml_fp );


   /*
    * If any disjoint line data, write it out.
    */
   if ( pt->dlverts.n > 0 )
       write_pt_disjoint_polyline_node ( obj, vrml_fp );


   /*
    * Close out the node
    */
   fprintf ( vrml_fp, "}\n" );   


}





/*
 * polyhedron_2_vrml
 *
 */
void polyhedron_2_vrml ( GEOMobj *obj, FILE *vrml_fp )
{
   GEOMpolyh *ph = &(obj->d.ph);         /* The actual polyhedron info
					    is stored here.            */

       
   fprintf ( vrml_fp, "Separator {\n\n" );
      
   write_coords ( obj, &(ph->verts), 0, vrml_fp );
   if ( ph->normals.n > 0 ) 
       write_normals ( obj, &(ph->normals), 0, vrml_fp );
   if ( ph->colors.n > 0 ) 
       write_colors (obj, &(ph->colors), 0, vrml_fp );

   write_face_connectivity( obj, 0, vrml_fp );

   fprintf ( vrml_fp, "}\n" );
   

}





/*
 * sphere_2_vrml
 *
 * This works, but it is also extremely slow.  I'd advise
 * against having a large number of spheres...
 */
void sphere_2_vrml ( GEOMobj *obj, FILE *vrml_fp )
{
   
   GEOMsphere *sphere = &(obj->d.sp);           /* The actual sphere info
						   is stored here.        */
   int i,
       colors;


   if ( sphere->colors.n > 0 )
       colors = TRUE;
   else
       colors = FALSE;


   for ( i = 0; i < sphere->verts.n; ++i ) {

      /*
       * create a node
       */
      fprintf ( vrml_fp, "Separator {\n\n" );
      
      /*
       * If color information exists, write it out.  Otherwise
       * specify white as a default.
       */
      if ( colors ) 
	  fprintf ( vrml_fp, "\tMaterial { diffuseColor %.3f %.3f %.3f }\n",
		   sphere->colors.l[3 * i],
		   sphere->colors.l[3 * i + 1],
		   sphere->colors.l[3 * i + 2] );
      else
	  fprintf ( vrml_fp, "\tMaterial { diffuseColor 1.0 1.0 1.0 }\n" );
		    

      fprintf ( vrml_fp, "\tTranslation { translation %.3f %.3f %.3f }\n",
		   sphere->verts.l[3 * i],
		   sphere->verts.l[3 * i + 1],
		   sphere->verts.l[3 * i + 2] );
      fprintf ( vrml_fp, "\tSphere { radius %.3f }\n",
	           sphere->radii.l[i] );

      
      /*
       * Close out the node
       */
      fprintf ( vrml_fp, "}\n" );
      
   }

}





/*
 * label_2_vrml
 *
 * Unknown how this works yet.  My VRML browser doesn't support
 * AsciiText nodes.  I'm guessing...
 */
void label_2_vrml ( GEOMobj *obj, FILE *vrml_fp )
{
   GEOMlabel *l = &(obj->d.la);           /* The actual label information
					     is stored here.              */
   int l_index;                           /* label index */


   /*
    * First check the parameter to see if we wanted to do ascii.
    */
   if ( No_Ascii ) {
     return;
   }

   else {     
     for ( l_index = 0; l_index < l->labels.n; ++l_index ) {
       
       /*
	* create a text node
	*
	* Not sure about the size, spacing, width crap.  
	* Best to go with something easy, use defaults...
	*/
       fprintf ( vrml_fp, "Separator {\n\n" );
       fprintf ( vrml_fp, "\tTranslation { translation %.3f %.3f %.3f }\n",
		 l->verts.l[0],
		 l->verts.l[1],
		 l->verts.l[2] );
       fprintf ( vrml_fp, "\tFontStyle {\n" );
       fprintf ( vrml_fp, "\t\tsize %.3f\n", l->heights.l[l_index] );
       fprintf ( vrml_fp, "\t\tfamily SERIF\n");
       fprintf ( vrml_fp, "\t\tstyle NONE\n" );
       
       /*
	* write out the label information
	*/
       fprintf ( vrml_fp, "\tAsciiText {\n" );
       fprintf ( vrml_fp, "\t\tstring \"%s\"\n", l->labels.l[l_index] );
       fprintf ( vrml_fp, "\t\tspacing 1\n" );
       fprintf ( vrml_fp, "\t\tjustification LEFT\n" );
       
       /*
	* Use natural width.
	*/
       fprintf ( vrml_fp, "\t\twidth 0\n" );
       fprintf ( vrml_fp, "\t}");
       
       
       /*
	* Close out the node
	*/
       fprintf ( vrml_fp, "}\n" );
       
       
       /* 
	* Loop back for the next label.
	*/
       
     }
     
   }
   
}



/* ******************************************************************
 * 
 * The following three routines apply only to polytriangle 
 * structure.
 *
 * ****************************************************************** */
 


/*
 * write_pt_verts_nodes
 * 
 * Prints out all the polytriangle strips present.  This includes the
 * vertices, connectivity, and colors.
 */
void write_pt_verts_nodes ( GEOMobj *obj, FILE *vrml_fp )
{
   GEOMpolytri *pt = &(obj->d.pt); /* The actual polytriangle info
				      is stored here.                */

   int obj_index;                  /* index as to which polytriangle
				      we're dealing with             */


   for ( obj_index = 0; obj_index < pt->npts;  ++obj_index ) {

      /*
       * create a node, writing out vertex, color, and normal information
       */
      fprintf ( vrml_fp, "\tSeparator {\n\n" );
      write_coords ( obj, pt->ptverts, obj_index, vrml_fp );
      write_colors ( obj, pt->ptcolors, obj_index, vrml_fp );
      write_normals ( obj, pt->ptnormals, obj_index, vrml_fp );
      write_face_connectivity( obj, obj_index, vrml_fp );
      fprintf ( vrml_fp, "\t}\n" );
   }



}




/*
 * write_pt_polyline_nodes
 * 
 * This routine cycles through a list of polylines within a polytriangle
 * structure, printing out the vertices, connectivity, and colors.
 */
void write_pt_polyline_nodes ( GEOMobj *obj, FILE *vrml_fp )
{

   GEOMpolytri *pt = &(obj->d.pt); /* The actual polytriangle info
				      is stored here.                */

   int line_index;                  /* index as to which polyline
				       we're dealing with             */
   int i;                           /* index into line vertices       */



   /*
    * First check the parameter to see if we wanted to do polylines.
    */
   if ( No_Polylines ) {
     return;
   }

   else {

     for ( line_index = 0; line_index < pt->npls;  ++line_index ) {
       
       /*
	* create a node
	*/
       fprintf ( vrml_fp, "\tSeparator {\n\n" );
       write_coords ( obj, pt->plverts, line_index, vrml_fp );
       
       
       /*
	 fprintf ( vrml_fp, "\t\tMaterial { diffuseColor 1.0 1.0 1.0 }\n\n" );
	 */
       
       write_colors ( obj, pt->plcolors, line_index, vrml_fp );
       
       
       
       /*
	* Write out the connectivity of the polyline.  
	*/
       fprintf ( vrml_fp, "\t\tIndexedLineSet {\n" );
       fprintf ( vrml_fp, "\t\t\tcoordIndex [\n" );
       
       for ( i = 0; i < pt->plverts[line_index].n - 1; ++i ) 
	 fprintf ( vrml_fp, "\t\t\t\t%d,\n", i );
       fprintf ( vrml_fp, "\t\t\t\t%d, -1\n", pt->plverts[line_index].n-1 );
	 
       fprintf ( vrml_fp, "\t\t\t\t]\n" );
       
       fprintf ( vrml_fp, "\t\t}\n\n\n" );
       
       
       
       /*
	* Close out the node
	*/
       fprintf ( vrml_fp, "\t}\n" );
       
       
       /* 
	* Loop back for the next polyline object.
	*/
     }
     
   }

}



/*
 * write_pt_disjoint_polyline_nodes
 *
 * This routine handles a disjoint polyline within a polytriangle
 * structure, printing out the vertices, connectivity, and colors.
 */
void write_pt_disjoint_polyline_node ( GEOMobj *obj, FILE *vrml_fp )
{

   GEOMpolytri *pt = &(obj->d.pt); /* The actual polytriangle info
				      is stored here.                */


   /*
    * First check the parameter to see if we wanted to do polylines.
    */
   if ( No_Disjoint_Polylines ) {
     return;
   }

   else {
     /*
      * create a node
      */
     fprintf ( vrml_fp, "\tSeparator {\n\n" );
     
     
     write_coords ( obj, &(pt->dlverts), 0, vrml_fp );
     
     
     /*
       fprintf ( vrml_fp, "\t\tMaterial { diffuseColor 1.0 1.0 1.0 }\n\n" );
       */
     write_colors ( obj, &pt->dlcolors, 0, vrml_fp );
     
     
     /*
      * Write out the indices of the data.  
      */
     fprintf ( vrml_fp, "\t\tIndexedLineSet {\n" );
     print_disjoint_line_indices ( &(pt->dlverts), vrml_fp );
     fprintf ( vrml_fp, "\t\t}\n\n\n" );
     
     
     
     
     /*
      * Close out the node
      */
     fprintf ( vrml_fp, "\t}\n" );
     

   }

}




/* ******************************************************************
 * 
 * The following routines are rather low level, and can be pretty much
 * called upon from any of the routines above.
 *
 * ****************************************************************** */
 


/*
 * write_coords
 *
 * Writes out the coordinates of all points in the list pointed to by
 * vertex_list[index].  Remember that vertex_list[index] is a LIST of
 * points, not a single point.
 */
void write_coords ( GEOMobj *obj, 
		    GEOMvert_list *vertex_list, 
		    int index, 
		    FILE *vrml_fp )
{
      fprintf ( vrml_fp, "\t\tCoordinate3 {\n" );
      fprintf ( vrml_fp, "\t\t\tpoint\t[\n" );
      print_vertex_list ( vertex_list, index, vrml_fp );
      fprintf ( vrml_fp, "\t\t\t]\n" );
      fprintf ( vrml_fp, "\t\t}\n\n\n" );

}




/*
 * write_colors
 * 
 * Writes out the colors of all points in the vertex list.  Remember
 * that color_list[index] is a LIST of colors, not a single 3_tuple of
 * colors. 
 */
void write_colors ( GEOMobj *obj, 
		    GEOMvert_list *color_list,
		    int index, 
		    FILE *vrml_fp )
{
   if ( color_list != NULL ) {
      fprintf ( vrml_fp, "\tMaterial {\n" );
      fprintf ( vrml_fp, "\t\tdiffuseColor [\n" );
      print_vertex_list ( color_list, index, vrml_fp );
      fprintf ( vrml_fp, "\t\t\t]\n" );
      fprintf ( vrml_fp, "\t}\n\n\n" );
      fprintf ( vrml_fp, "\tMaterialBinding { value PER_VERTEX_INDEXED }\n\n\n" );
   }
   else {
      fprintf ( vrml_fp, "\tMaterial { diffuseColor 1.0 1.0 1.0 }\n" );
   }


}





/*
 * write_normals
 * 
 * Writes out the normals of all points in the vertex list.  Remember
 * that normal_list[index] is a LIST of colors, not a single 3_tuple of
 * colors. 
 */
void write_normals ( GEOMobj       *obj,
		     GEOMvert_list *normal_list,
		     int            index,
		     FILE          *vrml_fp )
{
		    
   /*
    * Write out the normals.
    */
   if ( normal_list != NULL ) {
      fprintf ( vrml_fp, "\tNormal {\n" );
      fprintf ( vrml_fp, "\t\tvector [\n" );
      print_vertex_list ( normal_list, index, vrml_fp );
      fprintf ( vrml_fp, "\t\t\t]\n" );
      fprintf ( vrml_fp, "\t}\n\n\n" );
      fprintf ( vrml_fp, 
	       "\tNormalBinding { value PER_VERTEX_INDEXED }\n\n\n" );
      
   }

   else {
      fprintf ( vrml_fp,
	       "\tNormalBinding { value DEFAULT }\n\n\n" );
   }
   
}






/*
 * write_face_connectivity
 */
void write_face_connectivity( GEOMobj *obj,
			      int obj_index,
			      FILE *vrml_fp )
{
   GEOMpolytri *pt = &(obj->d.pt);
   GEOMpolyh   *ph;
   GEOMmesh    *mesh;

   int i;                      /* Index for vertices */

   switch (obj->type) {
   case GEOM_MESH:
     mesh = &(obj->d.m);

     fprintf ( vrml_fp, "\tIndexedFaceSet {\n" );

     fprintf ( vrml_fp, "\t\tcoordIndex [\n" );
     print_mesh_indices ( mesh, vrml_fp );
     fprintf ( vrml_fp, "\t\t\t]\n" );

     if ( mesh->colors.n > 0 ) {
       fprintf ( vrml_fp, "\t\t\tmaterialIndex [\n" );
       print_mesh_indices ( mesh, vrml_fp );
       fprintf ( vrml_fp, "\t\t\t\t]\n" );
     }

     fprintf ( vrml_fp, "\t}\n\n\n" );
     break;
     
       
       
   case GEOM_POLYTRI:
     pt = &(obj->d.pt);

     fprintf ( vrml_fp, "\t\tIndexedFaceSet {\n" );

     fprintf ( vrml_fp, "\t\t\tcoordIndex [\n" );
     print_pt_indices ( pt->ptverts, obj_index, vrml_fp );
     fprintf ( vrml_fp, "\t\t\t\t]\n" );

     if ( pt->ptcolors != NULL ) {
       fprintf ( vrml_fp, "\t\t\tmaterialIndex [\n" );
       print_pt_indices ( pt->ptcolors, obj_index, vrml_fp );
       fprintf ( vrml_fp, "\t\t\t\t]\n" );
     }

     fprintf ( vrml_fp, "\t\t}\n\n\n" );

     break;
     
   case GEOM_POLYHEDRON:
     ph = &(obj->d.ph);

     fprintf ( vrml_fp, "\tIndexedFaceSet {\n" );

     fprintf ( vrml_fp, "\t\tcoordIndex [\n" );
     print_ph_indices ( ph, vrml_fp );
     fprintf ( vrml_fp, "\t\t]\n" );

     if ( ph->colors.n > 0 ) {
       fprintf ( vrml_fp, "\t\t\tmaterialIndex [\n" );
       print_ph_indices ( ph, vrml_fp );
       fprintf ( vrml_fp, "\t\t\t\t]\n" );
     }


     fprintf ( vrml_fp, "\t}\n\n\n" );
       
       
     break;
     
   default:
     fprintf(stderr,
	     "write_face_connectivity:  strange object type.\n");
     break;
   };
   
 

}






/*
 * write_object_information
 * 
 * This routine prints information about an AVS GEOMobj in a VRML info
 * field.  I use it for debugging purposes.  If you really want the
 * information, uncomment the first line. 
 *
 */
void write_object_information ( GEOMobj *obj, 
				FILE *vrml_fp )
{

  return;

  /*
   * create the node
   */
  fprintf ( vrml_fp, "\tInfo {\n" );
  fprintf ( vrml_fp, "\t\tstring\n\t\t\"\n\t\t" );


  /*
   * tell what type of geometry it was
   */
  switch ( obj->type ) {

  case GEOM_MESH:
    fprintf ( vrml_fp, "Converted from GEOM_MESH type\n" );
    break;

  case GEOM_POLYHEDRON:
    fprintf ( vrml_fp, "Converted from GEOM_POLYHEDRON type\n" );
    break;

  case GEOM_POLYTRI:
    fprintf ( vrml_fp, "Converted from GEOM_POLYTRI type\n" );
    break;

  case GEOM_SPHERE:
    fprintf ( vrml_fp, "Converted from GEOM_SPHERE type\n" );
    break;

  case GEOM_LABEL:
    fprintf ( vrml_fp, "Converted from GEOM_LABEL type\n" );
    break;

  default:
    fprintf ( stderr, "write_object_information:  unknown avs geometry type.\n" );
    exit (EXIT_FAILURE);
  }



  /*
   * tell what type of data there is
   */
  fprintf ( vrml_fp, "\t\tVertex Data Present:\t" );
  if ( obj->data & GEOM_NORMALS ) 
    fprintf ( vrml_fp, "GEOM_NORMALS\n" );
  else if ( obj->data & GEOM_VCOLORS )
    fprintf ( vrml_fp, "GEOM_VCOLORS\n" );
  else if ( obj->data & GEOM_UVS )
    fprintf ( vrml_fp, "GEOM_UVS\n" );
  else if ( obj->data & GEOM_UVWS )
    fprintf ( vrml_fp, "GEOM_UVWS\n" );
  else 
    fprintf ( vrml_fp, "none?\n" );



  /*
   * print extents
   */
  if ( obj->has_extent ) {
    fprintf ( vrml_fp, "\t\tBounding Box:\n" );
    fprintf ( vrml_fp, 
	      "\t\t\tmin x: %.4f\tmax x: %.4f\n", 
	      obj->extent[0], obj->extent[3] );
    fprintf ( vrml_fp, 
	      "\t\t\tmin y: %.4f\tmax y: %.4f\n", 
	      obj->extent[1], obj->extent[4] );
    fprintf ( vrml_fp, 
	      "\t\t\tmin z: %.4f\tmax z: %.4f\n", 
	      obj->extent[2], obj->extent[5] );
  }


  /*
   * print name information
   */
  fprintf ( vrml_fp, "\t\tName Information:\n" );
  fprintf ( vrml_fp, "\t\t\tName:  %s\n", obj->name );
  fprintf ( vrml_fp, "\t\t\tFilename:  %s\n", obj->filename );
  fprintf ( vrml_fp, "\t\t\tGroupname:  %s\n", obj->groupname );


  /*
   * not sure how to handle the name/value pairs
   */


  /*
   * close out the info node
   */
  fprintf ( vrml_fp, "\t\t\"\n" );
  fprintf ( vrml_fp, "\t}\n\n\n" );


}





/*
 * print_vertex_list
 *
 * Just dumps the numbers in a vertex list.  This can be actualy
 * vertices or even colors. 
 *
 * parameters
 * v_list_set:  set of vertex lists
 * obj_index:   indexes into the set of vertex lists, which ever vertex
 *              list we are to print
 * vrml_fp:  VRML file to write to
 */
void print_vertex_list ( GEOMvert_list *v_list_set, 
			 int set_index,
			 FILE *vrml_fp ) 
{
  GEOMvert_list *v = &(v_list_set[set_index]);   /* Points to particular
						    list to print. */

   int i;                                        /* which vertex are we
						    on? */ 

   /*
    * Loop through list until last 3-tuple of vertices, which is a special
    * case.  That 3-tuple won't have a following comma.
    */

   for (i = 0; i < v->n-1; i++) {
      fprintf(vrml_fp, "\t\t\t%.3f %.3f %.3f,\n",
	      v->l[3 * i],
	      v->l[3 * i + 1],
	      v->l[3 * i + 2]);
   }
   
   i = v->n-1;
   fprintf(vrml_fp, "\t\t\t%.3f %.3f %.3f\n",
	   v->l[3 * i],
	   v->l[3 * i + 1],
	   v->l[3 * i + 2]);
   

}





/*
 * print_pt_indices
 *
 * This routine describes the connectivity of a polytriangle strip.  Can
 * be uses to associate vertices or color.
 *
 * Connectivity is as follows.
 *
 *   0---------------1
 *   |            ...|     First triangle runs 0 1 2
 *   |         ...   |         
 *   |      ...      |
 *   |   ...         |     Second runs 1 2 3
 *   |...            |
 *   2---------------3
 *   |            ...|     Third runs 2 3 4
 *   |         ...   |
 *   |      ...      |
 *   |   ...         |     Fourth runs 3 4 5
 *   |...            |
 *   4---------------5
 *   |            ...|     etc.
 *   |         ...   |
 *   |      ...      |
 *   .               .
 *   .               .
 *
 */
void print_pt_indices ( GEOMvert_list *v, 
			int obj_index,
			FILE *vrml_fp ) 
{
   int i;                 /* which vertex are we on? */


   for (i = 0; i < (v[obj_index].n - 3); i++) {
      fprintf(vrml_fp, "\t\t\t%d, %d, %d, -1, \n", i, i+1, i+2 );
   }

   i = v[obj_index].n-3;
   fprintf(vrml_fp, "\t\t\t%d, %d, %d, -1\n", i, i+1, i+2 );
   

}





/*
 * print_ph_indices
 *
 * This routine describes the connectivity of a polyhedron.  Can
 * be uses to associate vertices or color.
 *
 * Connectivity is described in the code
 */
void print_ph_indices ( GEOMpolyh *ph,
			FILE *vrml_fp ) 
{
   int not_last_polygon;                 /* boolean flag */
   int i,                                /* polygon vertex index */
       num_vertices;                     /* Number of polygon
					    vertices in current
					    polygon.             */
   int *current_polygon;                 /* acts as an array of
					    vertices for the
					    current polygon    */

   not_last_polygon = TRUE;


   current_polygon =  ph->ptlist.l;
   
   while ( not_last_polygon ) {
     num_vertices = current_polygon[0];
     
     /* 
      * tab in before starting the polygon list.
      * Then list the vertices, remembering that AVS is
      * "1 based", and VRML is "0 based".
      */
     fprintf ( vrml_fp, "\t\t\t" );
     for ( i = 1; i <= num_vertices; ++i ) 
       fprintf ( vrml_fp, "%d, ", current_polygon[i]-1 );
       
       /* 
	* Now print the first vertex again to close the polygon,
	* and put a -1 on to tell VRML that.
	*/
       fprintf ( vrml_fp, "%d, -1,\n", current_polygon[1] );
       
       
       /*
	* Point to the next polygon.
	*/
       current_polygon = current_polygon+num_vertices+1;
       
       if ( current_polygon[0] == 0 )
	 not_last_polygon = FALSE;
	 
   }
   
   /*
    * print out the last polygon.  Only difference is that
    * there is no ending comma.
    */
   num_vertices = current_polygon[0];
   fprintf ( vrml_fp, "\t\t\t" );
   for ( i = 1; i <= num_vertices; ++i ) 
     fprintf ( vrml_fp, "%d, ", current_polygon[i]-1 );
     
   /* 
    * Now print the first vertex again to close the polygon,
    * and put a -1 on to tell VRML that.
    */
   fprintf ( vrml_fp, "%d, -1\n", current_polygon[1] );
     
   
}






/*
 * print_mesh_indices
 *
 * Write out the connectivity of the mesh.
 *
 *    node 0 -----------> node 1
 *      ^                   |
 *      |                   |
 *      |                   |
 *      |                   V
 *    node 3 <----------- node 2
 *
 * order is 0, 1, 2, 3, 0
 *
 * AVS needs the circuit to close with the first vertex, but VRML
 * does not. 
 *
 */
void print_mesh_indices ( GEOMmesh *mesh, 
			  FILE *vrml_fp )
{
   int i, j;                          /* row and col indices */
   int index;
   int nrows = mesh->m,
       ncols = mesh->n;


   for ( i = 0; i < nrows-2; ++i ) 
     for ( j = 0; j < ncols-1; ++j ) {
       index = i*ncols+j;
       fprintf ( vrml_fp, "\t\t\t%d, %d, %d, %d, -1,\n", 
		 index, index+1, index+ncols+1, index+ncols );
     }
     
   i = nrows-2;
   for ( j = 0; j < ncols-1; ++j ) {
     index = i*ncols+j;
     fprintf ( vrml_fp, "\t\t\t%d, %d, %d, %d, -1,\n", 
	       index, index+1, index+ncols+1, index+ncols );
   }
   
}



/*
 * print_disjointline_indices
 */
void print_disjoint_line_indices ( GEOMvert_list *line, 
				  FILE *vrml_fp )
{

   int i;                 /* which vertex are we on? */


   fprintf ( vrml_fp, "\t\t\tcoordIndex [\n" );
   for ( i = 0; i < (line->n)/2 - 1; ++i ) 
	 fprintf(vrml_fp, "\t\t\t%d, %d, -1, \n", 2*i, 2*i+1 );
       
   fprintf ( vrml_fp, "\t\t\t%d, %d, -1\n", line->n-2, line->n-1 );
   fprintf ( vrml_fp, "\t\t\t\t]\n" );
   

}





/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */







