/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/****************************************************************
 *                                                              *
 * AVS 5 Data Output Module - computevol.c                      *
 *          Andy R. Haas                                        *
 *          R.O.W. Sciences                                     *
 *          National Center for Toxicological Research          *
 *          November 1994                                       *
 *                                                              *
 ****************************************************************/

#include <stdio.h>
#include <avs/avs.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <avs/port.h>
#include <avs/geom.h>

#define MODULE_NAME "compute volume"


#define DOT(a,b) (a[0]*b[0] + a[1]*b[1] + a[2]*b[2])
#define MAG(a) (sqrt(a[0]*a[0] + a[1]*a[1] + a[2]*a[2]))


double crossProd (double *a, double *b, double *r)     
{
  r[0] = a[1] * b[2] - a[2] * b[1];
  r[1] = a[2] * b[0] - a[0] * b[2];
  r[2] = a[0] * b[1] - a[1] * b[0];
  
  return MAG(r);
}


float getvol (GEOMobj *obj, float conv, float *surfarea)
{
  double vol = 0;
  double area = 0;
  int i,j,k,q;
  double pa[3],b[3],c[3],r[3],mag;

  for (k=0; k < PT(obj).npts; k++) {

    q = 0;
    for (j=6; j < 3*PT(obj).ptverts[k].n; j+=3) {
      q = 1-q;
      for (i=0; i < 3; i++) {
        pa[i] = PT(obj).ptverts[k].l[j-6+i];
        b[i] = PT(obj).ptverts[k].l[j-3+i]  - pa[i];
        c[i] = PT(obj).ptverts[k].l[j+i] - pa[i];
      }

      mag = q? crossProd (c, b, r) : crossProd (b, c, r);
      vol += DOT(pa,r) / 6;
      area += mag / 2;
    }
  }

  vol *= pow(conv, 3.0);
  
  if (surfarea)
    *surfarea = area * pow(conv, 2.0);
  return vol;
}


int compute (GEOMedit_list geom, float **vol, float **area,
             float *conv)
{
  GEOMobj *obj;

  if (!(geom->l)->type) {

    obj = (GEOMobj *) ((geom->l)->data);
    switch (obj->type)
      {
      case GEOM_MESH:
        GEOMcvt_mesh_to_polytri (obj, GEOM_SURFACE);
        break; 
      case GEOM_POLYHEDRON:
        GEOMcvt_polyh_to_polytri (obj, GEOM_SURFACE);
        break; 
      case GEOM_SPHERE:
        obj = GEOMcvt_sphere_to_polytri (obj, 8, GEOM_SURFACE);
        break;
      case GEOM_LABEL:
        return 0;
      case GEOM_POLYTRI:
        break;
      default:
        AVSmessage ("1.0", AVS_Error, NULL, MODULE_NAME, NULL,
                    "Unknown geometry object was received\n");
        return 0;
      }

    *vol = (float *) malloc (sizeof(float));
    *area = (float *) malloc (sizeof(float));
    
    **vol = getvol (obj, *conv, *area);
    printf ("\nobject \"%s\"\n\tvolume = %f\n\tarea = %f\n",
            (geom->l)->name, **vol, **area);
    return 1;
  }
  return 0;
}


int description()
{
  int parm;
  
  AVSset_module_name (MODULE_NAME, MODULE_RENDER);

  AVScreate_input_port ("Surface Geometry", "geom", REQUIRED);
  AVScreate_output_port ("Volume", "real");
  AVScreate_output_port ("Area", "real");

  parm = AVSadd_float_parameter ("Conversion Factor",
                                 1.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
  AVSconnect_widget (parm, "typein_real");

  
  AVSset_compute_proc (compute);
  return 1;
}


AVSinit_modules()
{
    AVSmodule_from_desc (description);
}
