/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* Module Name: "continuous stats" (Output) (Subroutine)                 */
/* Author: Terry Myerson                                                 */
/* Date Created: Tue Jan 21 02:06:52 1992                                */
/*                                                                       */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
 
/* *****************************************/
/*  Module Specification                   */
/* *****************************************/
int continuous_stats_spec()
{

	int in_port, out_port, param;
	extern int continuous_stats_compute();

	AVSset_module_name("continuous stats", MODULE_RENDER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("Min", "real", REQUIRED);
	in_port = AVScreate_input_port("Max", "real", REQUIRED);

	/* Parameter Specifications                */
	param = AVSadd_parameter("reset", "boolean",1,0,1);
	param = AVSadd_parameter("min data", "string", "0", " ", " ");
	AVSconnect_widget(param, "text");
	param = AVSadd_parameter("max data", "string", "0", " ", " ");
	AVSconnect_widget(param, "text");

       	out_port = AVScreate_output_port("Min","real" );
	out_port = AVScreate_output_port("Max","real" );
	AVSset_compute_proc(continuous_stats_compute);

	return(1);
}
 
int continuous_stats_compute ( min_in,max_in, min_out,max_out,
		 	       start, MIN_DATA, MAX_DATA )
	float *min_in,*max_in,**min_out,**max_out;
        int start;
	char *MIN_DATA;
	char *MAX_DATA; 
{ 
   static float running_min,running_max;
   char tmp[20];

   if (start==1)
   {
      running_min = 1000000;
      running_max = -1000000;
      AVSmodify_parameter("reset",AVS_VALUE,0,0,0 );
      AVSmodify_parameter("min data",AVS_VALUE,"0",0,0 );
      AVSmodify_parameter("max data",AVS_VALUE,"0",0,0 );
   }
   else
   {
      if ( *min_in<running_min ) running_min=*min_in;
      if ( *max_in>running_max ) running_max=*max_in;
   
      sprintf ( tmp,"%f",running_min );
      AVSmodify_parameter("min data",AVS_VALUE,tmp,0,0 );
      sprintf ( tmp,"%f",running_max );
      AVSmodify_parameter("max data",AVS_VALUE,tmp,0,0 );
   }

   if (*min_out) FREE_LOCAL ( *min_out );
   *min_out = (float *)ALLOC_LOCAL( sizeof(float) );
   if (*max_out) FREE_LOCAL ( *max_out );
   *max_out = (float *)ALLOC_LOCAL( sizeof(float) );
   **min_out = running_min;
   **max_out = running_max;
   return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*filter_mod_list[])()) = {
	continuous_stats_spec,
};
#define NMODS (sizeof(filter_mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(filter_mod_list, NMODS);
}
