/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/**************************************************/
/*                  D2A_FLD.C                     */
/**************************************************/

#include <stdio.h>
#include <string.h>

#include "d2aconst.h"




/*
 * Create output Field file containing
 * coordinates of objects
 * parameter:
 *	(i) in_file1: input filename
 *	(i) out_f_crd1: output filename
 *	(o) fp_crd1: output file pointer
 *	
 */
int
createFOutFldCrd(in_file1, out_f_crd1, fp_crd1)
char in_file1[MAX_CHAR_NAME_FILE];
char out_f_crd1[MAX_CHAR_NAME_FILE];
FILE **fp_crd1;
{
	char *pos;

	/*
	 * create new filename
	 */
	strcpy(out_f_crd1, in_file1);
	pos = strstr(out_f_crd1, ".");

	/* 
	 * truncate old filename extention
	 */
	if (pos != NULL)
		strtok(out_f_crd1, ".");

	/*
	 * append Field coordinate extention, ".crd"
	 */
	strcat(out_f_crd1, ".crd");

	/*
	 * create output file
	 */
	*fp_crd1 = fopen(out_f_crd1, "w");

	return(TRUE);
} /* createFOutFldCrd */






/*
 * Write pseudo value into Field data file,
 * value represent sphere radius, useful
 * with scattered dots.
 * parameters:
 *	(i) in_file1: input filename
 *	(o) out_file_fdt: output filename
 *	(i) n_obj: number of objects 
 */
int
wrtFldData(in_file1, out_file_fdt, n_obj)
char *in_file1;
char *out_file_fdt;
int n_obj;
{
	int i;
	char string2[LINEA], *pos;
	FILE *fp1;

	
	/*
	 * create new filename
	 */
	strcpy(out_file_fdt, in_file1);
	pos = strstr(out_file_fdt, ".");

	
	/*
	 * truncate old filename extention
	 */
	if (pos != NULL)
		strtok(out_file_fdt, ".");

	
	/*
	 * append Field data extention ".fdt"
	 */
	strcat(out_file_fdt, ".fdt");

	
	/*
	 * create output file
	 */
	fp1 = fopen(out_file_fdt, "w");

	/*
	 * write comments into file
	 */
	sprintf(string2,"#   file of data related to AVS Field to create Scatter Dots  ( <name>.fdt  )\n");
	fputs(string2,fp1);

	/*
	 * for all objects write pseudo value which
	 * represent sphere radius into output file
	 */
	for(i=0;i<n_obj;i++) {
		sprintf(string2, "%s%f%s", "  ", DATA_FIELD_FITTIZIO, "  \n");
		fputs(string2, fp1);
	}

	/*
	 * close output file
	 */
	fclose(fp1);
	
	
	return(TRUE);
} /* wrtFldData */
