/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*********************************************************/
/*                       D2A_PARS.C                      */
/*********************************************************/

/*
 **********************************************************
 *
 * First Grammar recognize strings representing integer
 * and floating-point numbers
 *
 *
 * isData		= isUnsigned / isSigned
 *
 * isSigned		= isSign isUnsigned
 *
 * isUnsigned		= isNumberTermin /
 *			  isNumber isPMExp /
 *			  isNumber isPDecimal /
 *			  isNumber isUnsigned
 * 		  
 * isPMExp		= isPoint isNumber isManExp /
 *			  isManExp
 *
 * isManExp		= isExp / isNumber isManExp
 *
 * isExp		= 'e' isNumber isNumberTermin /
 *			  'e' isSign isNumber isNumberTermin /
 *			  'e' isNumberTermin /
 *			  'e' isSign isNumberTermin /
 *			  'E' isSign isNumberTermin /
 *			  'E' isSign isNumber isNumberTermin /
 *			  'E' isNumberTermin /
 *			  'E' isSign inNumberTermin
 *
 * isPDecimal		= isPoint isDecimal
 *
 * isDecimal		= isNumberTermin /
 *			  isNumber isDecimal
 *
 * isNumberTermin 	= '0'EOF / '0''\0' /
 *			  '1'EOF / '1''\0' /
 *			  '2'EOF / '2''\0' /
 *			  '3'EOF / '3''\0' /
 *			  '4'EOF / '4''\0' /
 *		    	  '5'EOF / '5''\0' /
 *			  '6'EOF / '6''\0' /
 *			  '7'EOF / '7''\0' /
 *			  '8'EOF / '8''\0' /
 *			  '9'EOF / '9''\0'
 * 
 * isNumber		= '0' / '1' / 
 * 			  '2' / '3' / 
 * 			  '4' / '5' /
 *			  '6' / '7' /
 * 			  '8' / '9'			
 *
 * isSign		= '+' / '-'
 *
 * isPoint		= '.'
 *
 **********************************************************
 */


#include "stdio.h"
#include "d2aconst.h"







/*
 * return TRUE if s point to the "." character
 * parameter:
 *  (i) s: string pointer
 */
bool
isPoint(s)
char *s;
{
	return(*s == '.');
} /* isPoint */





/*
 * return TRUE if s point to "-" or "+" character
 * parameter:
 *  (i) s: string pointer
 */
bool
isSign(s)
char *s;
{
	return((*s == '+') OR (*s == '-'));
} /* isSign */







/*
 * return TRUE if s point is to a numerical character
 * parameter:
 *  (i) s: string pointer
 */
bool
isNumber(s)
char *s;
{
	return((*s >= '0') AND (*s <= '9'));
} /* isNumber */







/*
 * return TRUE if s point to numerical character followed,
 * by end of string character or end of file character
 * parameter:
 *  (i) s: string pointer
 */
bool
isNumberTermin(s)
char *s;
{
	return(
		(*s >= '0') AND (*s <= '9')
			AND
		((*(s+1) == '\0') OR (*(s+1) == EOF))
	);
} /* isNumberTermin */







/*
 * return TRUE if s point to terminal numerical character or 
 * characters are numerical
 * parameter:
 *  (i) s: string pointer
 */
bool
isDecimal(s)
char *s;
{
	return(
		isNumberTermin(s)
			OR
		(isNumber(s) AND isDecimal(s+1))
	);
} /* isDecimal */







/*
 * retrun TRUE if s point to "." character and 
 * next characters are numerical
 * parameter:
 *  (i) s: string pointer
 */
bool
isPDecimal(s)
char *s;
{
	return(isPoint(s) AND isDecimal(s+1));
} /* isPDecimal */







/*
 * return TRUE if s point to "e" or "E" or 
 * "e+" or "e-" or "E+" or "E-"
 * string and the following one or max 2 characters 
 * are numerical
 * parameter:
 *  (i) s: string pointer
 */
bool
isExp(s)
char *s;
{
	return(
		((*s == 'e')  OR  (*s == 'E'))
			AND
			(
				(isNumber(s+1) AND isNumberTermin(s+2))
			
					OR
		
				(isSign(s+1) AND isNumber(s+2) 
					AND isNumberTermin(s+3))
			
					OR
		
				(isNumberTermin(s+1))
		
					OR
			
				(isSign(s+1) AND isNumberTermin(s+2))
			)
	);
} /* isExp */







/*
 * return TRUE if s point to an exponent statement or
 * to a numerical string before exponent statement
 * parameter:
 *  (i) s: string pointer
 */
bool
isManExp(s)
char *s;
{
	return(
		isExp(s)
			OR
		(isNumber(s) AND isManExp(s+1))
	);
} /* isManExp */







/*
 * return TRUE if s point to "." character and next 
 * characters are numerical string with exponent 
 * statement, or if s point to numerical string before
 * exponent statement.
 * parameter:
 *  (i) s: string pointer
 */
bool
isPMExp(s)
char *s;
{
	return(
		(isPoint(s) AND isNumber(s+1)
			AND isManExp(s+2))
			
			OR
			
		(isManExp(s))
	);
} /* isPMExp */







/*
 * return TRUE if s point to unsigned numerical string,
 * integer or floating-point
 * parameter:
 *  (i) s: string pointer
 */
bool
isUnsigned(s)
char *s;
{
	return(
		isNumberTermin(s)
			
			OR
		
		(isNumber(s) AND isPMExp(s+1))
			
			OR
		
		(isNumber(s) AND isPDecimal(s+1))
			
			OR
		
		(isNumber(s) AND isUnsigned(s+1))
	);
} /* isUnsigned */








/*
 * return TRUE if s point to signed numerical string,
 * integer or floating-point
 * parameter:
 *  (i) s: string pointer
 */
bool
isSigned(s)
char *s;
{
	return(isSign(s) AND isUnsigned(s+1));
} /* isSigned */








/*
 * return TRUE if s point to signed or unsigned 
 * numerical string, integer or floating-point
 * parameter:
 *  (i) s: string pointer
 */
bool
isData(s)
char *s;
{
	return(isUnsigned(s) OR isSigned(s));
} /* isData */







/*
 **********************************************************
 *
 * Second Grammar recognize strings representing sign,
 * because some catalogues of DIRA2 may have columns with
 * alone sign: '+' or '-'
 *
 *
 * isAloneSign 	= '-''\0' / '+''\0'
 *
 *
 **********************************************************
 */




/*
 * return TRUE if s point to '-' or '+' character alone
 * parameter:
 *  (i) s: string pointer
 */
bool
isAloneSign(s)
char *s;
{
	return(
		((*s == '-') OR (*s == '+'))
			AND
		(*(s+1) == '\0')
	);
} /* isAloneSign */










/* 
 *********************************************************
 *       
 * Third Grammar recognize signed or unsigned character
 * before significant numerical string
 * 
 * isZero		= isZeroSigned / isZeroUnsigned
 *
 * isZeroSigned		= '-' isZeroUnsigned / 
 *			  '+' isZeroUnsigned
 *
 * isZeroUnsigned	= '0' isNotZeroNumber /
 *			  '0' isZeroUnsigned
 *
 * isNotZeroNumber	= '1' / '2' /
 *			  '3' / '4' /
 * 			  '5' / '6' /
 * 			  '7' / '8' /
 * 			  '9'
 *
 *
 
 *********************************************************
 */






/*
 * return TRUE if s point to a not zero numerical character
 * parameter:
 *  (i) s: string pointer
 */
bool
isNotZeroNumber(s)
char *s;
{
	return((*s >= '1') AND (*s <= '9'));
} /* isNotZeroNumber */







/*
 * return TRUE if s point to zero character, 
 * before of not zero numerical string
 * parameter:
 *  (i) s: string pointer
 */
bool
isZeroUnsigned(s)
char *s;
{
	return(
		(*s == '0')
			AND
		(isNotZeroNumber(s+1) OR isZeroUnsigned(s+1))
	);
} /* isZeroUnsigned */







/*
 * return TRUE if s point to signed zero character
 * parameter:
 *  (i) s: string pointer
 */
bool
isZeroSigned(s)
char *s;
{
	return(
		((*s == '-') OR (*s == '+'))
			AND
		isZeroUnsigned(s+1)
	);
} /* isZeroSigned */







/*
 * return TRUE if s point to zero numerical string
 * parameter:
 *  (i) s: string pointer
 */
bool
isZero(s)
char *s;
{
	return(
		isZeroSigned(s)
			OR
		isZeroUnsigned(s)
	);
} /* isZero */

