/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/***********************************************/
/*                 D2A_UCD.C                   */
/***********************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>

#include "d2aconst.h"
#include "d2a_msg.h"
#include "d2a_util.h"



/* 
 * array containing UCD cell type label
 */
static char *tipo_ucd_cella[] =
{
	"pt",
	"line",
	"tri",
	"quad",
	"tet",
	"pyr",
	"prism",
	"hex"
};





/*
 * Write general comments and header information into 
 * output UCD file (".inp") in order to explain
 * data format for AVS UCD data type.
 * parameters:
 *	(i) fp_out3: output file pointer
 *	(i) n_obj3: number of objects obtanined
 *			from input file
 *	(i) n_par3: parameter number in line
 *	(i) num_coord3: coordinate number
 *	(i) num_vert3: vertex number of UCD cell type
 *	(i) dup_crd_as_data: boolean flag in order to
 *		duplicate coordinates into data area
 * 
 */
int
headUcd(fp_out3, n_obj3, n_par3, num_coord3, 
	num_vert3, dup_crd_as_data)
FILE *fp_out3;
int n_obj3;
int n_par3;
int num_coord3;
int num_vert3;
bool dup_crd_as_data;
{
	int num_data3;
	char string[LINEA];

	/*
	 * detect number of data information section 
	 */
	if (dup_crd_as_data) 
		num_data3 = n_par3;
	else 
		num_data3 = n_par3 - num_coord3;

	/*
	 * write general comments into output file
	 */
	sprintf(string, "%s", "#  \n");
	fputs(string, fp_out3);
	sprintf(string, "%s", "#  # <comment 1> \n");
	fputs(string, fp_out3);
	sprintf(string, "%s", "#  .  . \n");
	fputs(string, fp_out3);
	sprintf(string, "%s", "#  # <comment n> \n");
 	fputs(string, fp_out3);
	sprintf(string, "%s", "#  <num_nodes> <num_cells> <num_ndata> <num_cdata> <num_mdata> \n");
	fputs(string, fp_out3);
    	sprintf(string, "%s", "#  1 (node_id 1)  <x>  <y>  <z> \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#    .  .        .    .    . \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#  n (node_id num_nodes)  <x>  <y>  <z> \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#  1 (cell_id 1) <mat_id> <type> <vert 1> . . <vert n>\n");
    	fputs(string, fp_out3);
	sprintf(string, "%s", "#   .   .           .  \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#  n (cell_id num_cells) <mat_id> <type> <vert 1> . . <vert n>\n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#  <node_data_name 1>  \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#     .  . \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#  <node_data_name n> \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#  <num_comp> <size comp 1> . . <size comp n> \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#  <comp_name 1> <unit_name 1> \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#        .                 . \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#  <comp_name num_comp> <unit_name num_comp> \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#   1 (node_id 1)  <node_data 1> . . <node_data n> \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#     .             . \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#   n (node_id n)  <node_data 1> .  . <node_data n> \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "# \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "#  ------------------------------------------------------------------------------ \n");
    	fputs(string, fp_out3);
    	sprintf(string, "%s", "# \n");
    	fputs(string, fp_out3);
    	/*
    	 * write header information
    	 */
    	sprintf(string, "%d%s%d%s%d%s%d%s%d%s", n_obj3*num_vert3, " ", 
    		n_obj3, " ", num_data3, " ", NUM_CDATA, " ", NUM_MDATA, " \n");
    	fputs(string, fp_out3);

	return(TRUE);
} /* headUcd */








/*
 * write vertex coordinate values of 
 * UCD selected cell. Vertex coordinates are
 * shifted around real coordinates position 
 * of the object, in order to get barycentric 
 * position in the geometrical representation 
 * used by UCD cell.
 * parameters:
 *	(i/o) fp_out: output file pointer
 *	(i) item: coodinates and data
 *	(i) line: number of line (object number)
 *	(i) type_cell: type of UCD cell
 *	(i) num_vertex: number of vertex of UCD cell
 *   
 */
int
wrtVertexCell2(fp_out, item, line, type_cell, num_vertex)
FILE *fp_out;
char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
int line;
avs_tipo_cella type_cell;
int num_vertex;
{
	int i, j, line_tmp;
	char tmp_str[MAX_NUM_CHAR];
	char strin1[LINEA];
	float mom_coord;
	double ra, dec, mom_z;
	double x, y, z;
	double shft;
	double mom_x, mom_y;

	
	/*
	 * reset value
	 */
	ra    = 0; 
	dec   = 0;
	mom_z = 0;

	/*
	 * select computation by
	 * UCD selected cell
	 */
	switch (type_cell) {

		case PUNTO: {

			/*
			 * for every vertex of 
			 * UCD point cell
			 */
			for(i=0; i<num_vertex; i++) {

                		/*
                		 * prepare information to write
                		 * into output file
                		 */
                		line_tmp = (line-1) * num_vertex + (i+1);
                		sprintf(tmp_str, "%s%d%s", "  ", line_tmp, "  ");
                		strcpy(strin1, tmp_str);
	
				ra = atof(item[COORD_X]);
				dec = atof(item[COORD_Y]);
				mom_z = atof(item[COORD_Z]);
                		
                		/*
                		 * convert double to string
                		 */
                		sprintf(tmp_str, "%.9f%s", ra, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", dec, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", mom_z, "  ");
				strcat(strin1, tmp_str);
                		strcat(strin1, " \n");
                		
                		/*
                		 * write into output file
                		 */
                		fputs(strin1, fp_out);
			}
		}
		break;

		case LINEA_CELL:

            		/*
			 * for every vertex of 
			 * UCD line cell
			 */
            		for(i=0; i<num_vertex; i++) {

                		/*
                		 * prepare information to write
                		 * into output file
                		 */
                		line_tmp = (line-1) * num_vertex + (i+1);
                		sprintf(tmp_str, "%s%d%s", "  ", line_tmp, "  ");
                		strcpy(strin1, tmp_str);

				ra = atof(item[COORD_X]);
				dec = atof(item[COORD_Y]);
				mom_z = atof(item[COORD_Z]);

				/*
				 * for every vertex calculate
				 * the shift delta value of
				 * relative coordinates and 
				 * set them
				 */ 
				switch(i) {
					case VERT_0: {
							shiftDeltaCrdVertex(ra, &shft);
							ra = ra - shft;
						}
						break;

					case VERT_1: {
							shiftDeltaCrdVertex(ra, &shft);
							ra = ra - shft;
						}
						break;
				} /* switch(i) */


                		/*
                		 * convert double to string
                		 */
                		sprintf(tmp_str, "%.9f%s", ra, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", dec, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str,"%.9f%s", mom_z, "  ");
				strcat(strin1, tmp_str);
                		strcat(strin1, " \n");
                		
                		/*
                		 * write into output file
                		 */
                		fputs(strin1, fp_out);
			}
			break;

		case TRIANGOLO:

            		/*
			 * for every vertex of 
			 * UCD triangle cell
			 */
            		for(i=0; i<num_vertex; i++) {

				/*
                		 * prepare information to write
                		 * into output file
                		 */
				line_tmp = (line-1) * num_vertex + (i+1);
				sprintf(tmp_str, "%s%d%s", "  ", line_tmp, "  ");
				strcpy(strin1, tmp_str);


				ra = atof(item[COORD_X]);
				dec = atof(item[COORD_Y]);
				mom_z = atof(item[COORD_Z]);
				
				/*
				 * for every vertex calculate
				 * the shift delta value of
				 * relative coordinates and
				 * set them
				 */
				switch(i) {
					case VERT_0:

						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						break;
					case VERT_1:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						break;
					case VERT_2:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						break;
				} /* switch(i) */
				
                		/*
                		 * convert double to string
                		 */
                		sprintf(tmp_str, "%.9f%s", ra, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", dec, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", mom_z, "  ");
				strcat(strin1, tmp_str);
                		strcat(strin1, " \n");
                		
                		
                		/*
                		 * write into output file
                		 */
                		fputs(strin1, fp_out);
			}
			break;

		case QUADRILATERO:

            		/*
			 * for every vertex of 
			 * UCD quadrilateral cell
			 */
            		for(i=0; i<num_vertex; i++) {

                		/*
                		 * prepare information to write
                		 * into output file
                		 */
                		line_tmp = (line-1) * num_vertex + (i+1);
                		sprintf(tmp_str, "%s%d%s", "  ", line_tmp, "  ");
                		strcpy(strin1, tmp_str);
				
				ra = atof(item[COORD_X]);
				dec = atof(item[COORD_Y]);
				mom_z = atof(item[COORD_Z]);

				/*
				 * for every vertex calculate
				 * the shift delta value of
				 * relative coordinates and
				 * set them
				 */
				switch(i) {
					case VERT_0:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						break;
					case VERT_1:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						break;
					case VERT_2:
						shiftDeltaCrdVertex(ra, &shft);
						ra= ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						break;
					case VERT_3:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						break;
				} /* switch(i) */

                		/*
                		 * convert double to string
                		 */
                		sprintf(tmp_str, "%.9f%s", ra, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", dec, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", mom_z, "  ");
				strcat(strin1, tmp_str);
                		strcat(strin1, " \n");
                		
                		
                		/*
                		 * write into output file
                		 */
                		fputs(strin1, fp_out);
			}
			break;

		case TETRAEDRO:

            		/*
			 * for every vertex of 
			 * UCD tetrahedron cell
			 */
            		for(i=0; i<num_vertex; i++) {

                		/*
                		 * prepare information to write
                		 * into output file
                		 */
                		line_tmp = (line-1) * num_vertex + (i+1);
                		sprintf(tmp_str, "%s%d%s", "  ", line_tmp, "  ");
                		strcpy(strin1, tmp_str);
				
				ra = atof(item[COORD_X]);
				dec = atof(item[COORD_Y]);
				mom_z = atof(item[COORD_Z]);


				/*
				 * for every vertex calculate
				 * the shift delta value of
				 * relative coordinates and
				 * set them
				 */
				switch(i) {
					case VERT_0:
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z + shft;
						break;
					case VERT_1:
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
					case VERT_2:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
					case VERT_3:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
				} /* switch(i) */
				
                		/*
                		 * convert double to string
                		 */
                		sprintf(tmp_str, "%.9f%s", ra, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", dec, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", mom_z, "  ");
				strcat(strin1, tmp_str);
                		strcat(strin1, " \n");
                		
                		
                		/*
                		 * write into output file
                		 */
                		fputs(strin1, fp_out);
			}
			break;

		case PIRAMIDE:

            		/*
			 * for every vertex of 
			 * UCD pyramid cell
			 */
            		for(i=0; i<num_vertex; i++) {

                		/*
                		 * prepare information to write
                		 * into output file
                		 */
                		line_tmp = (line-1) * num_vertex + (i+1);
                		sprintf(tmp_str, "%s%d%s", "  ", line_tmp, "  ");
                		strcpy(strin1, tmp_str);
				
				ra = atof(item[COORD_X]);
				dec = atof(item[COORD_Y]);
				mom_z = atof(item[COORD_Z]);


				/*
				 * for every vertex calculate
				 * the shift delta value of
				 * relative coordinates and
				 * set them
				 */
				switch(i) {
					case VERT_0:
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z + shft;
						break;
					case VERT_1:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
					case VERT_2:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
					case VERT_3:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
					case VERT_4:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
				} /* switch(i) */
				
                		/*
                		 * convert double to string
                		 */
                		sprintf(tmp_str, "%.9f%s", ra, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", dec, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", mom_z, "  ");
				strcat(strin1, tmp_str);
                		strcat(strin1, " \n");
                		
                		
                		/*
                		 * write into output file
                		 */
                		fputs(strin1, fp_out);
			}
			break;

		case PRISMA:

            		/*
			 * for every vertex of 
			 * UCD prism cell
			 */
            		for(i=0; i<num_vertex; i++) {

                		/*
                		 * prepare information to write
                		 * into output file
                		 */
                		line_tmp = (line-1) * num_vertex + (i+1);
                		sprintf(tmp_str, "%s%d%s", "  ", line_tmp, "  ");
                		strcpy(strin1, tmp_str);
				
				ra = atof(item[COORD_X]);
				dec = atof(item[COORD_Y]);
				mom_z = atof(item[COORD_Z]);


				/*
				 * for every vertex calculate
				 * the shift delta value of
				 * relative coordinates and
				 * set them
				 */
				switch(i) {
					case VERT_0:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
					case VERT_1:
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z + shft;
						break;
					case VERT_2:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z-shft;
						break;
					case VERT_3:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
					case VERT_4:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						break;
					case VERT_5:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
				} /* switch(i) */
				
                		/*
                		 * convert double to string
                		 */
                		sprintf(tmp_str, "%.9f%s", ra, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", dec, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", mom_z, "  ");
				strcat(strin1, tmp_str);
                		strcat(strin1, " \n");
                		
                		
                		/*
                		 * write into output file
                		 */
                		fputs(strin1, fp_out);
			}
			break;

		case EXAEDRO:

            		/*
			 * for every vertex of 
			 * UCD hexahedron cell
			 */
            		for(i=0; i<num_vertex; i++) {

                		/*
                		 * prepare information to write
                		 * into output file
                		 */
                		line_tmp = (line-1) * num_vertex + (i+1);
                		sprintf(tmp_str, "%s%d%s", "  ", line_tmp, "  ");
                		strcpy(strin1, tmp_str);
				
				ra = atof(item[COORD_X]);
				dec = atof(item[COORD_Y]);
				mom_z = atof(item[COORD_Z]);


				/*
				 * for every vertex calculate
				 * the shift delta value of
				 * relative coordinates and
				 * set them
				 */
				switch(i) {
					case VERT_0:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z + shft;
						break;
					case VERT_1:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z + shft;
						break;
					case VERT_2:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z + shft;
						break;
					case VERT_3:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z + shft;
						break;
					case VERT_4:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z- shft;
						break;
					case VERT_5:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra - shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
					case VERT_6:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec - shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
					case VERT_7:
						shiftDeltaCrdVertex(ra, &shft);
						ra = ra + shft;
						shiftDeltaCrdVertex(dec, &shft);
						dec = dec + shft;
						shiftDeltaCrdVertex(mom_z, &shft);
						mom_z = mom_z - shft;
						break;
				} /* switch(i) */
				
                		/*
                		 * convert double to string
                		 */
                		sprintf(tmp_str, "%.9f%s", ra, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", dec, "  ");
				strcat(strin1, tmp_str);
                		sprintf(tmp_str, "%.9f%s", mom_z, "  ");
				strcat(strin1, tmp_str);
                		strcat(strin1, " \n");
                		
                		
                		/*
                		 * write into output file
                		 */
                		fputs(strin1, fp_out);
			}
			break;
	} /* switch (type_cell) */
	return(TRUE);
} /* wrtVertexCell2 */








/*
 * Write data into data area of UCD file (".inp"),
 * write also structure information in order to
 * retrieve data in the correct way.
 * Data area may be optional in UCD file.
 * parameters:
 *	(i) in_file2: input file name
 *	(i) name_f_out2: output file name
 *	(i) fp_out2: output file pointer
 *	(i) n_par2: parameter number
 *	(i) n_coord2: coordinate number
 *	(i) n_obj2: number of objects 
 *	(i) type_cell2: UCD type of cell
 *	(i) flag_name_crd: boolean flag coordinate label
 *	(i) name: data label
 *	(i) dup_crd_as_data: boolean flag to duplicate
 *		coordinates into data area
 *	(i) ra_dec_to_xyz: boolean flag to convert
 *		spherical (equatorial) coordinates into
 *		cartesian coordinates
 *
 */
int
wrtUcdData(in_file2, name_f_out2, fp_out2, n_par2, 
	n_coord2, n_obj2, type_cell2, flag_name_crd, 
	name, dup_crd_as_data, ra_dec_to_xyz)
char *in_file2;
char *name_f_out2;
FILE *fp_out2;
int n_par2;
int n_coord2;
int n_obj2;
avs_tipo_cella type_cell2;
bool flag_name_crd;
char name[MAX_ITEM_LINE][MAX_NUM_CHAR]; 
bool dup_crd_as_data;
bool ra_dec_to_xyz;
{
     	int i, j, n, count, num_vertex;
	int n_component, pos_name;
  	char *row2;
  	char mom_buffer[FILE_BUFFER_SIZE];
  	char strin2[LINEA];
    	char item2[MAX_ITEM_LINE][MAX_NUM_CHAR];
    	char tmp_str[LINEA];
  	double ro, teta;
	FILE *fp2;
	
  	
  	
  	/*
  	 * reset variables
  	 */
  	i = 0;
  	j = 0;
  	num_vertex = 0;
  	n_component = 0; 
  	pos_name = 0; 
  	count = 0;
	
	
	/*
	 * reset item
	 */
	initItem(item2);

    

  	/*
  	 * obtain vertex number of UCD selected cell
  	 */
  	num_vertex = numVertCell(type_cell2);

	
	/*
	 * Test correct number of coordinates
	 */
	if (n_par2 >= n_coord2) {
         
		/*
		 * for all objects
		 */
		for (j=0; j<n_obj2; j++) {

			/*
			 * write cell and material identifier and
			 * UCD cell label
			 */
			sprintf(strin2, "%d%s%d%s%s%s", j+1, "  ", 
				MATERIAL_ID, "  ", 
				tipo_ucd_cella[type_cell2-1], "  ");


            		/*
            		 * write all vertex identifier of UCD cell 
            		 */
            		for (i=0; i<num_vertex; i++) {
                		sprintf(tmp_str, "%d%s", (j*num_vertex)+(i+1), "  ");
                		strcat(strin2, tmp_str);
			}
            		
            		strcat(strin2, "\n");
            		
            		/*
            		 * write into output file
            		 */
            		fputs(strin2, fp_out2);
		}


        	/*
        	 * Test the duplicate coordinate as data
        	 * boolean flag to calculate component number,
        	 * then prepare component and size-component 
        	 * information string. 
        	 */
        	if (dup_crd_as_data)
        		n_component = n_par2;
        	else 
        		n_component = n_par2 - n_coord2;

        	
        	sprintf(strin2, "%s%d%s", "  ", n_component, "  ");
		/*
		 * for all components set size_component
		 */
		for (i=0; i < n_component; i++) {
            		sprintf(tmp_str, "%d%s", SIZE_COMPONENT, "  ");
            		strcat(strin2, tmp_str);
		}
		
		/*
		 * test component presence
		 */
		if (i >=  n_component) {	
        		
        		strcat(strin2, "\n");
        		/*
        		 * write into output file
        		 */
        		fputs(strin2, fp_out2);
		}


        	
        	strcpy(strin2, "");
        	/*
        	 * test boolean flag to duplicate coordinates
        	 */
        	if (dup_crd_as_data)
        		pos_name = 0;
		else 
			pos_name = n_coord2;
        	
        	/*
        	 * check and then prepare coordinate and
        	 * data label, set dafault unit label "unknown"
        	 */
        	for (i=pos_name; i<n_par2; i++) {
        		if ((i <= n_coord2-1) AND flag_name_crd) {
                		sprintf(strin2, "%s%s%s%s", name[i], ", ", UNIT_UNKNOWN, " \n");
        		} else {
        			if (i > n_coord2-1)
        				sprintf(strin2, "%s%s%s%s", name[i], ", ", 
        					UNIT_UNKNOWN, " \n");
        			else
        				sprintf(strin2, "%s%s%s%s", UNKNOWN, ", ", 
        					UNIT_UNKNOWN, " \n");
       			}
         		/*
         		 * write into output file
         		 */
         		fputs(strin2, fp_out2);
		}
        	
        	/*
        	 * set name position
        	 */
        	if (dup_crd_as_data)
            		pos_name = 0;
		else 
			pos_name = n_coord2;


		/*
		 * read data from input file and write them
		 * into output file
		 */
		fp2 = fopen(in_file2, "r");
        	while(fgets(mom_buffer, FILE_BUFFER_SIZE, fp2) != NULL) {
            		if (mom_buffer[0] != '\n') {
                		for (j=0; j< num_vertex; j++) {
					++count;
                    			sprintf(strin2, "%s%d%s", "  ", count, "  ");
                    			sscanf(mom_buffer, "%s%s%s%s%s%s%s%s%s%s", 
                    				item2[0], item2[1], item2[2], 
                    				item2[3], item2[4], item2[5], 
                    				item2[6], item2[7], item2[8], 
                    				item2[9]);


					/*
					 * test flag, then
					 * convert into Spherical
					 * coordinates
					 */
					if (ra_dec_to_xyz) 
						convXYZToRaDec(item2);

                    			/*
                    			 * prepare data to write
                    			 * into output file
                    			 */
                    			for (i=pos_name; i<n_par2; i++) {
                        			sprintf(tmp_str, "%.9f%s", 
                        				atof(item2[i]), "  ");
                        			strcat(strin2, tmp_str);
					} /* for */

					/*
					 * append end of line
					 * character
					 */
					if (i >= n_par2) {	
                        			
                        			strcat(strin2, "\n");
                        			
                        			/*
                        			 * write into output file
                        			 */
                        			fputs(strin2, fp_out2);
					} /* if */
				} /* for */
			} /* if */
		} /* while */ 

		/* 
		 * close input file
		 */
		fclose(fp2);
	} else error(NUM_COORD_ILLEGALE, name_f_out2);

	return(TRUE);
} /* wrtUcdData */


