/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* IAC CODE CHANGE : INSERT INCLUDE */
#include <values.h>
/*
 *
 * Author: Massimiliano Bavelloni            
 * Date Created: Wed 26 Oct 11:40:30 1994   
 *
 */

/*
 *++++++++++++++++++++++++++++++++++++++++++++++++++++*
 *----------------------------------------------------*
 *                                                    *
 *              Dira2Avs   module                     *
 *                                                    *
 *----------------------------------------------------*
 *++++++++++++++++++++++++++++++++++++++++++++++++++++*
 */


/*                                            
 * Read data from ascii file, data may be integer
 * or floating point numbers separated by spaces.
 * The first is Ra (right ascension) and the second is
 * DEC (declination) coordinate in Spherical (Equatorial) 
 * system, are stored in radiant format.
 * The third number is the distance value in Spherical
 * (Equatorial) coordinate system.
 * The next one or two numbers (optional) are reserved
 * for something Dira2 parameters.
 * Select kind of UCD cell to represent single point
 * inside 3D space: 
 * UCD cell are:
 *	point
 *	line
 *	triangle
 *	quadrilateral
 *	tetrahedron
 *	pyramid
 *	prism
 *	exahedron
 *
 * Set label related to coordinates and other parameters.
 * In order to eliminate frame distortion effect the 
 * coordinates: Ra and Dec of all objects are shifted, 
 * and the group of object are centered and displayed 
 * around Ra = 0 and DEC = 0
 *  
 */






#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include <avs/avs.h>
#include <avs/avs_data.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <avs/udata.h>
#include <avs/field.h>



#include "d2atypes.h"
#include "d2aconst.h"

#include "d2a_util.h"
#include "d2a_msg.h"
#include "d2a_file.h"
#include "d2a_ucd.h"
#include "d2a_fld.h"


#define MAXFLOAT	((float)3.40282346638528860e+38)

#define MODIFIED	1

static char CELL_T[] =
	"point#line#triangle#quadrilateral#tetrahedron#pyramid#prism#exahedron";



/*
 *+++++++++++++++++++++++++++++++++++++++++++++++++++++++*
 *-------------------------------------------------------*
 *             ***   DESCRIPTION AREA   ***              *
 *-------------------------------------------------------*
 *+++++++++++++++++++++++++++++++++++++++++++++++++++++++*
 */


/*
 *+++++++++++++++++++++++++++++++++++++++++++++++++++*
 *                                                   *
 *             ***    d2a_desc    ***                *
 *                                                   *
 *+++++++++++++++++++++++++++++++++++++++++++++++++++*
 */
/*
 * AVS description function, define:
 * module name, module classification, widget and
 * parameters related to useful information for
 * conversion process.
 *
 */
int
d2a_desc()
 {
	extern d2a_compute();
	int param;
	int in_port1;
	char tmp[256];



	/*
	 * name on the box
	 */
	AVSset_module_name("dira2avs", MODULE_RENDER);



	/*
	 * Input port specification
	 */
	/* in_port1 = AVScreate_input_port("input_str", "string", 
		OPTIONAL); */ 



	/*
	 *
	 * parameter specification
	 *
	 */
	
	/*
	 * input filename
	 */
	param = AVSadd_parameter("filename", "string", 
		"", NULL, NULL);
	AVSconnect_widget(param, "browser");

	
	/*
	 * boolean flag for duplicating coordinates
	 * in the data area
	 */
	param = AVSadd_parameter("coord_as_data", "boolean", 
		TRUE, NULL, NULL);
	AVSconnect_widget(param, "toggle");

	
	/*
	 * coordinate label
	 */
	param = AVSadd_parameter("name_coord_1", "string", 
		"ra", NULL, NULL);
	AVSconnect_widget(param, "typein");

	
	param = AVSadd_parameter("name_coord_2", 
		"string", "dec", NULL, NULL);
	AVSconnect_widget(param, "typein");

	
	param = AVSadd_parameter("name_coord_3", "string", 
		"unknown", NULL, NULL);
	AVSconnect_widget(param, "typein");

	
	/*
	 * data label
	 */
	param = AVSadd_parameter("name_data_1", 
		"string", "unknown", NULL, NULL);
	AVSconnect_widget(param, "typein");

	
	param = AVSadd_parameter("name_data_2", 
		"string", "unknown", NULL, NULL);
	AVSconnect_widget(param, "typein");

	
	/*
	 * select UCD cell
	 */
	param = AVSadd_parameter("type_cell", "choice", 
		"triangle", CELL_T, "#");

	
	/*
	 * starting button
	 */
	param = AVSadd_parameter("Go", "oneshot", 
		FALSE, NULL, NULL);
	AVSconnect_widget(param, "oneshot");



	/*
	 * routine pointers
	 */
	AVSset_compute_proc(d2a_compute);

 } /* d2a_desc */






/*
 *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*
 *-------------------------------------------------------------*
 *           ***   AVS COMPUTE ROUTINE AREA    ***             *
 *-------------------------------------------------------------*
 *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++ +++*
 */



/************************************************************/
/* +++++++++++++  Module  compute routine  ++++++++++++++++ */
/************************************************************/
/*
 * Test widgets control validation, check filename
 * then start converting process.
 * paramters:
 *	(i) fl_name: input data filename
 *	(i) crd_as_data: boolean flag in order to 
 *		duplicate coordinates in the data area
 *		of UCD (".inp") file.
 *	(i) crd_1: 1st coordinate label: RA
 *	(i) crd_2: 2nd coordinate label: DEC
 *	(i) crd_3: 3rd coordinate label: VEL
 *	(i) data_1: 1st data value label
 *	(i) data_2: 2nd data value label
 *	(i) cell_t: type of UCD cell
 *	(i) go: start computation
 *
 */
int
d2a_compute(fl_name, crd_as_data, crd_1, crd_2, crd_3, 
	data_1, data_2, cell_t, go)
char *fl_name;
bool crd_as_data;
char *crd_1;
char *crd_2;
char *crd_3;
char *data_1;
char *data_2;
char *cell_t;
bool go;
{
	int diraToAvs();
	int i;
	int j;
	bool sleep;

	


	/*
	 * Test filename validation
	 */
	if (strcmp(fl_name, "") == EQUAL) 
		sleep = TRUE;
	else 
		sleep = FALSE;
	
	
	/*
	 * Test starting flags
	 */
	if (go AND NOT(sleep)) {
		
		/*
		 * Start converting process
		 */
		diraToAvs(fl_name, crd_as_data, crd_1, crd_2,
			crd_3, data_1, data_2, cell_t, go);
	}


	return(TRUE);
} /* d2a_compute */




/******************************************************/
/* Initialization for modules contained in this file  */
/******************************************************/

static int ((*mod_list[])()) = {
	d2a_desc
};

#define NMODS (sizeof(mod_list) / sizeof(char *))



AVSinit_modules()
{

	AVSinit_from_module_list(mod_list, NMODS);
} /* AVSinit_modules */



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*
 *-------------------------------------------------------------*
 *       ***   UTILITY USER DEFINED FUNCTION AREA   ***        *
 *-------------------------------------------------------------*
 *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/



/*
 * Test input file presence, read data from 
 * input file, call procedures in order to write 
 * comments, header information, coordinates and 
 * data into output file; return number of astronomical
 * object.
 * parameters:
 *	(i) input_file: filename of input data file
 *	(i) tipo_f_out: AVS output file: default UCD
 *	(i) n_obj: number of objects to perform
 *	(i) n_coord: coordinates number
 *	(o) name_out_f: output filename
 *	(o) fp_out: output file pointer
 *	(o) name_out_crd_f: output filename, coordinates 
 *		for Field
 *	(o) fp_out_crd_f: output filepointer, coordinates 
 *		for Field
 *	(i) ra_dec_to_xyz: boolean flag to convert 
 *		Equatorial coordinates into Cartesian
 *		coordinates
 *	(i) dup_crd_as_data: boolean flag to convert 
 *		coordinates into data area
 *	(i) name_param: coordinate and data labels
 *	(i) cell_t: type of UCD cell
 *
 */
int
filter(input_file, type_f_out, n_obj, num_coord, name_out_f, 
	fp_out, name_out_crd_f, fp_out_crd, ra_dec_to_xyz, 
	dup_crd_as_data, name_param, cell_t)
char input_file[MAX_CHAR_NAME_FILE];
avs_type_file type_f_out;
int n_obj;
int num_coord;
char name_out_f[MAX_CHAR_NAME_FILE];
char name_out_crd_f[MAX_CHAR_NAME_FILE];
FILE *fp_out;
FILE *fp_out_crd;
bool ra_dec_to_xyz;
bool dup_crd_as_data;
char name_param[MAX_ITEM_LINE][NUM_CHAR_NAME];
avs_tipo_cella cell_t;
{
	int n_par;
	int line;
	int i;
	int temp_n_par;
	int n_line_head;
	int num_vertices;
	char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
	char name_out_f_fdt[MAX_CHAR_NAME_FILE];
	char buffer[FILE_BUFFER_SIZE];
	char *row;
	char highest_coord[MAX_NUM_CHAR];
	char lowest_coord[MAX_NUM_CHAR];
	double tmp_crd;
	double radius;
	bool param_ok[MAX_ITEM_LINE];
	bool flag_name_coord;
	bool flag_name_data;
	FILE *fp;
	par_range_t *range;




	/*
	 * reset variables
	 */
	n_par = 0; 
	temp_n_par = 0; 
	line = 0;
	n_line_head = 0;
	flag_name_coord = FALSE;
	flag_name_data = FALSE;



	/*
	 * allocate memory for parameter range
	 */
	range = (par_range_t *) malloc(sizeof(par_range_t));


	/*
	 * read data from file
	 */
	openFile(&fp, input_file);
	while((fgets(buffer, FILE_BUFFER_SIZE, fp) != NULL)) {

		/*
		 * reset item before store data
		 */
		initItem(item);

		/*
		 * test data presence
		 */
		if (buffer[0] != '\n') {

			line++;

			/*
			 * get parameters from file and 
			 * put them into item[]
			 */
			n_par = sscanf(buffer, "%s%s%s%s%s%s%s%s%s%s",
				       item[0], item[1], item[2], item[3],
				       item[4], item[5], item[6], item[7],
				       item[8], item[9]);

			/*
			 * first line
			 */
			if (line == 1) {


				/*
				 * send message to user about number parameters,
				 * and number objects to process
				 */
				msgStatus(n_obj, n_par, num_coord);

				/*
				 * AVS FILE TYPE
				 */
				switch (type_f_out){

					case FIELD: {
						/*                    */
						/* future development */
						/*                    */
					} break;

					case UCD: {
						/*
						 * number of vertexes of ucd cells
						 */
						flag_name_coord = TRUE;
						num_vertices = numVertCell((avs_tipo_cella) cell_t);
					} break;

				} /* switch */

				/*
				 * write general comment and header information 
				 * into output file
				 */
				infoFileOut(fp_out, name_out_f, type_f_out, &n_line_head);
				headFileOut(fp_out, name_out_f, name_out_crd_f, 
					type_f_out, n_par, n_obj, num_coord, 
					flag_name_coord, num_vertices, 
					dup_crd_as_data);

				fprintf(stderr, "\n Filtering Input File ... \n");
			} /* endif line == 1 */


			/*
			 * write coordinates into output
			 * file
			 */
			switch (type_f_out ) {
				case FIELD: {
					/*
					 * write coordinates into coordinate FIELD file
					 */
					wrtCoordFileOut(fp_out_crd, name_out_crd_f, type_f_out, n_par,
							flag_name_coord, num_coord, name_param, item,
							line, cell_t, num_vertices);
				} break;

				case UCD: {
					/*
					 * write coordinates into UCD file
					 */
					wrtCoordFileOut(fp_out, name_out_f, type_f_out, n_par,
							flag_name_coord, num_coord, name_param, item,
							line, cell_t, num_vertices);
				} break;

			} /* switch */
		} /* endif */
	} /* while */
	fprintf(stderr, "    OK  \n\n");



	/*
	 * Data section
	 */
	switch(type_f_out) {

		case FIELD: {
			/*
			 * write FIELD DATA  into output "<name>.fld" file
			 */
			fprintf(stderr, "\n Writing FIELD DATA into  '.fld'  File ... ");
			wrtFldData(input_file, name_out_f_fdt, n_obj);
			fprintf(stderr, "\n    OK  \n\n\n");
			closeFile(fp);
		} break;

		case UCD: {
			/*
			 * write UCD structure information and data
			 */
			fprintf(stderr, "\n Writing UCD DATA into  '.inp'  File ...\n ");
			wrtUcdData(input_file, name_out_f, fp_out, n_par, 
				num_coord, n_obj, cell_t, flag_name_coord, 
				name_param, dup_crd_as_data, ra_dec_to_xyz);
			fprintf(stderr, "    OK  \n\n\n");
			closeFile(fp);
		} break;

	} /* switch */

	return(line);
} /*filter*/


/*
 * Set important parameters for converting process,
 * create output file, call parsing, preprocess 
 * and filter precedures.
 * parameters:
 *	(i) fl_name: input data filename
 *	(i) crd_as_data: boolean flag in order to 
 *		duplicate coordinates in the data area
 *		of UCD (".inp") file.
 *	(i) crd_1: 1st coordinate label: RA
 *	(i) crd_2: 2nd coordinate label: DEC
 *	(i) crd_3: 3rd coordinate label: VEL
 *	(i) data_1: 1st data value label
 *	(i) data_2: 2nd data value label
 *	(i) cell_t: type of UCD cell
 *	(i) go: start computation
 *
 */
int
diraToAvs(fl_name, crd_as_data, crd_1, crd_2, crd_3, 
	data_1, data_2, cell_t, go)
char *fl_name;
bool crd_as_data;
char *crd_1;
char *crd_2;
char *crd_3;
char *data_1;
char *data_2;
char *cell_t;
bool go;
{
	int line;
	int n_obj;
	int n_coord;
	char input_f[MAX_CHAR_NAME_FILE];
	char out_name_f[MAX_CHAR_NAME_FILE];
	char name_file_crd[MAX_CHAR_NAME_FILE];
	char name_swap_file[MAX_CHAR_NAME_FILE];
	char name_param[MAX_ITEM_LINE][MAX_NUM_CHAR];
	bool exist_file_tmp;
	bool ra_dec_to_xyz;
	bool dup_crd_as_data;
	FILE *fp_out;
	FILE *fp_out_crd;
	FILE *fp_in;
	avs_tipo_cella type_cell;
	avs_type_file type_f;


	/*
	 * reset flags and variables
	 */
	fp_out_crd = NULL;
	fp_out = NULL; 
	fp_in = NULL;
	
	name_file_crd[0] = ' \0';
	name_swap_file[0] = ' \0';
	input_f[0] = ' \0';
	
	exist_file_tmp  = FALSE;
	
	line = 0;
	n_coord = MAX_COORD;


	/*
	 * store input filename from
	 * avs widget
	 */
	strcpy(input_f, fl_name);

	
	/*
	 * set conversion from
	 * Equatorial (Spherical) coordinates into
	 * cartesian coordinates
	 */
	ra_dec_to_xyz = TRUE;


	
	/*
	 * set UCD cell type
	 */
	type_f = UCD;


	/*
	 * set flag from AVS widget, in order 
	 * to duplicate coordinate in the data area;
	 * default is TRUE
	 */
	dup_crd_as_data = crd_as_data;


	/*
	 * set coordinate and data labels
	 * from AVS widget
	 */
	strcpy(name_param[0], crd_1);
	strcpy(name_param[1], crd_2);
	strcpy(name_param[2], crd_3);
	strcpy(name_param[3], data_1);
	strcpy(name_param[4], data_2);


	
	/*
	 * create output file
	 */
	createFileOut(input_f, out_name_f, type_f, &fp_out);
	if (type_f == FIELD) {
		
		/*
		 * AVS FIELD; create output file with
		 * coordinate information
		 */
		createFOutFldCrd(input_f, name_file_crd, 
			&fp_out_crd);
	}

	
	/*
	 * parsing and preprocess input file
	 */
	exist_file_tmp = preCheckFile(input_f, name_swap_file, 
		&n_obj, &n_coord, ra_dec_to_xyz);

	
	
	/*
	 * obtain UCD type of cell
	 */
	type_cell = cellType(cell_t);
	
	
	/*
	 * process objects and write into output file, 
	 * return number of objects
	 */
	line = filter(name_swap_file, type_f, n_obj, 
		n_coord, out_name_f, fp_out, name_file_crd, 
		fp_out_crd, ra_dec_to_xyz, dup_crd_as_data, 
		name_param, type_cell);


	/*
	 * remove temporary file
	 */
	if (exist_file_tmp) remove(name_swap_file);


	/*
	 * close output file
	 */
	closeFile(fp_out);
	if (type_f == FIELD) {
		
		/*
		 * with Field close output file
		 */
		closeFile(fp_out_crd);
	}


	/*
	 * send to user end processing status
	 * information
	 */
	msgEndOk(line, type_f, out_name_f, name_file_crd);

	return(TRUE);
} /* diraToAvs */
