/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/****************************************************************************
                  INTERNATIONAL AVS CENTER
        (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
******************************************************************************/
/*   This software is copyright (C) 1990,  Regents  of  the
University  of  California.   Anyone may reproduce dump_icc.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of dump_icc.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  dump_icc.c under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Dump_icc.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof.     */

/*
             wes bethel
             lawrence berkeley lab
	     ewbethel@lbl.gov

	     convert from Ximage to "icc" file.  the "icc"
	     file is suitable for sending to a kodak xl7700
	     printer.

	     last modified: 12 nov 1990
*/


#include <stdio.h>

#include <avs/vex.h>
#include <avs/flow.h>
#include <avs/field.h>
#include <X11/Xlib.h>
#include <avs/avs_pixdata.h>

#include "icc.h"

static void DumpPixmap();

AVSinit_modules()
{
    int output_icc();
    AVSmodule_from_desc(output_icc);
}

int
output_icc()
{
    int icc_compute();
    int param;

    AVSset_module_name("dump icc", MODULE_RENDER);
    AVScreate_input_port("Input Field", "pixmap", REQUIRED);
    param = AVSadd_parameter("filename", "string", "", 0, 0);
    AVSadd_parameter_prop(param, "width", "integer", 4);
    AVSset_compute_proc(icc_compute);
}

static char last_fname[128]={"Zippy-the-pinhead"};

icc_compute(input,fname)
AVSpixdata *input;
char *fname;
{
    XWindowAttributes wa;
    Display *display;
    XImage *the_image;
    int status;
    unsigned long plane_mask;
    FILE *f;

    if (fname == NULL || *fname == '\0')
	return(0);

    if (strcmp(fname,last_fname) == 0)
	return(0);  /* don't overwrite last file. */
    else
	strcpy(last_fname,fname);

    /* open the display....*/
    if ((display = (Display *)XOpenDisplay((char *)NULL)) == NULL)
    {
	AVSwarning("Unable to open display.");
	return(0);
    }

    if (status = XGetWindowAttributes(display,input->window,&wa) == 0)
    {
	AVSwarning("Unable to get window attributes.");
	return(0);
    }

    if (wa.depth == 8)
	plane_mask = 0x0ff;
    else if (wa.depth == 24)
	plane_mask = 0x0ffffff;

    the_image = NULL;
    if ((the_image = (XImage *)XGetImage(display,input->window,0,0,wa.width,
					 wa.height,plane_mask,ZPixmap)) == NULL)
    {
	AVSwarning("Unable to get the image from the window.");
	return(0);
    }

    /* need to do something about checking for other windows which
       occlude this one.  there's something about checking for a
       "BadMatch" error.... this check should occur here, and the
       module should return(0) if any other window occludes the
       one we're interested in...  */

    f = fopen(fname,"w");
    if (f == NULL)
    {
	AVSwarning("Unable to open output file..");
	return(0);
    }

    if (wa.depth == 8)
    {
	/* this is not implemented yet -- 8 bit icc files. */
	AVSwarning(" 8 bit ICC files: not implemented.");
	return(0);
    }
    else
	Convert2Icc(f,the_image);

    XFree(the_image);

    fclose(f);
    
    return(1);
}

Convert2Icc(fd,image)
FILE *fd;
XImage *image;
{
    int	width, height;
    gen_hdr *gh;   /* from icc.h */
    image_hdr *ih;

    width = image->width;
    height = image->height;

    gh = get_gen_hdr();
    ih = get_image_hdr(width,height);
    
    write_gen_hdr(fd,gh);
    write_image_hdr(fd,ih);

    Image2Icc(image,fd);
}

#define ALPHA 0
#define RED 1
#define GREEN 2
#define BLUE 3

static 
Image2Icc(image, fd)
XImage *image;
FILE *fd;
{

    unsigned char *data;
    int w,h;

    w = image->width;
    h = image->height;

    data = (unsigned char *)malloc(w*h);

    load_data(data,image->data,RED,w,h);
    write_icc_plane(data,w,h,fd);
    
    load_data(data,image->data,GREEN,w,h);
    write_icc_plane(data,w,h,fd);

    load_data(data,image->data,BLUE,w,h);
    write_icc_plane(data,w,h,fd);
    free((char *)data);
}

load_data(d,id,index,w,h)
register unsigned char *d,*id;
int index,w,h;
{
    register int i;
    id += index;
    for (i=0;i<w*h;i++,id+=4)
	*d++ = *id;
}


write_icc_plane(b,w,h,f)
int w,h;
unsigned char *b;  /* input image buffer: argb byte order */
FILE *f;
{
    unsigned char *t;
    int modified_w;
    register unsigned char *s,*d;
    register int i,j;

    if (w & 0x7)
	modified_w = (w & (~0x7)) + 0x8;
    else
	modified_w = w;
    
    t = (unsigned char *)malloc(sizeof(char)*modified_w*h);
    d = t;
    s = b;
    for (j = 0;j<h;j++)
    {
	for (i=0;i<w;i++,s++)
	    *d++ = *s;
	for (i=i;i<modified_w;i++)
/*	    *d++ = (char)0;   ...black fill */
	    *d++ = (char)0xff; /* white fill */
    }
    fwrite(t,sizeof(char),modified_w*h,f);
    free((char *)t);
}
