/****************************************************************************
                  INTERNATIONAL AVS CENTER
        (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

Author:  "insert name" (if users state on release form that they wish to
remain anonymous, a control number will be placed at this location)
Modifications:  Who modified, date modified ( so donor does not receive blame
if modifications made and passed on to others do not work as described)
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce avs2sun.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  avs2sun.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  avs2sun.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     avs2sun.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
avs2sun.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

/**
  * this module will produce a sun rasterfile.  this module recognizes
  * the difference between 8 and 24/32 bit images/pixmaps.  untested
  * are 16 bit systems (stardent 800 and 800e).
**/

#include <stdio.h>
    
#include <X11/Xlib.h>
#include <avs/avs.h>
#include <avs/avs_pixdata.h>

#ifndef SUN    
#include "rasterfile.h"
#else
#include <rasterfile.h>
#endif

AVSinit_modules()
{
    int avs2sunras();
    AVSmodule_from_desc(avs2sunras);
}

avs2sunras()
{
    int sunras_p(),p;
    AVSset_module_name("dump sunras",MODULE_RENDER);
    
    AVScreate_input_port("Input Field", "pixmap", REQUIRED);
    p = AVSadd_parameter("filename", "string", "", 0, 0);
    AVSadd_parameter_prop(p, "width", "integer", 4);
    
    AVSset_compute_proc(sunras_p);
}

static char last_fname[128]={"Zippy-the-pinhead"};

int
sunras_p(inp,fname)
AVSpixdata *inp;
char *fname;
{
    XWindowAttributes wa;
    Display *display;
    XImage *the_image;
    int status;
    unsigned long plane_mask;
    FILE *f;

    if (fname == NULL || *fname == '\0')
	return(0);

    if (strcmp(fname,last_fname) == 0)
	return(0);  /* don't overwrite last file. */
    else
	strcpy(last_fname,fname);

    /* open the display....*/
    if ((display = (Display *)XOpenDisplay((char *)NULL)) == NULL)
    {
	AVSwarning("Unable to open display.");
	return(0);
    }

    if (status = XGetWindowAttributes(display,inp->window,&wa) == 0)
    {
	AVSwarning("Unable to get window attributes.");
	return(0);
    }

    if (wa.depth == 8)
	plane_mask = 0x0ff;
    else if (wa.depth == 24)
	plane_mask = 0x0ffffff;

    the_image = NULL;
    if ((the_image = (XImage *)XGetImage(display,inp->window,0,0,wa.width,
					 wa.height,plane_mask,ZPixmap)) == NULL)
    {
	AVSwarning("Unable to get the image from the window.");
	return(0);
    }

    /* need to do something about checking for other windows which
       occlude this one.  there's something about checking for a
       "BadMatch" error.... this check should occur here, and the
       module should return(0) if any other window occludes the
       one we're interested in...  */

    /* do file manipulation...*/

    f = fopen(fname,"w");
    if (f == NULL)
    {
	AVSwarning("Unable to open output file..");
	return(0);
    }

    if (wa.depth == 8)
    {
	if (create_8bit_sunras(fileno(f),the_image,&wa,display) == 0)
	{
	    AVSwarning("Failed to produce valid 8bit sun rasterfile.");
	    return(0);  /* failure of some type. */
	}
    }
    else
	create_24bit_sunras(fileno(f),the_image,&wa);


    fclose(f);
    XFree(the_image);
    
    return(1);
}

create_8bit_sunras(fd,ximg,wa,disp)
int fd;
XImage *ximg;
XWindowAttributes *wa;
Display *disp;
{
    struct rasterfile rh;
    XColor table[256];
    unsigned char byte_table[256*3];
    int i,scanline_length;
    unsigned char *scanline_buf,*src;

    if (wa->map_installed == 0) /* no colormap -- punt */
	return(0);
    
    if (ximg->width & 0x01)  /* odd # of bytes/scanline */
	scanline_length = ximg->width+1;
    else
	scanline_length = ximg->width;
    
    rh.ras_magic = RAS_MAGIC;
    rh.ras_width = ximg->width;
    rh.ras_height = ximg->height;
    rh.ras_depth = 8;
    rh.ras_type = RT_STANDARD;
    rh.ras_maptype = RMT_RAW;
    rh.ras_maplength = 256*3;
    rh.ras_length = ximg->height * scanline_length; 

    scanline_buf = (unsigned char *)malloc(scanline_length);
    memset((char *)scanline_buf,0,scanline_length);

    write(fd,(char *)&rh,sizeof(struct rasterfile));

    /* deal with colormap. */
    for (i=0;i<256;i++)
	table[i].pixel = i;
    XQueryColors(disp,wa->colormap,table,256);
    
    x_to_byte_colors(table,byte_table,256);

    /* write out colormap to sunrasterfile. */
    write(fd,(char *)byte_table,rh.ras_maplength);

    /* write out the image */

    src = (unsigned char *)ximg->data;
    
    for (i=0;i<ximg->height;i++,src+=ximg->bytes_per_line)
	write(fd,(char *)src,scanline_length);

    return(1);
}

x_to_byte_colors(xt,bt,n)
XColor *xt;
unsigned char *bt;
int n;
{
    /**
      * this routine will create a table of byte-length rgb values
      * given an input table consisting of a number of XColor
      * entries.  In the X world, color entries are composed of
      * 16-bit wide values.  We will scale appropriately into 8 bits.
    **/
    int roff,goff,boff,i;

    roff = 0;
    goff = n;
    boff = 2*n;
    for (i=0;i<n;i++,roff++,boff++,goff++)
    {
	*(bt+roff) = (xt[i].red) >> 8;
	*(bt+goff) = (xt[i].green) >> 8;
	*(bt+boff) = (xt[i].blue) >> 8;
    }
}

create_24bit_sunras(fd,ximg,wa,disp)
int fd;
XImage *ximg;
XWindowAttributes *wa;
Display *disp;
{
    struct rasterfile rh;
    XColor table[256];
    unsigned char byte_table[256*3];
    int i,j,scanline_length;
    unsigned char *scanline_buf,*src;
    int bytes_in_scanline_buf;
    unsigned char temp;
    
    
    rh.ras_magic = RAS_MAGIC;
    rh.ras_width = ximg->width;
    rh.ras_height = ximg->height;
    rh.ras_depth = 24;
    rh.ras_type = RT_STANDARD; /* use this because there's a lot of
				  software out there that doesn't correctly
				  handle the type 3 (RGB) format. */
    rh.ras_maptype = RMT_NONE;
    rh.ras_maplength = 0;

    /* the length of the scanline (in the file) has to be an
       even multiple of 16 bits.  however, the bytes are written out
       in rgbrgb... format.  so, if the # of pixels per scanline is
       an even multiple of 2, then the # of bytes in the scanline is
       an even multiple of 2 (no padding required).  if the # of pixels
       is odd, then we simply add a 1 byte pad. */
    
    scanline_length = ximg->width;
    if (scanline_length & 0x1)
	bytes_in_scanline_buf = scanline_length*3 + 1;
    else
	bytes_in_scanline_buf = scanline_length*3;

    /* the scanline buf is used only in the case of 32 bits/pixel
       images (typical in AVS, for example) because we have to
       copy over the RGB bytes, thus skipping over the A byte */
    
    scanline_buf = (unsigned char *)malloc(bytes_in_scanline_buf);
    memset((char *)scanline_buf,0,bytes_in_scanline_buf);

    rh.ras_length = ximg->height * bytes_in_scanline_buf;

    write(fd,(char *)&rh,sizeof(struct rasterfile));

    /* write out the image */
    src = (unsigned char *)ximg->data;
    
    if (ximg->bits_per_pixel == 24)
    {
	/* untested: possible r/b byte ordering error...may need
	   to switch the position of the red and blue bytes similarly
	   to how this is handled in the 32bit image (below) */
	
        for (i=0;i<ximg->height;i++,src+=ximg->bytes_per_line)
	    write(fd,(char *)src,bytes_in_scanline_buf);
    }
    else /* assume 32 bits per pixel, have to do some weird stuff to
	    remove the alpha byte... */
    {
	for (i=0;i<ximg->height;i++,src+=ximg->bytes_per_line)
	{
	    for(j=0;j<ximg->width;j++)
	    {
		memcpy((char *)(scanline_buf+j*3),(src+j*4+1),3);
		temp = *(scanline_buf+j*3);
		*(scanline_buf+j*3) = *(scanline_buf+j*3+2);
		*(scanline_buf+j*3+2) = temp;
            }

	    write(fd,(char *)scanline_buf,bytes_in_scanline_buf);
	}
    }

    return(1);
}

