/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

Author:  Larry Gelber   Stardent Computer, Inc.
******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "fix points" (Filter) (Subroutine)                       */
/* Author: Larry Gelberg                                                 */
/* Date Created: Tue Nov 19 10:05:27 1991                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* input 0 "input" field 2D 3-space uniform REQUIRED                     */
/* output 0 "output" field 2D 3-space uniform                            */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
/* *****************************************/
/*  Module Specification                   */
/* *****************************************/
int fix_points_spec()
{
	int in_port, out_port, param;
	extern int fix_points_compute();

	AVSset_module_name("fix points", MODULE_FILTER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("input", "field 2D 3-space uniform", 
		REQUIRED);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("output", "field 2D 3-space uniform");
	AVSinitialize_output(in_port, out_port);

	AVSset_compute_proc(fix_points_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int fix_points_compute( input, output )
	AVSfield *input;
	AVSfield **output;
{
    int data_len;

    /* copy data */
    data_len = AVSfield_prod(input->ndim, input->dimensions) *
      input->veclen * AVStypesize(input->type);
    memcpy ((*output)->field_data, input->field_data, data_len);
    
    /* copy points */
    AVSfield_copy_points(input, *output);

    /* fix points */
    if (input->points[0] == input->points[1])
      (*output)->points[0] = (*output)->points[1] = 0.0;
    else if (input->points[2] == input->points[3])
      (*output)->points[2] = (*output)->points[3] = 0.0;
    else if (input->points[4] == input->points[5])
      (*output)->points[4] = (*output)->points[5] = 0.0;
    
    return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*filter_mod_list[])()) = {
	fix_points_spec,
};
#define NMODS (sizeof(filter_mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(filter_mod_list, NMODS);
}
