/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/* mod_gen Version 1                                                     */
/* Module Name: "gui page" (Output) (Subroutine)                         */
/* Author: John Stephen (Tessella) 0235-555511                           */
/* Date Created: Tue Feb 23 12:12:32 1993                                */
/*                                                                       */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
 
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int gui_page_desc()
{

	int in_port, out_port, param, iresult;
	extern int gui_page_compute();

	AVSset_module_name("gui page", MODULE_RENDER);

	/* Parameter Specifications                */
	param = AVSadd_parameter("panel name", "string", "", "", ":");
	AVSconnect_widget(param, "typein");
	param = AVSadd_parameter("parent", "string", "", "", ":");
	AVSconnect_widget(param, "typein");
	param = AVSadd_parameter("execute", "oneshot", 0, 0, 1);
	AVSconnect_widget(param, "oneshot");
	param = AVSadd_parameter("visible", "boolean", 1, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("left", "integer", 500, 1, 999);
	AVSconnect_widget(param, "idial");
	param = AVSadd_parameter("top", "integer", 500, 1, 999);
	AVSconnect_widget(param, "idial");
	param = AVSadd_parameter("width", "integer", 300, 1, 999);
	AVSconnect_widget(param, "idial");
	param = AVSadd_parameter("height", "integer", 50, 1, 999);
	AVSconnect_widget(param, "idial");
	param = AVSadd_parameter("panel","choice","panel",
		"panel:container",":");
	AVSconnect_widget(param,"radio_buttons");

	AVSset_compute_proc(gui_page_compute);
	return(1);
}
 

/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int gui_page_compute( panel_name, parent, execute, visible, left, top, width, height, panel)
	char *panel_name;
	char *parent;
	int execute;
	int visible;
	int left;
	int top;
	int width;
	int height;
	char *panel;
{
	static char theName[80];
	static char command[250], *output, *error;
	char *a;
	int quote;
	char c_parent[80], c_panel[80], *c_visible;


	if(	AVSparameter_changed("execute")
	    ||  AVSparameter_changed("left")	
	    ||  AVSparameter_changed("top")	
	    ||  AVSparameter_changed("width")	
	    ||  AVSparameter_changed("height")	
	    ||  AVSparameter_changed("visible")	) { 
		if(! panel_name || *panel_name == '\0' || *panel_name == ' ') { 
			return(0);
		}

		/* enclose in quotes if they are not already there */
		quote=0; a=panel_name;
		while(*a) { if(*a == '\"'){ quote=1; } a++; }
		if(quote) {
			strcpy(c_panel, panel_name);
		}
		else {
			strcpy(c_panel,"\"");
			strcat(c_panel, panel_name);
			strcat(c_panel,"\"");
		}
		if(! parent || *parent == '\0' || *parent == ' ') {
			strcpy(c_parent, "ui");
		}
		else {
			/* enclose in quotes if they are not already there */
			quote=0; a=parent;
			while(*a) { if(*a == '\"'){ quote=1; } a++; }
			if(quote) {
				strcpy(c_parent, parent);
			}
			else {
				strcpy(c_parent,"\"");
				strcat(c_parent, parent);
				strcat(c_parent,"\"");
			}
		}
		if(visible) {
			c_visible = "-show";
		}
		else {
			c_visible = "-hide";
		}
		sprintf(command,"panel %s -w %s -p %s %s -xy %d,%d -wh %d,%d",
			c_panel,	panel, 	c_parent,
			c_visible,	left,	top,
			width,		height);
puts(command);
		AVScommand("kernel",command,&output,&error);
	}
	else {
		return(0);
	}

	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
static int ((*mod_list[])()) = {
	gui_page_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
