/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

AUTHOR : Wes Bethel  Lawrence Berkeley Laboratory
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce psfiltmono.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  psfiltmono.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  psfiltmono.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     psfiltmono.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
psfiltmono.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>
#include <avs/flow.h>
#include "no_sprintf.h"

#define PAGE_WIDTH 8.5
#define PAGE_HEIGHT 11.0
#define PTS_PER_INCH 72

    
AVSinit_modules()
{
   int psfilter();
   AVSmodule_from_desc(psfilter);
}

psfilter()
{
   int psfilter_main_mono();
   int p;

   AVSset_module_name("output 8bit ps", MODULE_RENDER);

   p = AVScreate_input_port("Input Field", "field 2D scalar byte", REQUIRED);

   p = AVSadd_parameter("filename", "string", "", "", "");
   AVSconnect_widget(p,"typein");
   AVSadd_parameter_prop(p,"width","integer",12);

   AVSset_compute_proc(psfilter_main_mono);
}


psfilter_main_mono(image,fname)
AVSfield_char *image;
char *fname;
{
    FILE *out;
    int width, height;

    if ((fname == NULL) || (*fname == '\0'))
       return(0);  /* not really an error... */

    if ((out = fopen(fname,"w"))==NULL)
    {
	AVSmessage("psfilter.mono", AVS_Warning, AVSmodule, "output color ps",
		   "Ok", "Can't open  data file <%s>", fname);
	return(0);
    }

    if (image == NULL)
       return(0);

    width = MAXX(image);
    height = MAXY(image);

    if (!create_ps_file(image,out,width,height))
	return(0);  /* error state */
    else
    {
	*fname = '\0';
	return(1); /*  success */
    }
    return(1);
}

static char *outbuf;

create_ps_file(in,out,w,h)
FILE *out;
AVSfield_char *in;
int w,h;
{
    int buffersize;
    int i,j,ptr=0;
    unsigned char opacity,red,green,blue;
    double moveto_x,moveto_y;
    double width_x,height_y;
    double pixels_to_points_x,pixels_to_points_y,pixels_to_points;
    double img_ptsize_x,img_ptsize_y;
    char c = '%';

    /* first, attempt to use a maximal amount of the page,
       allowing for a half-inch of margin around the picture */
   
    width_x = (PAGE_WIDTH-1.) * PTS_PER_INCH;
    height_y = (PAGE_HEIGHT-1.) * PTS_PER_INCH;
    
    /* now have width, height of device page in points. need
       to establish mapping from image to points (find best fit) */
    
    pixels_to_points = pixels_to_points_x = width_x/(double)w;
    pixels_to_points_y = height_y/(double)h;
    pixels_to_points = (pixels_to_points < pixels_to_points_y) ?
	pixels_to_points : pixels_to_points_y;

    /* misc stuff, center of page, initial moveto location */
    img_ptsize_x = (double)w*pixels_to_points;
    img_ptsize_y = (double)h*pixels_to_points;
    
    moveto_x = width_x + PTS_PER_INCH - img_ptsize_x;
    moveto_x *= 0.5;
    moveto_y = height_y + PTS_PER_INCH - img_ptsize_y;
    moveto_y *= 0.5;

    buffersize = w*2;  /* width times 2 (two bytes per primary) */

    if ((outbuf=(char *)malloc(sizeof(char)*buffersize+1))==NULL)
	return(0);
    /* need buffersize + 1 because the strcpy tacks on a null char */
    
    fprintf(out,"%c!PS-Adobe-1.0\n",c);
    fprintf(out,"/rgbstr %d string def \n",buffersize/2);
    fprintf(out,"%g %g translate\n",moveto_x,moveto_y);
    fprintf(out,"%g %g scale\n",img_ptsize_x,img_ptsize_y);
    fprintf(out,"%d %d 8 \n",w,h);
    fprintf(out,"[%d 0 0 -%d 0 %d]\n",w,h,h);
    fprintf(out,"{currentfile rgbstr readhexstring pop}\n");
    fprintf(out,"image \n");
   
    for(j=0;j<h;j++)
    {
	ptr = 0;
	for(i=0;i<w;i++)
	{
	    red = *(I2DV(in,i,j)+1);
	    strcpy(outbuf+(ptr++<<1),no_sprintf[red]);
	}
	fwrite(outbuf,sizeof(char),buffersize,out);
	fprintf(out,"\n");
    }
    fprintf(out,"showpage\n");
    fflush(out);
    fclose(out);
    free(outbuf);
    return(1);  /* success */
}
