/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/***************************************************************************

     Copyright 1992 Convex Computer Corporation.  All rights reserved.

     Permission to copy and modify this software and its documentation
     only for internal use in your organization is hereby granted,
     provided that this notice is retained thereon and on all copies.
     Convex makes no representations as to the suitability and
     operability of this software for any purpose.  It is provided "as
     is" without express or implied warranty.

     CONVEX DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
     IN NO EVENT SHALL CONVEX BE LIABLE FOR ANY SPECIAL, INDIRECT OR
     CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHATSOEVER RESULTING
     FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
     CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
     IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

     No other rights, including, for example, the right to redistribute
     this software and its documentation or the right to prepare
     derivative works, are granted unless specifically provided in a
     separate license agreement.

     Copyright 1992 Convex Computer Corporation.  All rights reserved.

***************************************************************************/

#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include "a60.h"

extern char *AVSstatic;

/*
 *  unix_error -- Print an error from a Unix system call.  The "Connection
 *		  refused" error is treated specially, to give more info.
 */

unix_error(msg)
char *msg;
{
    extern int errno;
    extern char *sys_errlist[];

    AVSfatal("%s: %s\nModule exiting.", msg, sys_errlist[errno]);
    exit(1);
}

error(msg)
char *msg;
{
    AVSfatal("%s\nModule exiting", msg);
    exit(1);
}

/*
 *  parse_location() parses a tape location string and stores the
 *  number of frames in *frame_p.  It returns a number to indicate
 *  what format the tape location string had.
 *
 *  The return values are:
 *
 *	0	parse error
 *	1	frame
 *	2	sec:frame
 *	3	min:sec:frame
 *	4	hour:min:sec:frame
 */

static int parse_location(string, frame_p)
char *string;
int *frame_p;
{
	char	*p;
	int	i, n, numbers[4];
	static int mult[4] = {1, 30, 30*60, 30*60*60};

	p = string;
	while (*p == ' ' || *p == '\t') p++;	/* skip whitespace */
	for (n = 0;;p++) {
		numbers[n] = 0;
		for (i = 0; isdigit(*p); i++)
			numbers[n] = numbers[n]*10 + (*p++) - '0';
		if (i <= 0) return 0;
		if (++n >= 4 || *p != ':') break;
	}
	while (*p == ' ' || *p == '\t') p++;	/* skip whitespace */
	if (*p) return 0;
	*frame_p = 0;
	for (i = 0; i < n; i++) 
		*frame_p += numbers[n-i-1]*mult[i];
	return n;
}

/*
 *  format_location() formats the frame number in frame into outbuf
 *  according to the format in format.  The format is as returned by
 *  parse_location().
 */

static void format_location(frame, format, outbuf)
int frame;
int format;
char *outbuf;
{
    int hours, minutes, seconds, frames;
    if (format == 1)
	sprintf(outbuf, "%d", frame);
    else if (format == 2) {
	seconds = frame / 30;
	frames  = frame % 30;
	sprintf(outbuf, "%02d:%02d", seconds, frames);
    } else if (format == 3) {
	minutes = frame / 30 / 60;
	seconds = frame / 30 % 60;
	frames  = frame % 30;
	sprintf(outbuf, "%02d:%02d:%02d", minutes, seconds, frames);
    } else if (format == 4) {
	hours   = frame / 30 / 60 / 60;
	minutes = frame / 30 / 60 % 60;
	seconds = frame / 30 % 60;
	frames  = frame % 30;
	sprintf(outbuf, "%02d:%02d:%02d:%02d", hours, minutes, seconds, frames);
    } else
	assert(0);
}

static int output_a60_init()
{
    AVSstatic = NULL;
}

static int output_a60_destroy()
{
    AVSstatic = NULL;
}

static int output_a60_compute(image, 
			      hostname, 
			      insert_point_string, 
			      edit_length, 
			      record)
AVSfield_char *image;
char *hostname;
char *insert_point_string;
int edit_length;
int record;
{
	int insert_point;
	char new_insert_point_string[10];
	int format;
	generic_image *yuv, *image_to_yuv();

    /* If we haven't set hostname yet, return */
	if (!hostname || !strcmp(hostname, DEFAULT_HOSTNAME)) 
		return 1;

    /* If the image didn't change, don't do anything. */

	if (!image || !AVSinput_changed("image", 0) || !record)
		return 1;

    /* Parse point-of-insertion string */

	format = parse_location(insert_point_string, &insert_point);
	if (format == 0) {
            AVSerror("Can't parse tape location `%s'.\n\
Must be subset of the form \"hh:mm:ss:ff\".", insert_point_string);
	    return 0;
	}

    /* Convert AVS image to YUV representation */

	yuv = image_to_yuv(image);
	if (yuv == NULL) {
	   AVSerror("Can't convert AVS image to YUV format");
	   return 0;
	}

    /* Send image data to a60 host */

	a60_start_edit(yuv, hostname, insert_point, edit_length);
	image_destroy(yuv);

	insert_point += edit_length;
	format_location(insert_point, format, new_insert_point_string);
	AVSmodify_parameter("Insert Point", AVS_VALUE,
			    new_insert_point_string, NULL, NULL);

    return 1;
}

static int output_a60_spec()
{
    int param;

    AVSset_module_name("output a60",  MODULE_RENDER);
    AVSset_module_flags(COOPERATIVE | REENTRANT);

    /* Input Port Specifications */
    AVScreate_input_port("image", "field 2D 4-vector uniform byte", OPTIONAL);

    /* Parameter Specifications */

    param = AVSadd_parameter("A60 Hostname", "string", DEFAULT_HOSTNAME, "", "");
    AVSconnect_widget(param, "typein");

    param = AVSadd_parameter("Insert Point", "string", "00:00:00", "", "");
    AVSconnect_widget(param, "typein");

    param = AVSadd_parameter("Edit Length", "integer", 1, 1, 270000);
    AVSconnect_widget(param, "typein_integer");

    param = AVSadd_parameter("Record", "boolean", 0, 0, 1);
    AVSconnect_widget(param, "toggle");

    AVSset_init_proc(output_a60_init);
    AVSset_compute_proc(output_a60_compute);
    AVSset_destroy_proc(output_a60_destroy);
}

/******************************************************/
/* initialization for modules contained in this file. */
/******************************************************/
int ((*filter_mod_list[])()) = {
    output_a60_spec,
};
#define NMODS (sizeof(filter_mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(filter_mod_list, NMODS);
}
