/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

Author:  Terry Myerson
	 International AVS Center
	 North Carolina Supercomputing Center
******************************************************************************/

/*
 * This code was adapted from write_A60_yuv.c written by Terry Myerson at
 * the International AVS Center.  Principle differences include making the
 * code callable as a routine rather than as a module and hand optimizations
 * to make it run faster on a Convex.
 */

#include <stdio.h>
#include <stdlib.h>
#include <avs/vex.h>
#include <avs/flow.h>
#include <avs/field.h>
#include "a60.h"

#define  A60_Height 486    /* fixed size */
#define  A60_Width  720

#define putimage(tmp)	(*image++=(tmp))

#define shift_up(val,buf) \
        (buf[4]=buf[3],buf[3]=buf[2],buf[2]=buf[1],buf[1]=buf[0],buf[0]=val)

generic_image *
image_to_yuv(input)
AVSfield_char *input;
{
   int size, bp, i;
   uchar *inbuf, *image;
   float r,g,b,y,u,v;
   int xsrc,ysrc,xlen,ylen,xdst,ydst;
   int tmp,line,pixel;
        		/* buffers for filtering data */
   double y_buff[5];	/* y buff is one sample longer to delay it */
   double u_buff[5];	/* in line with the chroma */
   double v_buff[5];	/* which is sampled at half the frequency */
   generic_image *yuv;

   size =  A60_Width * A60_Height * 4;
   inbuf = (uchar *)malloc(size);
   if (inbuf == NULL) return NULL;
   bp = 0;

   yuv = malloc(sizeof(generic_image));
   if (yuv == NULL) {
       FREE_LOCAL(inbuf) ;
      return NULL;
   }

   yuv->image_format = YUV;
   yuv->image_width = A60_Width;
   yuv->image_height= A60_Height;
   yuv->image_depth = 2;
   yuv->image_size = size/2;
   image = yuv->image_data = (uchar *)malloc( size/2 );
   if (yuv->image_data == NULL) {
       FREE_LOCAL(inbuf) ;
       FREE_LOCAL(yuv) ;
      return NULL;
   }

   /* modify the format storage */
   /* matte the image in place by centering */

   xsrc = 0;
   ysrc = 0;
   xlen = MAXX(input);
   ylen = MAXY(input);
   xdst = (A60_Width-xlen)/2;
   ydst = (A60_Height-ylen)/2;

   if (xdst < 0) {
      xsrc = -xdst;
      xlen += xdst;
      xdst = 0;
   }

   if (ydst < 0) {
      ysrc = -ydst;
      ylen += ydst;
      ydst = 0;
   }

   if (xdst+xlen >  A60_Width) xlen = A60_Width-xdst;
   if (ydst+ylen > A60_Height) ylen = A60_Height-ydst;

   if (xlen < A60_Width || ylen < A60_Height)
      memset(inbuf, 0, size);

   for (i = 0; i < ylen; i++)
      memcpy(inbuf+((ydst+i)*A60_Width+xdst)*4,
             input->data+((ysrc+i)*MAXX(input)+xsrc)*4,
             xlen*4);

   for (line = 0; line < A60_Height; line++) {
   
      /* deal with a U Y V Y sequence each time around */
   
      for (i = 0; i < 5; i++)
         y_buff[i] = u_buff[i] = v_buff[i] = 0;
   
      for (pixel = 0; pixel < A60_Width; pixel += 2) {
   
         /* first pixel gives Y and both chroma */
   
         bp++;				/* skip alpha info */
         r = inbuf[bp++] / 255.0;
         g = inbuf[bp++] / 255.0;
         b = inbuf[bp++] / 255.0;
   
         y = 0.299 * r + 0.587 * g + 0.114 * b;
         shift_up ( y,y_buff );
   
         u = -0.1686 * r - 0.3311 * g + 0.4997 * b;
         shift_up ( u,u_buff );
   
         v = 0.4998 * r - 0.4185 * g - 0.0813 * b;
         shift_up ( v,v_buff );
   
         u =   ( 0.14963 * u_buff[0] )   /* filtered value */
             + ( 0.22010 * u_buff[1] )
             + ( 0.26054 * u_buff[2] )
             + ( 0.22010 * u_buff[3] )
             + ( 0.14963 * u_buff[4] ) ;
   
         u *= 224.0;    /* -112 .. +112 range */
         tmp = u + 128;	/* centered on 128 */
         putimage(tmp);
   
         y = - (0.05674 * y_buff[0])
             + (0.01883 * y_buff[1])
    	     + (1.07582 * y_buff[2])
             + (0.01883 * y_buff[3])
             - (0.05674 * y_buff[4]) ;
   
         y *= 219.0;		/* 16 .. 235 range */
         tmp = y + 16;      /* offset by 16	   */
         putimage(tmp);
    
         v =   (0.14963 * v_buff[0])
             + (0.22010 * v_buff[1])
             + (0.26054 * v_buff[2])
             + (0.22010 * v_buff[3])
             + (0.14963 * v_buff[4]);
   
         v *= 224.0;
         tmp = v + 128;
         putimage(tmp);
   
         /* second pixel just yields a Y */
    
         bp++;				/* skip alpha info */
         r = inbuf[bp++] / 255.0;
         g = inbuf[bp++] / 255.0;
         b = inbuf[bp++] / 255.0;
   
         y = 0.299 * r + 0.587 * g + 0.114 * b;
         shift_up ( y,y_buff );
   
         u = -0.1686 * r - 0.3311 * g + 0.4997 * b;
         shift_up ( u,u_buff );
   
         v = 0.4998 * r - 0.4185 * g - 0.0813 * b;
         shift_up ( v,v_buff );
   
         y = - (0.05674 * y_buff[0])
             + (0.01883 * y_buff[1])
             + (1.07582 * y_buff[2])
             + (0.01883 * y_buff[3])
             - (0.05674 * y_buff[4]) ;
   
         y *= 219.0;               /* 16 .. 235 range */
         tmp = y + 16;      /* offset by 16    */
         putimage(tmp);
      }
   }

    FREE_LOCAL(inbuf) ;
   return yuv;
}

void
image_destroy(yuv)
generic_image *yuv;
{
   if (yuv) {
      if (yuv->image_data)
          FREE_LOCAL(yuv->image_data) ;
       FREE_LOCAL(yuv) ;
   }
}
