/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>

/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int print_verts_desc()
{

	int in_port, out_port, param;
	extern int print_verts_compute();

	AVSset_module_name("print verts", MODULE_RENDER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("input", "geom", REQUIRED);

	AVSset_compute_proc(print_verts_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int print_verts_compute( input)
	GEOMedit_list input;
{
   int edit_type;

   edit_type=(input->l)->type;

   printf ("GEOM EDIT NAME : %s \n",(input->l)->name);
  
   if (edit_type==0) process_geometry((input->l)->data);

   return (1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	print_verts_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}

process_geometry(geometry)
   GEOMobj *geometry;
{
   int i,k;

   switch ( geometry->type )
   {
      case GEOM_MESH       :    
         printf ("MESH OBJECT \n");
         GEOMcvt_mesh_to_polytri(geometry,GEOM_SURFACE);
   	 break; 
      case GEOM_POLYHEDRON :  	
         printf ("POLYHEDRON OBJECT \n");
         GEOMcvt_polyh_to_polytri(geometry,GEOM_SURFACE);
   	 break; 
      case GEOM_SPHERE	   :    
         printf ("SPHERE OBJECT \n");
         geometry=GEOMcvt_sphere_to_polytri(geometry,8,GEOM_SURFACE);
         break;
      case GEOM_LABEL	   :    
         printf ("LABEL OBJECT \n");
         return 0;
 	 break;	
      case GEOM_POLYTRI    :    
         printf ("POLYTRIANGLE OBJECT \n");
         break;
      default		   :    
         fprintf(stderr,"print verts: UNKNOWN OBJECT TYPE\n");	
         return 0;
  	 break;
   }

   for (k=0; k < PT(geometry).npts; k++)
      for (i=0; i<PT(geometry).ptverts[k].n; i++)
         printf("X is %f, Y is %f, Z is %f\n",
	    PT(geometry).ptverts[k].l[3*i],
            PT(geometry).ptverts[k].l[3*i + 1],
            PT(geometry).ptverts[k].l[3*i + 2] );
}
