/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

AUTHOR : Stardent Computer, Inc.
******************************************************************************/
/*
 * print_xfrm = Print Upstream Transform Port Data
 *
 * An AVS3 module to print the current contents of an
 * upstream transform port connection
 *
 * Author: I. Curington
 *         Stardent Computer Ltd.
 *         Guildford, Surrey, UK
 *
 * Input Port: upstream transform
 *
 * Revision:  20 February 91  Original (ianc)
 *
 */

#include <stdio.h>
#include <avs/flow.h>
#include <avs/udata.h>

/******************************************************************************/
AVSinit_modules()
{
        int print_xfrm_desc();
        AVSmodule_from_desc(print_xfrm_desc);
}

/******************************************************************************/
print_xfrm_desc()
{
    int param, print_xfrm_compute();

    AVSset_module_name  ("print xfrm", MODULE_RENDER);
/*
    AVSset_module_name  ("print upstream xfrm", MODULE_RENDER);
*/
    AVScreate_input_port("Input Transform",
                         "struct upstream_transform", REQUIRED);
    param=
    AVSadd_parameter("Transform","string_block",
                     " === Upstream Transform ===\n","","");
    AVSadd_parameter_prop(param,"height","integer",10);
    AVSadd_parameter_prop(param,"width","integer",4);
    AVSset_compute_proc (print_xfrm_compute);
}

/******************************************************************************/
#define SCAT  strcat ( str, strt );

print_xfrm_compute(input,string)
upstream_transform *input;
char *string;
{
  int i;
  char str[500], strt[80];

  sprintf(str, " === Upstream Transform ===\n");
  sprintf(strt," object name =\n %s\n",     input->object_name );         SCAT
  sprintf(strt," window size = %d %d\n",    input->width, input->height); SCAT
  sprintf(strt," mouse (x y) = %d %d\n",    input->x,     input->y);      SCAT

  if (input->button == 1 )
  {
      sprintf(strt," button = LEFT\n");   SCAT
  }
  else if (input->button == 2 )
  {
      sprintf(strt," button = MIDDLE\n"); SCAT
  }
  else
  {
      sprintf(strt," button = RIGHT\n");  SCAT
  }

  if ((input->flags & BUTTON_UP) != 0 )
  {
      sprintf(strt," button state = BUTTON_UP\n"); SCAT
  }
  if ((input->flags & BUTTON_DOWN) != 0 )
  {
      sprintf(strt," button state = BUTTON_DOWN\n"); SCAT
  }
  if ((input->flags & BUTTON_MOVING) != 0 )
  {
      sprintf(strt," button state = BUTTON_MOVING\n"); SCAT
  }

  sprintf(strt," Transform Matrix:\n"); SCAT
  for (i=0; i<4; i++)
  {
    sprintf (strt,"%9.3f %9.3f %9.3f %9.3f\n",
              input->msxform[i][0],
              input->msxform[i][1],
              input->msxform[i][2],
              input->msxform[i][3] ); SCAT
  }
  AVSmodify_parameter("Transform",AVS_VALUE,str,NULL,NULL);
}

