/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1992,  Regents  of  the
University  of  California.   Anyone may reproduce image_io.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  image_io.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  image_io.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     image_io.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
image_io.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/


#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>

/** the template for making a temporary copy of the file.  if you
  don't have "enough" room on /tmp on your system for large image files,
  then replace /tmp with an appropriate path. **/

static char fname_template[]={"/tmp/avsimg.XXXXXX"};

/** the path and name of the compress and uncompress and rm utilities.  these
  are valid on Suns, and the Titan class machines (maybe others as well) **/

static char compress_command[]={"/usr/ucb/compress"};
static char uncompress_command[]={"/usr/ucb/uncompress"};
static char rm_command[] = {"/bin/rm"};

/** the modules present in this file **/

int read_compressed_avs_image(),
    write_compressed_avs_image();

int ((*mod_list[])()) =
{
    read_compressed_avs_image,
    write_compressed_avs_image
};

AVSinit_modules()
{
    AVSinit_from_module_list(mod_list,sizeof(mod_list)/sizeof(char *));
}

read_compressed_avs_image()
{
    int read_comp(),p;
    
    AVSset_module_name("read compressed image",MODULE_DATA);
    AVScreate_output_port("output float image","field 2D 4-vector byte");
    p=AVSadd_parameter("Input Image","string","","","");
    AVSconnect_widget(p,"browser");
    AVSset_compute_proc(read_comp);
}

read_comp(outf,input_filename)
AVSfield_char **outf;
char *input_filename;
{
    AVSfield_char template;
    int dims[2];
    char *fname,fn[64],fnz[64];
    char command[128];
    FILE *f;
    int width,height;
    extern char *mktemp();
    int pid,status;
    int t;

    if ((input_filename == NULL) ||
	(*input_filename == '\0'))
	return(0);

    /**
      * check to see if the input file has a .Z suffix.  the following check
      * isn't very rigorous, but should catch most of the problem files.
    **/

    t = strlen(input_filename);
    if ((input_filename[t-1] != 'Z') || (input_filename[t-2] != '.'))
    {
	AVSwarning(" Named file doesn't have a .Z suffix -- maybe not a compressed file??");
	return(0);
    }
    
    /**
      * first, uncompress the file.  this is accomplished by making
      * a copy into a temporary file.  making the copy subverts the
      * issue of requiring the person to have write permission on
      * the file, and having to recompress the file once done with the
      * read.  the penalty is the time is takes to copy the compressed
      * file to a temporary location.
    **/
    fname = mktemp(fname_template);
    
    strcpy(fn,fname);
    strcpy(fnz,fn);
    strcat(fnz,".Z");
    
    AVSmodule_status("decompressing",0);  /* this is informative only */
    
    /* build command buffer to copy from named user file to named temp file.,
     then compress that puppy */
    
    sprintf(command,"/bin/cp %s %s ; %s %s\n",input_filename,fnz,uncompress_command,fnz);

    status = system(command);
    status = (status & 0xff00) >> 8;
    if (status)
    {
	AVSfatal(" System called failed.");
	perror("image_io (read compressed image)");
    }
    
    /**
      * if all's well after the uncompress, read the image dimensions.
    **/

    AVSmodule_status("reading image",0);  /* this is informative only */
    f = fopen(fn,"r");
    fread((char *)&width,4,1,f);
    fread((char *)&height,4,1,f);
    
    /**
      * if there were no errors thus far, then go ahead an allocate the
      * output field based on the input dimensions read in.
    **/

    if (*outf)
	AVSfield_free((char *)(*outf));
		      
    memset((char *)&template,0,sizeof(AVSfield_char));
    
    template.ndim = 2;
    template.nspace = 0;
    template.veclen = 4;
    template.type = AVS_TYPE_BYTE;
    template.size = sizeof(char);
    template.uniform = UNIFORM;
    dims[0] = width;
    dims[1] = height;

    if (*outf)
	AVSfield_free(*outf);
    *outf = (AVSfield_char *)AVSfield_alloc(&template,dims);
    if (*outf == NULL)
    {
	AVSwarning(" Malloc failure in byte image to float.");
	return(0);
    }

    AVSfield_set_labels(*outf,"alpha:red:green:blue",":");

    if (fread((char *)((*outf)->data),width*height*4,1,f) != 1)
    {
	AVSwarning(" Error reading input image. ");
	return(0);
    }

    fclose(f);
    
    /* now remove the temp file */

    sprintf(command,"%s %s\n",rm_command,fn);
    system(command);
    status = (status & 0xff00) >> 8;
    if (status)
	perror();
    
    return(1);
}

write_compressed_avs_image()
{
    int write_comp(),p;
    
    AVSset_module_name("write compressed image",MODULE_RENDER);
    AVScreate_input_port("input float image","field 2D 4-vector byte",REQUIRED);
    p = AVSadd_parameter("Output File","string","","");
    AVSconnect_widget(p,"browser");
    AVSset_compute_proc(write_comp);
}

write_comp(inf,out_fname)
AVSfield_float *inf;
char *out_fname;
{
    char command[128];
    int width,height,status;
    FILE *f;

    if ((out_fname == NULL) || (*out_fname == '\0'))
	return(0);

    /**
      * unlike the read compressed image module, the write compressed
      * module does not make use of any temporary files.  the file
      * is just written to the named user file in avs image format,
      * then compressed in-situ.  the resultant filename will be
      * whatever the user specified with a .Z appended (by compress).
    **/

    f = fopen(out_fname,"w");
    if (f == NULL)
    {
	AVSwarning(" Unable to open output image file. \n");
	return(0);
    }

    AVSmodule_status("writing image",0); /* this is informative only */
    
    width = inf->dimensions[0];
    height = inf->dimensions[1];

    fwrite((char *)&width,4,1,f);
    fwrite((char *)&height,4,1,f);

    if (fwrite((char *)inf->data,width*height*4,1,f) != 1)
    {
	AVSwarning(" Error writing temporary output file.\n");
	return(0);
    }

    fclose(f);
    
    /* done writing the image, now compress it. */
    
    AVSmodule_status("compressing..",0);  /* this is informative only */
    sprintf(command,"%s %s\n",compress_command,out_fname);
    status = system(command);
    status = (status & 0xff00) >> 8;
    if (status)
    {
	AVSfatal(" System call failed.");
	perror("image_io (write .Z image)");
    }

    return(1);
}
