/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* -*-C-*-
*******************************************************************************
*
* File:         vol.c
* RCS:          $Header: vol.c,v 1.1 92/03/03 11:12:12 hstroyan Exp $
* Description:  CRX24 Volume rendering module for AVS
* Author:       Howard Stroyan
* Created:      
* Modified:     
* Language:     C
* Package:      N/A
* Status:       Experimental (Do Not Distribute)
*
* (C) Copyright 1992, Hewlett-Packard, all rights reserved.
*
*******************************************************************************
*/

#include <stdio.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/times.h>
#include <sys/sem.h>
#include <starbase.c.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>
#include <Xg/Starbase.h>
#include <avs/flow.h>
#include <avs/avs.h>
#include <avs/field.h>
#include <avs/colormap.h>

int gfd;
key_t sema_key;
int sema_id;
ushort semarray[1];
struct sembuf sops[4];
unsigned char *data;
unsigned int lut[256];

int remote_volume_init();

unsigned int num_points_per_line;
unsigned int num_lines_per_slice;
unsigned int num_slices;

int redraw = 0;

remote_volume()
{
    int x_scale, y_scale, z_scale;
    int x_size, y_size;
    int auto_fill, text;
    
    /* Set module name */
    AVSset_module_name("remote volume", MODULE_RENDER);
    
    /* Create input ports */
    AVScreate_input_port("volume_data", "field 3D scalar byte", REQUIRED);
    AVScreate_input_port("mycolormap", "colormap", REQUIRED);
    AVScreate_input_port("xform", "field 2D scalar float", REQUIRED);
    
    /* Create output port */
    AVScreate_output_port("Field Output", "field 2D 4-vector 2-space byte");

    /* Create parameters */
    auto_fill = AVSadd_parameter("Auto Fill", "boolean", 0, 0, 1);

    text = AVSadd_parameter("Performance Status", "string_block", " ", " ", " ");
    AVSconnect_widget(text, "textblock");
    AVSadd_parameter_prop(text, "width", "integer", 4);

    x_scale = AVSadd_float_parameter("X Scale", 1.0, 0.0, 4.0);
    y_scale = AVSadd_float_parameter("Y Scale", 1.0, 0.0, 4.0);
    z_scale = AVSadd_float_parameter("Z Scale", 1.0, 0.0, 4.0);
    x_size  = AVSadd_parameter("Width",  "integer", 512, 2, 1280);
    y_size  = AVSadd_parameter("Height", "integer", 512, 2, 1024);
    
    AVSconnect_widget(auto_fill, "toggle");

    AVSconnect_widget(x_size, "typein_integer");
    AVSconnect_widget(y_size, "typein_integer");
    AVSconnect_widget(x_scale, "dial");
    AVSconnect_widget(y_scale, "dial");
    AVSconnect_widget(z_scale, "dial");
}

void resize(widget, client_data, call_data)
Widget    widget;
caddr_t   client_data;
XmDrawingAreaCallbackStruct *call_data;
{
    if (gfd) vdc_extent(gfd, -1.0,-1.0,-1.0,1.0,1.0,1.0);
}

/***************************************************************************
 *  remote_volume_compute *
 ***************************************************************************/

main(argc,argv)
int     argc;
char    *argv[];
{
    float *hue, *sat, *lum, *alpha;
    int a;
    float x_start, x_end;
    float y_start, y_end;
    float z_start, z_end;

    gescape_arg arg1, arg2;

    AVSfield_char *data_field;
    AVScolormap  *cmap;
    AVSfield_float *transform;
    int auto_fill;
    char *text;
    char message[256];
    float *x_scale, *y_scale, *z_scale;
    int x_size, y_size;
    float max_dim;

    XtAppContext app_context; /* application context */
    Widget toplevel, sb;
    Arg arg[15];
    int n;
    int mask;
    XWindowChanges changes;

    struct tms start_buffer, end_buffer;
    unsigned int total_num_points;
    long start_ticks, end_ticks;
    float total_time;
    int dims[2];
    unsigned char *pixel_data;
    AVSfield_char *image;

    static String fallbacks[] = {
				"*Starbase*width: 512",
				"*Starbase*height: 512",
				 NULL
			 };


    if (getenv("COMPUTE_SERVER")) putenv(strncat("DISPLAY=",getenv("COMPUTE_SERVER"),255));

    AVScorout_init(argc,argv,remote_volume);
    AVScorout_set_sync(1);

    toplevel = XtAppInitialize(&app_context, "DRawingArea", NULL, 0,
	&argc, argv, fallbacks, NULL, 0);

    n = 0;
    XtSetArg(arg[n], XgNshadeMode, XgCMAP_FULL); n++;
    sb = XtCreateManagedWidget("Starbase", xgStarbaseWidgetClass,
	toplevel, arg, n);

    /* setup semaphore locking */
    sema_key = ftok("/.compute_server_lock", 0);
    if ((sema_id = semget(sema_key, 1, IPC_CREAT | IPC_EXCL | 0666)) == -1)
	sema_id = semget(sema_key, 1, 0);
    else 
	semctl(sema_id, 0, SETVAL, 1);

    sops[0].sem_num = 0;
    sops[0].sem_op  = -1;      /* P (get) */
    sops[0].sem_flg = SEM_UNDO;
    semop(sema_id, sops, 1);

    XtAddCallback(sb, XmNresizeCallback, resize, NULL);

    XtRealizeWidget(toplevel);

    x_size = y_size = 512;

    changes.x = 0;
    changes.y = 0;
    XConfigureWindow(XtDisplay(toplevel),XtWindow(toplevel), CWX|CWY, &changes);

    /* Set dimensions */
    dims[0] = x_size;
    dims[1] = y_size;

    /* Allocate space for image data */
    image = (AVSfield_char *)AVSdata_alloc("field 2D 4-vector 2-space byte", dims); 
    pixel_data = malloc((x_size)*(y_size));

    AVScorout_output(image);

    {
	Arg arg[10];
	int n;

	/* Find the Starbase file descriptor. */
	n = 0;
	XtSetArg(arg[n], XgNfildes, &gfd); n++;
	XtGetValues(sb, arg, n);
    }

    remote_volume_init();

    sops[0].sem_op  = 1;      /* V (release) */
    semop(sema_id, sops, 1);

    while(1) {
	XtInputMask local_mask;

    	mask = COROUT_WAIT;
	AVScorout_X_wait(XtDisplay(toplevel),NULL, &mask);

	if (local_mask = XtAppPending(app_context))
	{
	    XtAppProcessEvent(app_context, local_mask);
	} 

	AVScorout_input( &data_field, &cmap, &transform, &auto_fill, &text,
			&x_scale, &y_scale, &z_scale, &x_size, &y_size);

	/* TRANSFER AVS COLORMAP TO GESCAPE FORMAT */
	if (AVSinput_changed("mycolormap", 0) != 0)
	{
    	    redraw = TRUE;
	    hue = cmap->hue;
	    sat = cmap->saturation;
	    lum = cmap->value;
	    alpha = cmap->alpha;

	    for (a = 0 ; a < cmap->size ; a++)
	    {
		float red, green, blue;
		hsl_to_rgb(*hue++,*sat++,*lum++,&red,&green,&blue);

		lut[a] =
		     (((int)(255.0 * (*alpha++)) << 24) |	/* alpha */
			((int)(255.0 * red) << 16) |	/* red */
		       ((int)(255.0 * green) << 8) |	/* red */
			(int)(255.0 * blue)); 	/* blue */
	    }
	}

	/* TRANSFER DATA FIELD TO GESCAPE FORMAT */
	if (AVSinput_changed("volume_data", 0) != 0)
	{
    	    redraw = TRUE;
	    data = data_field->data;
	    num_points_per_line    =    data_field->dimensions[0];
	    num_lines_per_slice    =    data_field->dimensions[1];
	    num_slices             =    data_field->dimensions[2];

	    max_dim = num_points_per_line;
	    if (num_lines_per_slice > max_dim) max_dim = num_lines_per_slice;
	    if (num_slices > max_dim) max_dim = num_slices;
	    max_dim = 1.0 / (float)max_dim;

	    total_num_points = num_points_per_line * num_lines_per_slice * num_slices;
	}
	/* LOAD NEW VIEWING TRANSFORMATION TO STARBASE */
	if (AVSinput_changed("xform", 0) != 0)
	{
    	   static float invert_z[4][4] =   {{ 1.0, 0.0, 0.0, 0.0},
					    { 0.0, 1.0, 0.0, 0.0},
					    { 0.0, 0.0,-1.0, 0.0},
					    { 0.0, 0.0, 0.0, 1.0}};

    	    redraw = TRUE;
	    replace_matrix3d(gfd, transform->data);
	    concat_transformation3d(gfd, invert_z, POST, REPLACE);
	}

	/* RESIZE RENDERING REGION */
	if ((AVSparameter_changed("Height", 0) != 0) ||
	    (AVSparameter_changed("Width", 0) != 0))
	{
	    if (image)
		AVSfield_free(image);

	    if (pixel_data)

/* IAC CODE CHANGE : 		free(pixel_data); */
		 free(pixel_data);

	    /* Set dimensions */
	    dims[0] = x_size;
	    dims[1] = y_size;

	    /* Allocate space for image data */
	    image = (AVSfield_char *)AVSdata_alloc("field 2D 4-vector 2-space byte", dims); 
	    pixel_data = malloc((x_size)*(y_size));

	    changes.x = 0;
	    changes.y = 0;
	    changes.width = x_size;
	    changes.height = y_size;
	    XConfigureWindow(XtDisplay(toplevel),XtWindow(toplevel), CWWidth|CWHeight|CWX|CWY, &changes);

    	    redraw = TRUE;
	}

	if ((AVSparameter_changed("Auto Fill") != 0) |
	    (AVSparameter_changed("X Scale") != 0) |
	    (AVSparameter_changed("Y Scale") != 0) |
	    (AVSparameter_changed("Z Scale") != 0)) 
    	    redraw = TRUE;
	if (redraw)
	{
	    x_start = (float)-0.8 * *x_scale * (float)num_points_per_line * max_dim;
	    y_start = (float)-0.8 * *y_scale * (float)num_lines_per_slice * max_dim;
	    z_start = (float)-0.8 * *z_scale * (float)num_slices * max_dim;
	    x_end   =  (float)0.8 * *x_scale * (float)num_points_per_line * max_dim;
	    y_end   =  (float)0.8 * *y_scale * (float)num_lines_per_slice * max_dim;
	    z_end   =  (float)0.8 * *z_scale * (float)num_slices * max_dim;

	    arg1.f[0] = x_start;	/* START OF FIRST SCANLINE, IN THE FIRST SLICE */
	    arg1.f[1] = y_start;
	    arg1.f[2] = z_start;

	    arg1.f[3] = x_end;		/* END OF FIRST SCANLINE, IN THE FIRST SLICE */
	    arg1.f[4] = y_start;
	    arg1.f[5] = z_start;

	    arg1.f[6]  = x_start;	/* START OF LAST SCANLINE, IN THE FIRST SLICE */
	    arg1.f[7]  = y_end;
	    arg1.f[8]  = z_start;

	    arg1.f[9]  = x_start;	/* START OF FIRST SCANLINE, IN THE LAST SLICE */
	    arg1.f[10] = y_start;
	    arg1.f[11] = z_end;

	    arg1.i[12] = num_points_per_line;
	    arg1.i[13] = num_lines_per_slice; /* not a very accurate description */
	    arg1.i[14] = num_slices;
	    arg1.i[15] = 0;
	    arg1.i[16] = 0;
	    arg1.i[17] = 0;
	    arg1.i[18] = INDIRECT_DATA;
	    if (auto_fill) arg1.i[18] |= AUTO_FILL_VOXEL;
	    arg1.i[19] = data;
	    arg1.i[20] = (int) &lut[0];

	    /* get exclusive lock of the compute server */
	    sops[0].sem_op  = -1;      /* P (get) */
	    semop(sema_id, sops, 1);

	    /* raise the window */
	    XRaiseWindow(XtDisplay(toplevel),XtWindow(toplevel));
	    XSync(XtDisplay(toplevel),0);
	    XSync(XtDisplay(toplevel),0);

	    clear_view_surface(gfd);

	    start_ticks = times(&start_buffer);

	    gescape (gfd, CUBIC_POLYPOINT, &arg1, &arg2);

	    end_ticks = times(&end_buffer);
	    total_time = (float) (end_ticks - start_ticks) / (float) HZ;

	    sprintf(message, "Performance Statistics\n  %d voxels rendered\n  %6.3f seconds rendering time\n  %6.3f Million Voxels/second",total_num_points,total_time,total_num_points / total_time / 1e6);
	    AVSmodify_parameter("Performance Status",AVS_VALUE, message," "," ");

	    redraw = 0;

	    { /* output the new image */
		int bank, i;
		unsigned char *image_ptr, *pixel_ptr;

		for (bank = 0; bank < 3; bank++)
		{
		    bank_switch(gfd, bank, 0);
		    dcblock_read(gfd, 0, 0, x_size, y_size, pixel_data, 0);
		    image_ptr = image->data - bank + 3;
		    pixel_ptr = pixel_data;
		    for (i = 0; i < (x_size*y_size); i++)
		    {
			    *image_ptr = *pixel_ptr++;
			    image_ptr += 4;
		    }
		}
		AVScorout_output(image);
	    }
	    /* unlock */
	    sops[0].sem_op  = 1;      /* V (release) */
	    semop(sema_id, sops, 1);

	}

	AVSmodule_status("done",100);
    }
}

int remote_volume_init()
{
    float empty_matrix[4][4];

    shade_mode(gfd, INIT | CMAP_FULL, 0);
    depth_indicator(gfd, 0, 0);
    clip_indicator(gfd, CLIP_OFF);
    hidden_surface(gfd, 0, 0);
    push_matrix3d(gfd, empty_matrix);
    vdc_extent(gfd, -1.0,-1.0,-1.0,1.0,1.0,1.0);
}

hsl_to_rgb(hue,saturation,luminosity,red,green,blue)
float hue, saturation, luminosity;
float *red, *green, *blue;
{
        float   frac, lx, ly, lz;

        hue = 6 * hue;
        frac = hue - (int) hue;
        lx = luminosity * (1 - saturation);
        ly = luminosity * (1 - saturation * frac);
        lz = luminosity * (1 - saturation * (1-frac));
        switch ((int) hue) {
                case 0: case 6:
                        *red = luminosity; *green = lz; *blue = lx; break;
                case 1:
                        *red = ly; *green = luminosity; *blue = lx; break;
                case 2:
                        *red = lx; *green = luminosity; *blue = lz; break;
                case 3:
                        *red = lx; *green = ly; *blue = luminosity; break;
                case 4:
                        *red = lz; *green = lx; *blue = luminosity; break;
                case 5:
                        *red = luminosity; *green = lx; *blue = ly; break;
        }
}

