/*****************************************************************************

                    INTERNATIONAL AVS CENTER
        (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.


*****************************************************************************/
/*									    */
/*	Module : Sphere					                    */
/*	Author : Beth Hess under the supervision of Dr. Susanna Wei         */
/*	         St. Joseph's University				    */
/*									    */
/****************************************************************************/

/****************************************/
/* Header file				*/
/****************************************/

#include <avs/avs.h>
#include <avs/geom.h>
#include <avs/port.h>

/****************************************/
/* Define constants 			*/
/****************************************/

#define MAXSPH 	       21			/* max number of spheres */
#define NUM_SPHERE	1			/* one sphere */
static char version[] = "%W% %E%";		/* module version string */

/****************************************/
/* Define sphere coordinate structure	*/
/****************************************/

struct balls {
   float x, y, z ;
} ball[MAXSPH];

/****************************************/
/* Define color structure		*/
/****************************************/ 

struct colors {
    float red, green, blue ;
} sphere_color ;

/****************************************/
/* Define color array 			*/
/****************************************/

int color[MAXSPH];

/****************************************/
/* Define radius array 			*/
/****************************************/

float rad[MAXSPH];

/****************************************/
/* Initialize module description        */
/****************************************/

AVSinit_modules()
{
	int sphere_desc();

	AVSmodule_from_desc(sphere_desc);
}

/****************************************************************************/
/* Module Description							    */
/*									    */
/* Define the module name, output port, and module parameters.		    */
/* Declare the initialization and computation functions.		    */
/****************************************************************************/

int sphere_desc() 
{
	int in_port, out_port;
	int sphere_compute(), param ;
	int sphere_init();
 
	/* module name and type */
	AVSset_module_name("sphere", MODULE_DATA) ;
  
	/* Output port name and type */
	out_port = AVScreate_output_port("output", "geom") ;
 
	/* Parameter Specifications */

	/* file browser */
	param = AVSadd_parameter("data_file", "string", "", "", " ");
	AVSconnect_widget(param, "browser");

	/* read or write choice button */
	param = AVSadd_parameter("read_write", "choice", "write","read write", " ");
	AVSconnect_widget(param, "radio_buttons");

	/* number of current sphere */
	param = AVSadd_parameter("sphere", "integer", 20,0,21);
	AVSconnect_widget(param, "typein_integer");

	/* color toggle */
	param = AVSadd_parameter("color_on", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	/* x coordinate */
	param = AVSadd_float_parameter("x", 0.0, -50.0, 50.0) ;
	AVSconnect_widget(param, "typein_real") ; 

	/* y coordinate */
	param = AVSadd_float_parameter("y", 0.0, -50.0, 50.0) ;
	AVSconnect_widget(param, "typein_real") ; 

	/* z coordinate */
	param = AVSadd_float_parameter("z", 0.0, -50.0, 50.0) ;
	AVSconnect_widget(param, "typein_real") ;

	/* sphere radius */
	param = AVSadd_float_parameter("radius", 0.0, 0.0, 10.0) ;
	AVSconnect_widget(param, "typein_real") ;

	/* declare the initialization function */
	AVSset_init_proc(sphere_init);

	/* declare the computation function */
  	AVSset_compute_proc(sphere_compute) ;

} /* End Module Description */


/*******************************/
/* Module Initialization       */
/*******************************/

sphere_init() {		/* Set sphere color, coordinates and radius to zero */
	int i;
	for (i=0; i<MAXSPH; i++) {
		color[i] = 0;
		ball[i].x = ball[i].y = ball[i].z = 0.0;
		rad[i] = 0.0;
	}
}

/****************************************************************************/
/* Computation Function 					       	    */
/*									    */
/* This function will read parameter values from a data file or accept them */
/* from the network editor control panel.  It will create the spheres as    */
/* separate objects.                                                        */
/****************************************************************************/

int sphere_compute(output, data_file, read_write, sphere, color_on,
			 x, y, z, 
  			  radius) 

GEOMedit_list *output ;
float *x, *y, *z, *radius ;	
char *data_file, *read_write;
int color_on;
int sphere;

{                          
	char objname[MAXSPH][20];      
   	GEOMobj *sphere_obj[MAXSPH] ;  
	FILE *fptr;
	char *message;
	int i;


	/* select a new data file */
	if (AVSparameter_changed("data_file",0)) {
		if(!strcmp(read_write, "read")) {
		/* attempt to read the data file */
			if ((fptr = fopen(data_file, "r")) == NULL) {
				/* no read permission */
				AVSwarning("spheres: Error opening file %s",data_file);
	
				return(1);
			}
	
			sphere = 0;
		/* read the data file */
			while ((! feof(fptr)) && (sphere < MAXSPH)) {
				fscanf(fptr,"%f %f %f %f \n", &(ball[sphere].x), &(ball[sphere].y),
				&(ball[sphere].z), &(rad[sphere]));
			/* set color to off */
				color[sphere] = 0;
				sphere++;
			}

/* modify parameter values */
	AVSmodify_parameter("color_on",AVS_VALUE,color[sphere],0,0);
	AVSmodify_float_parameter("x",AVS_VALUE,ball[sphere].x,0,0);
	AVSmodify_float_parameter("y",AVS_VALUE,ball[sphere].y,0,0);
	AVSmodify_float_parameter("z",AVS_VALUE,ball[sphere].z,0,0);
	AVSmodify_float_parameter("radius",AVS_VALUE,rad[sphere],0,0);
}
	else {
/* attempt to write data file */
	if(fptr = fopen(data_file,"r")) {
	/* file already exists */
		fclose(fptr);
	/* warning : cancel or overwrite the existing file */
		message = AVSmessage(version, AVS_Warning, NULL,
			"Module Generator", "Cancel!Overwrite",
			"Overwrite File %s? \n",data_file);
		if (!strcmp(message, "Cancel")) {
		/* cancel the write to file */
			AVSmodify_parameter("data_file", AVS_VALUE,
				NULL,NULL,NULL);
			return(0);
		}
	}
	if((fptr = fopen(data_file, "w")) == NULL) {
	/* no write permission */
		AVSwarning("spheres: Error opening file %s",data_file);
		return(1);
	}
/* write the data file */
	for (i=0; i<MAXSPH; i++) {
		if (rad[i] > 0.0 || ball[i].x != 0.0)
			fprintf(fptr, "%f %f %f %f\n", ball[i].x,
				ball[i].y,ball[i].z, rad[i]);
	}
	}
	fclose(fptr);
}

if (AVSparameter_changed("sphere",0)) {
	color[sphere] = 0;
	AVSmodify_parameter("color_on",AVS_VALUE,color[sphere],0,0);
	AVSmodify_float_parameter("x",AVS_VALUE,ball[sphere].x, 0, 0);
	AVSmodify_float_parameter("y",AVS_VALUE, ball[sphere].y, 0, 0);
	AVSmodify_float_parameter("z",AVS_VALUE, ball[sphere].z, 0, 0);
	AVSmodify_float_parameter("radius",AVS_VALUE, rad[sphere], 0, 0);
}

/* set up the current sphere */
	color[sphere] = color_on;
	ball[sphere].x = *x;
	ball[sphere].y = *y;
	ball[sphere].z = *z;
	rad[sphere] = *radius;


/* the color of the sphere */
	sphere_color.red   = 0.0;
	sphere_color.green = 1.0 ;
	sphere_color.blue  = 0.0 ;


/* create the geometries */
for (i = 0; i<MAXSPH; i++) {

	if (rad[i] > 0.0 || ball[i].x != 0.0) {
	/* name the current sphere */
		sprintf(objname[i],"sphere%i\0",i);
		sphere_obj[i] = GEOMcreate_sphere(GEOM_NULL,
					&ball[i],
	   			       &rad[i],
				       GEOM_NULL,
	    			       GEOM_NULL,
				       NUM_SPHERE,
				       GEOM_COPY_DATA); 

	if (color[i]) 
	/* color the sphere */
		GEOMadd_float_colors(sphere_obj[i],
				&sphere_color,
			     	NUM_SPHERE,
			     	GEOM_COPY_DATA) ;

   if (i == 0)
/* initialize the edit list */
	*output = GEOMinit_edit_list(*output);

/* add the current sphere to the edit list */
	GEOMedit_geometry(*output, objname[i], sphere_obj[i]);

/* deallocate the memory associated with the object */
	GEOMdestroy_obj(sphere_obj[i]);  
  
}
}
      	return(1);  

} /* End of the Computation Function */
