/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

AUTHOR : Stardent Computer, Inc.
******************************************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <avs_math.h>
#include <avs/flow.h>
#include <avs/field.h>

int
fcomp(a,b)
float	a;
float	b;
{
    if(a>b)      return 1;
    else if(a<b) return -1;
    else	 return 0;
}

stats_body(input)
AVSfield_float	*input;
{   int size = AVSfield_prod(input->ndim, input->dimensions) * input->veclen;
    int         i;
    float	mean,adeviation,sdeviation,variance,skewness,kurtosis,min,max;

    compute_stats(input->data,size,
		   &mean,
		   &adeviation,
		   &sdeviation,
		   &variance,
		   &skewness,
		   &kurtosis,
		   &min, 
		   &max);

    qsort(input->data,size,sizeof(float),fcomp);

    printf("Field Statistics\n");
    printf("===================\n");
    printf("Dimensions:         ");
    for(i=0; i< input->ndim; i++)
      printf("%d ", input->dimensions[i]);
    if (input->veclen > 1)
      printf("(x%d)\n", input->veclen);
    else 
      printf("\n");
    printf("Min/Max:            %f %f\n", min, max);
    printf("Mean:               %f\n",mean);
    printf("Median:             %f\n",input->data[size/2]);
/*
    printf("Average Deviation:  %f\n",adeviation);
*/
    printf("Standard Deviation: %f\n",sdeviation);
    printf("Skewness:           %f\n",skewness);
    printf("Kurtosis:           %f\n",kurtosis);
    printf("\n");
}


/**** Specifications ****/
stats_spec()
{
    AVSset_module_name("statistics", MODULE_RENDER);
    AVScreate_input_port("Field", "field float", REQUIRED);
    AVSset_compute_proc(stats_body);
}

int ((*module_list[])()) = { stats_spec };

AVSinit_modules()
{
	AVSinit_from_module_list(module_list, sizeof(module_list)/sizeof(module_list[0]));
}

/**** Utilities ****/
compute_stats(data,n,ave,adev,sdev,svar,skew,curt,min,max)
float	data[];
int	n;
float	*ave;
float	*adev;
float	*sdev;
float	*svar;
float	*skew;
float	*curt;
float   *min, *max;
{   int	i;
    float	s, p;

    if(n<=1)
      return;

    s = 0.0;
    *min = *max = data[0];
    for(i=0;i<n;i++) {
      s += data[i];
      if (data[i] < *min) 
	*min = data[i];
      else if (data[i] > *max)
	*max = data[i];
    }
    *ave = s/(float)n;
    *adev = (*svar) = (*skew) = (*curt) = 0.0;
    for(i=0;i<n;i++)
    {   *adev += fabs(s=data[i]-(*ave));
	*svar += (p = s*s);
	*skew += (p *= s);
	*curt += (p *= s);
    }
    *adev /= (float)n;
    *svar /= (float)(n-1);
    *sdev  = sqrt(*svar);
    if(*svar != 0.0)
    {   *skew /= (float)n*(*svar)*(*sdev);
	*curt  = (*curt)/((float)n*(*svar)*(*svar)) - 3.0;
    }
}	

float
gammln(xx)
float	xx;
{   int		j;
    double	x, tmp, ser;
    static double	cof[] = 
    {
	 76.18009173,
	-86.50532033,
	 24.01409822,
	 -1.231739516,
	  0.120858003e-2,
	 -0.536382e-5
       };

    x = xx-1.0;
    tmp = x+5.5;
    tmp -= (x+0.5)*log(tmp);
    ser = 1.0;
    for(j=0;j<=5;j++)
    {   x += 1.0;
	ser += cof[j]/x;
    }

    return -tmp+log(2.50662827465*ser);
}

#define ITMAX 100
#define EPS 3.0e-7

void
gser(gamser,a,x,gln)
float	*gamser;
float	a;
float	x;
float	*gln;
{
    int	n;
    float	sum, del, ap;
    
    *gln = gammln(a);
    if(x <= 0.0)
    {   if(x < 0.0)
	  fprintf(stderr,"Bad arg in gser\n");
	*gamser = 0.0;
	return;
    }
    else
    {   ap = a;
	del = sum = 1.0/a;
	for(n=1;n<=ITMAX;n++)
	{
	    ap += 1.0;
	    del *= x/ap;
	    sum += del;
	    if(fabs(del) < fabs(sum)*EPS)
	    {   *gamser = sum*exp(-x+a*log(x)-(*gln));
		return;
	    }
	}
	fprintf(stderr,"a too large in gser\n");
	*gamser = 0.0;
	return;
    }
}

void
gcf(gammcf,a,x,gln)
float	*gammcf;
float	a;
float	x;
float	*gln;
{   int	n;
    float	gold = 1.0;
    float	g;
    float	fac = 1.0;
    float	b1 = 1.0;
    float	b0 = 0.0;
    float	anf;
    float	ana;
    float 	an;
    float	a1;
    float	a0 = 1.0;

    *gln = gammln(a);
    a1 = x;
    for(n=1;n<=ITMAX;n++)
    {   an = (float)n;
	ana = an-a;
	a0 = (a1+a0*ana)*fac;
	b0 = (b1+b0*ana)*fac;
	anf = an*fac;
	a1 = x*a0+anf*a1;
	b1 = x*b0+anf*b1;
	if(a1 != 0.0)
	{   fac = 1.0/a1;
	    g = b1*fac;
	    if(fabs((g-gold)/g) < EPS)
	    {   *gammcf = exp(-x+a*log(x)-(*gln))*g;
		return;
	    }
	    gold = g;
	}
    }
    fprintf(stderr,"a too large in gcf\n");
}

float
gammq(a,x)
float	a;
float	x;
{   float	gamser, gammcf, gln;

    if(x < 0.0 || a<= 0.0)
    {   fprintf(stderr,"Bad args in gammq\n");
	return 0.0;
    }
    if(x < (a+1.0))
    {   gser(&gamser,a,x,&gln);
	return 1.0 - gamser;
    }
    else
    {   gcf(&gammcf,a,x,&gln);
	return gammcf;
    }
}
