/*************************************************************************/
/*                                                                       */
/*  Header ID:       my_std.h                                            */
/*                                                                       */
/*  Description:     Standard typedefs and defines                       */
/*                                                                       */
/*************************************************************************/
/*                        MODIFICATION LOG                               */
/*                                                                       */
/*     DATE          AUTHOR                  DESCRIPTION                 */
/*   --------   ------------------  ---------------------------------    */
/*   04/06/95   Anonymous g69d      Exported Release                     */
/*                                                                       */
/*************************************************************************/

/* Standard Typedefs */
typedef int bool;

/* Standard Defines */
#ifndef MY_STD
#ifndef TRUE
#define TRUE        ( 1 )
#endif
#ifndef FALSE
#define FALSE       ( 0 )
#endif
#define READ_MODE   ( "r" )
#define WRITE_MODE  ( "w" )
#define MOD_SUCCESS ( 1 )
#define MOD_FAILURE ( 0 )
#define MOD_FAIL    ( 0 )

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS ( 1 )
#define EXIT_FAILURE ( 0 )
#endif
#define EXIT_FAIL    ( 0 )

#ifndef EPSILON
#define EPSILON     ( 0.00001 )
#endif

#ifndef IS_NEAR_ZERO 
#define IS_NEAR_ZERO(a) ( ( a ) < (EPSILON) && ( a ) > (-EPSILON) )
#endif

#define MIN(a,b) (((a) < (b)) ? (a) : (b))
#define MAX(a,b) (((a) > (b)) ? (a) : (b))
#define MIDDLE(a,b,c) ( ( (a)>(b) ) ? \
		        ( ( (b)>(c) ) ? (b) : ( (c)>(a) ) ? (a) : (c) ) : \
                        ( ( (a)>(c) ) ? (a) : ( (c)>(b) ) ? (b) : (c) )   \
                      )

#define MY_STD     ( 1 )
#endif

