/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*      This software is copyright (C) 1994 Regents  of  the
University  of  California.   Anyone may reproduce unixcom.c
the software in this distribution, in whole or in part, pro-
vided that:
 
(1)  Any copy  or  redistribution  of  unixcom.c must  show  the
     Regents  of  the  University of California, through University of 
     California, Los Angeles, Department of Pharmacology, as the source,
     and  must include this notice;
 
(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.
 
 
unixcom.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
unixcom.c, or any part thereof.     
 
Author:
        Andy Jacobson
        UCLA Dept. Pharmacology / Crump Institute
        Los Angeles, CA 90024-6948
        afj@DrMemory.nuc.ucla.edu

*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>

/*  Module Description                     */

int unix_com_desc()
{

	int in_port,param,p;
	extern int unix_com_compute();

	AVSset_module_name("unix command", MODULE_RENDER);

        in_port = AVScreate_input_port("Number","integer", OPTIONAL);

	/* Parameter Specifications                */
	param = AVSadd_parameter("command", "string", "", "", "");
	AVSconnect_widget(param, "typein");
	param = AVSadd_parameter("begin arg", "string", "", "", "");
	AVSconnect_widget(param, "typein");
        param = AVSadd_parameter("arg integer length","integer",4,1,10);
	AVSconnect_widget(param, "typein_integer");
	p = AVSadd_parameter("end arg", "string", "", "", "");
	AVSconnect_widget(p, "typein");
        AVSadd_parameter_prop(p, "width","integer",4);
	param = AVSadd_parameter("shell command", "string", "output command line:", "", "");
        AVSconnect_widget(param, "text");
        AVSadd_parameter_prop(param, "width","integer",4);
	param = AVSadd_parameter("output command", "string", "", "", "");
        AVSconnect_widget(param, "text");
        AVSadd_parameter_prop(param, "width","integer",4);
	param = AVSadd_parameter("run/stop","boolean",0,0,1);
	param = AVSadd_parameter("oneshot","oneshot",0,0,1);
        AVSset_compute_proc(unix_com_compute);
	return(1);
}
 

/* Module Compute Routine                  */

unix_com_compute(num,cmd, opt, precis, opt2, title,cmdline,go,go2)
	int num;
        char *cmd, *opt;
        int precis;
	char *opt2;
	char *title, *cmdline;
	int go,go2;
{
        int status;
	
	char command[512];
        char digits[32];
        char numpart[32];

     /* Build up command line if initial command exists */
     if ((cmd == NULL) || (*cmd == '\0')) return (0);
     else
     {
	sprintf(command,"%s ",cmd);
	if ((opt != NULL) && (*opt != '\0')) strcat(command,opt);
      	if (num != '\0')
	{
	  sprintf(digits,"%%.0%dd",precis);
	  sprintf(numpart,digits,num);
	  strcat(command,numpart);
	}
        if ((opt2 != NULL) && (*opt2 != '\0')) strcat(command,opt2);
	AVSmodify_parameter("output command",AVS_VALUE,command," "," ");


     /* Run it if we're supposed to */
	
	if ((go == 0) && (go2 == 0)) return(1);
	else
	{
	  status = system(command);
	  status = (status & 0xff00) >> 8;
	  if (status)
	  {
	    AVSfatal(" System call failed.");
	    perror("unable to perform shell command");
	  }
	  return(1);
	}
      }
}
 
 
 
/* Initialization for module               */

int ((*mod_list[])()) = {
	unix_com_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}

