C                  INTERNATIONAL AVS CENTER
C        (This disclaimer must remain at the top of all files)
C
C WARRANTY DISCLAIMER
C
C This module and the files associated with it are distributed free of charge.
C It is placed in the public domain and permission is granted for anyone to use,
C duplicate, modify, and redistribute it unless otherwise noted.  Some modules
C may be copyrighted.  You agree to abide by the conditions also included in
C the AVS Licensing Agreement, version 1.0, located in the main module
C directory located at the International AVS Center ftp site and to include
C the AVS Licensing Agreement when you distribute any files downloaded from
C that site.
C
C The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module provide absolutely
C NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
C the quality and performance of this software is with the user.  IN NO EVENT
C WILL The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module BE LIABLE TO
C ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
C WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
C SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.
C
C This AVS module and associated files are public domain software unless
C otherwise noted.  Permission is hereby granted to do whatever you like with
C it, subject to the conditions that may exist in copyrighted materials. Should
C you wish to make a contribution toward the improvement, modification, or
C general performance of this module, please send us your comments:  why you
C liked or disliked it, how you use it, and most important, how it helps your
C work. We will receive your comments at avs@ncsc.org.
C
C Please send AVS module bug reports to avs@ncsc.org.
C
c ====================================================================== 
c
c Created by: Ian Curington, Stardent Computer Limited
c Modified:   18 January 90 ianc: modification of avsplot
c
c ====================================================================== 
C === avs module initialization, connection prototypes
      subroutine AVSinit_modules
      integer  iport
      integer  volstat_compute
      external volstat_compute
      external AVScreate_input_port
      integer  AVScreate_input_port
      integer iparam

C Set the module name and type
      call AVSset_module_name('volume statistics', 'renderer')

C Create an input port for the required field input
      iport = AVScreate_input_port('input field',
     $     'field 3D scalar uniform float', REQUIRED)

C Tell AVS what function to call to do the compute
      call AVSset_compute_proc(volstat_compute)
      
      return
      end

C === avs compute module, process incomming data

      integer function volstat_compute(f,nx,ny,nz)
      integer nx, ny, nz
      integer*2 ix, iy, iz
      real  f(nx, ny, nz)
      real  min, max, mean, size

c === initialize temp variables
      size = nx*ny*nz
      ix = nx
      iy = ny
      iz = nz
      min  = f(1,1,1)
      max  = f(1,1,1)
      mean = 0.0

c === gather statistics
      do k=1,nz
        do j=1,ny
          do i=1,nx
            mean = mean + f(i,j,k)
            if ( min .gt. f(i,j,k)) min = f(i,j,k)
            if ( max .lt. f(i,j,k)) max = f(i,j,k)
          enddo
        enddo
      enddo
      mean = mean / size

      write (*,*) ' ============= volume statistics ============ '
      write (*,*) ' === Dimensions:    ',ix,iy,iz
      write (*,*) ' === Total Size:    ',nx*ny*nz
      write (*,*) ' === Field Minimum: ',min
      write (*,*) ' === Field Maximum: ',max
      write (*,*) ' === Field Mean:    ',mean
      write (*,*) ' ============================================ '

C When we're done, we return 1 to indicate success
      volstat_compute = 1
      return
      end
