/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/******************************************************************************
*									      *
*			 NRL/RCD Visualization Lab			      *
*									      *
* Source code and documentation developed at NRL/RCD Visualization Lab        *
* are in the public domain. Hence, no limitation exists on the right to use,  *
* publish, or resale the source code and documentation.                       *
*      									      *
* We ask, but do not require, that the following message be included in all   *
* derived works:							      *
* 									      *
* THE NAVAL RESEARCH LABORATORY GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR  *
* THE SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,  *
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE*
* 									      *
******************************************************************************/

/******************************************************************************
*
*	File:		moov.C
*
*	Module(s):	write MooV
*
*	Version:	1.1
*
*	Date:		Aug 18, 1992
*
*	Facility:	NRL/RCD Visualization Lab AVS Modules Suite.
*
*	Abstract:	AVS module "write MooV" is the first shot at 
*                       incorporating QuickTime(tm) into AVS as a method 
*			for producing convenient, compact, and high quality 
*			video segments.  QuickTime(tm) is rather convenient 
*			since there is likely to be more support on other 
*			systems, and there is a growing base of QuickTime(tm)
*			cheaply available for the Macintosh.
*
*			This code currently requires, the QuickTime Movie 
*			Exchange Toolkit, which is available from Apple, Inc, 
*			and a C++ compiler (you also need the C++ compiler to 
*			build the QuickTime(tm) libraries.
*
*	References:	QuickTime Movie Exchange Toolkit by Apple Computer.
*
*	Authors:	Charles J Williams III (chas@ra.nrl.navy.mil)
*
*			Date		Author(s)	Description
*	Modifications:	--------	--------	-----------
*			../../..	......		.......  
* 
*	Notes:		...
*
*	Bugs:		...
*
******************************************************************************/
/* 
 * $Log: moov.C,v $
 * Revision 1.1  1992/08/18  11:52:15  chas
 * Initial revision
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>

// Include the QuickTime(tm) library headers
// RLE and RPZA where not supplied
#define NORLE
#define NORPZA
#include <qtime.h>
#include <portio.h>

extern "C" 
{
#include <avs/avs.h>
#include <avs/field.h>

// Declare C linkage for subroutines
// only AVSinit_modules() really needs this
extern AVSinit_modules(void);
int write_MooV_compute();
int write_MooV_spec(void);
int write_MooV_finis(void);
}

// Some defines to make my brain hurt less
#define FAILURE 0
#define SUCCESS 1

// Global variables
static TMovie *theMovie; 	// used in _finis and _compute
static int initialized;

static char rcsid[] = "$Id: moov.C,v 1.1 1992/08/18 11:52:15 chas Exp chas $";

/******************************************/
/* Module Specification                   */
/******************************************/
int write_MooV_spec(void)
{

	int in_port, out_port, param;
	extern int write_MooV_compute();

	AVSset_module_name("write MooV", MODULE_RENDER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("Image", "field 2D 4-vector byte", 
		REQUIRED);
	in_port = AVScreate_input_port("Sound", "field 1D 1-vector byte", 
		OPTIONAL);

	/* Parameter Specifications                */
	param = AVSadd_parameter("File Browser", "string", "", "", "");
	AVSconnect_widget(param, "browser");

	param = AVSadd_parameter("Compression", "choice", "JPEG", 
		"None:JPEG:Video:RLE", ":");
	AVSconnect_widget(param, "radio_buttons");

	param = AVSadd_parameter("Quality", "integer", 3, 0, 4);
	AVSconnect_widget(param, "islider");

	param = AVSadd_parameter("Frame Rate", "integer", 10, 1, 60);
	AVSconnect_widget(param, "islider");

	param = AVSadd_parameter("KeyFrame Rate", "integer", 20, 1, 60);
	AVSconnect_widget(param, "islider");

	AVSset_compute_proc(write_MooV_compute);

	AVSset_destroy_proc(write_MooV_finis);

	theMovie = 0;
	initialized = 0;
	return(1);
}
 
/******************************************/
/* Module Compute Routine                 */
/******************************************/
int
write_MooV_compute( 
	AVSfield_char *Image, 
	AVSfield_char *Sound, 
	char *File_Browser, 
	char *Compression, 
	int Quality,
	int Frame_Rate,
	int KeyFrame_Rate)
{
	// QuickTime(tm) movie variables
	static int width, height;
	static int hasSound = 0;
	float sampleRate;
	
	// miscelaneous module variables
	static unsigned char *buffer;
	register unsigned char *a, *b;
	static int pixels;
	int i;

	if (!File_Browser)
		return(FAILURE);

	if ( AVSparameter_changed( "File Browser" ))
	{
		if ( theMovie ) theMovie->CloseMovie();
		initialized = 0;
		hasSound = 0;
	}

	if ( !Image ) 
		return(FAILURE);

	width = Image->dimensions[0];
	height = Image->dimensions[1];

	if ( ( width==0) || (height==0) )
		return(FAILURE);

	if ( !initialized )
	{
		if ( buffer ) free( (void*) buffer);
		pixels = width * height;
		buffer = (unsigned char *) malloc( (size_t) pixels * 3);

		switch (Compression[0])
		{
			case 'J':
				theMovie=(TMovie *) new TJPEGQuickTimeMovie();
				break;
			case 'N':
				theMovie=(TMovie *) new TRawQuickTimeMovie();
				break;
			default:
				AVSerror("Compression method not supported");
				initialized = 0;
				return(FAILURE);
		}
				

		theMovie->IMovie( File_Browser, width, height);

		theMovie->SetQuality( (float) Quality, (float) Quality );
		theMovie->SetFrameRate( Frame_Rate );
		theMovie->SetKeyFrameRate( KeyFrame_Rate );
	
		initialized = 1;
	}

	// Attempt to add Sound if it is present

	if ( Sound && !hasSound && (initialized) )
	{
		hasSound = 1;
		sampleRate = 1.0 / (
				( Sound->max_extent[0] - Sound->min_extent[0] )
				/ Sound->dimensions[0] );
		theMovie->AddSound( (unsigned char *) Sound->data,
			sampleRate, Sound->dimensions[0], 1 );
	}

	// Convert AVS image buffer to something useful for quicktime
	a = Image->data;
	b = buffer;

	for ( i = 0; i < pixels; ++i )
	{
		a++;		// skip transparency
		*b++ = *a++;
		*b++ = *a++;
		*b++ = *a++;
	}

	theMovie->AddInterleavedColorFrame(buffer);

	return(SUCCESS);
}

/******************************************/
/* Module Compute Routine                 */
/******************************************/
int write_MooV_finis(void)
{
	theMovie->CloseMovie();
	return(SUCCESS);
}
 
/************************************************************************/
/*Initialization for modules contained in this file.                    */
/************************************************************************/
int ((*filter_mod_list[])()) = {
	write_MooV_spec,
};
#define NMODS (sizeof(filter_mod_list) / sizeof(char *))

int
AVSinit_modules(void)
{
	AVSinit_from_module_list(filter_mod_list, NMODS);
	return(SUCCESS);
}
