/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/* Module Name: "write_vrml" (Output) (Subroutine)                          */

static char	sccsid[] = "@(#)write_vrml.c	2.5 19 Dec 1995 (c)FUJITSU NAGANO SYSTEMS ENGINEERING LTD";
static char	authid[] = "Author: Hiroyuki Yoshikawa, CAE R&D Center / FNS";

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
#include <avs/geom_edit.h>

#define		LDMN	"write VRML"
#define		MAGIC	"#VRML V1.0 ascii\n"

static char	*geom_type_list[] = {"0",
				     "GEOM_MESH",
				     "GEOM_POLYHEDRON",
				     "GEOM_POLYTRI",
				     "GEOM_SPHERE",
				     "GEOM_LABEL"};

#undef	Z_BIDIRECTIONAL_LIGHT

#define	LABEL_SCALE	1.0
static char	label_font[] = "SANS";
static float	transparent = 0.0;

/*
 *	DESCRIPTION FUNCTION
 */
int write_vrml_desc()
{
	int in_port, out_port, param, iresult;
	extern int write_vrml_compute();

	AVSset_module_name(LDMN, MODULE_RENDER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("in", "geom", REQUIRED);  /* high detail */
	in_port = AVScreate_input_port("in2", "geom", OPTIONAL); /* low detail */

	/* Parameter Specifications                */
	param = AVSadd_parameter("outfile", "string", "", "", ":");
	AVSconnect_widget(param, "browser");
        param = AVSadd_parameter("href", "string", "", "", ":");
        AVSconnect_widget(param, "typein");
	AVSadd_parameter_prop(param, "width", "integer", 4);
        param = AVSadd_float_parameter("transparency", 0.00000, 0.00000, 1.00000);
        AVSconnect_widget(param, "slider");

        param = AVSadd_float_parameter("detail range", 0.00000, 0.00000, FLOAT_UNBOUND);
        AVSconnect_widget(param, "typein_real");
	AVSadd_parameter_prop(param, "width", "integer", 4);
        param = AVSadd_parameter("detail center", "string", "0.0 0.0 0.0", "", ":");
        AVSconnect_widget(param, "typein");
	AVSadd_parameter_prop(param, "width", "integer", 4);

	param = AVSadd_parameter("start traverse", "oneshot", 0, 0, 1);
	AVSconnect_widget(param, "oneshot");
	AVSadd_parameter_prop(param, "width", "integer", 4);

	AVSset_compute_proc(write_vrml_compute);
	return(1);
}


FILE	*fp;

/*
 *	COMPUTATIONAL FUNCTION
 */
int
write_vrml_compute(in, in2, outfile, href, transp, range, dcenter, start)
GEOMedit_list	in;
GEOMedit_list	in2;
char		*outfile;
char		*href;
float		*transp;
float		*range;
char		*dcenter;
int		start;
{
    int		output_wrl();

    float	center[3];


    /*************  BODY  **************/
    if ( !start )
	return(0);

    if ( *outfile == '\0' )
	return(0);

    /*	VRML file open	*/
    fp = fopen(outfile, "w");
    if ( !fp ) {
	AVSerror("Can't open file:\n %s", outfile);
	return(0);
    }

    /*	Write header	*/
    fprintf(fp, MAGIC);


#   ifdef Z_BIDIRECTIONAL_LIGHT
    fprintf(fp, "\tDirectionalLight { direction  0  0 -1 }\n");
    fprintf(fp, "\tDirectionalLight { direction  0  0  1 }\n");
#   endif


    /*  Set WWWAnchor	*/
    if ( strlen(href) > 0 ) {
	fprintf(fp, "WWWAnchor {\n");
	fprintf(fp, "name  \"%s\"\n", href); /* URL */
    } else
	fprintf(fp, "Separator {\n");


    /*  Set transparency factor	*/
    transparent = *transp;

    /*	Set Geometry edit function	*/
    GEOMset_new_geometry_func(output_wrl);

    /*	Call Geometry edit function	*/
    if ( in2 && *range > 0.01 &&
	sscanf(dcenter, "%f%f%f", &center[0], &center[1], &center[2]) == 3) {

	fprintf(fp, "LOD {\n");
	fprintf(fp, "center %f %f %f\n", center[0], center[1], center[2]);
	fprintf(fp, "range [ %f ]\n", *range);

	fprintf(fp, "Separator {\n"); /* high detail node */
	GEOMprocess_edit_list(in);
	fprintf(fp, "}\n");

	fprintf(fp, "Separator {\n"); /* low detail node */
	GEOMprocess_edit_list(in2);
	fprintf(fp, "}\n");

	fprintf(fp, "}\n"); /* end of LOD Node */

    } else {

	GEOMprocess_edit_list(in);

    }

    fprintf(fp, "}\n");
    fclose(fp);

    return(1);
}
 

static int ((*mod_list[])()) = {
	write_vrml_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}



/*
 *	GEOMETRY EDIT FUNCTION
 */
int
output_wrl(name, input)
char	*name;
GEOMobj	*input;
{
    int		output_mesh();
    int		output_sphere();
    int		output_polyh();
    int		output_polytri();
    int		output_polyline();
    int		output_djline();
    int		output_label();


    switch ( input->type ) {

      case GEOM_MESH:
	if ( input->d.m.m < 1 || input->d.m.n < 1 )
	    break;
	output_mesh(name, input);
	break;
	
      case GEOM_POLYHEDRON:
	output_polyh(name, input);
	break;
	
      case GEOM_POLYTRI:
	if ( input->d.pt.npts > 0 )
	    output_polytri(name, input);	/* triangle strips */
	if ( input->d.pt.npls > 0 && input->d.pt.npts < 1 )
	    output_polyline(name, input);	/* polylines */
	if ( input->d.pt.dlverts.n > 1 && input->d.pt.npts < 1 )
	    output_djline(name, input);		/* disjoint lines */
	break;

      case GEOM_SPHERE:
	output_sphere(name, input);
	break;

      case GEOM_LABEL:
	output_label(name, input);
	break;

      default:
	fprintf(stderr, "%s: %s includes %s object. ignore.\n",
		LDMN, name, geom_type_list[input->type]);
	fflush(stderr);
	break;
    }

    return(1);
}

/*
 * OUTPUT POLYTRIANGLES
 */
int
output_polytri(name, input)
char	*name;
GEOMobj	*input;
{
    int		i, j;

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    for ( j = 0; j < input->d.pt.npts; j++ ) {
	fprintf(fp, "\tCoordinate3 {\n");
	fprintf(fp, "\t point [ ");
	for ( i = 0; i < input->d.pt.ptverts[j].n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f,\n",
		    input->d.pt.ptverts[j].l[i*3],
		    input->d.pt.ptverts[j].l[i*3+1],
		    input->d.pt.ptverts[j].l[i*3+2]);
	}
	fprintf(fp, "\t ]\n");
	fprintf(fp, "\t}\n");

	if ( input->data & GEOM_NORMALS ) {

	    /*** BIDIRECTIONAL LIGHTS (for arbitrary slice and mesh) ***/
	    if ( !strncmp(name, "field mesh", strlen("field mesh")-1) ||
		 !strncmp(name, "slice", strlen("slice")-1) ) {
		fprintf(fp, "\tDirectionalLight { direction %f %f %f }\n",
			-input->d.pt.ptnormals[j].l[0],
			-input->d.pt.ptnormals[j].l[1],
			-input->d.pt.ptnormals[j].l[2]);
	    }

	    fprintf(fp, "\tNormal {\n");
	    fprintf(fp, "\t vector [");
	    for ( i = 0; i < input->d.pt.ptnormals[j].n; i++ ) {
		fprintf(fp, "\t\t%f %f %f,\n",
			input->d.pt.ptnormals[j].l[i*3],
			input->d.pt.ptnormals[j].l[i*3+1],
			input->d.pt.ptnormals[j].l[i*3+2]);
	    }
	    fprintf(fp, "\t ]\n");
	    fprintf(fp, "\t}\n");
	    fprintf(fp, "\tNormalBinding {\n");
	    fprintf(fp, "\t\tvalue PER_VERTEX_INDEXED\n");
	    fprintf(fp, "\t}\n");
	}

	if ( input->data & GEOM_VCOLORS ) {
	    fprintf(fp, "\tMaterial {\n");
	    fprintf(fp, "\t diffuseColor [");
	    for ( i = 0; i < input->d.pt.ptverts[j].n; i++ ) {
		fprintf(fp, "\t\t%f %f %f,\n",
			input->d.pt.ptcolors[j].l[i*3],
			input->d.pt.ptcolors[j].l[i*3+1],
			input->d.pt.ptcolors[j].l[i*3+2]);
	    }
	    fprintf(fp, "\t ]\n");
	    fprintf(fp, "\t transparency %f\n", transparent);
	    fprintf(fp, "\t}\n");
	    fprintf(fp, "\tMaterialBinding {\n");
	    fprintf(fp, "\t\tvalue PER_VERTEX_INDEXED\n");
	    fprintf(fp, "\t}\n");
	} else {
	    fprintf(fp, "\tMaterial {\n");
	    fprintf(fp, "\t diffuseColor 1 1 1\n");
	    fprintf(fp, "\t transparency %f\n", transparent);
	    fprintf(fp, "\t}\n");
	}

	fprintf(fp, "\tIndexedFaceSet {\n");
	fprintf(fp, "\t coordIndex [\n");
	for ( i = 0; i < input->d.pt.ptverts[j].n -2; i++ )
	    fprintf(fp, "\t\t%d, %d, %d, -1,\n", i, i+1, i+2);
	fprintf(fp, "\t ]\n");
	fprintf(fp, "\t}\n");

    }

    fprintf(fp, " }\n");

    return(1);
}

/*
 * OUTPUT MESH
 */
int
output_mesh(name, input)
char	*name;
GEOMobj	*input;
{
    int		i, j;


    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    fprintf(fp, "\tCoordinate3 {\n");
    fprintf(fp, "\t point [ ");
    for ( i = 0; i < input->d.m.verts.n; i++ ) {
	fprintf(fp, "\t\t%f %f %f,\n",
		input->d.m.verts.l[i*3],
		input->d.m.verts.l[i*3+1],
		input->d.m.verts.l[i*3+2]);
    }
    fprintf(fp, "\t ]\n");
    fprintf(fp, "\t}\n");

    if ( input->data & GEOM_NORMALS ) {
	fprintf(fp, "\tNormal {\n");
	fprintf(fp, "\t vector [");
	for ( i = 0; i < input->d.m.normals.n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f,\n",
		    input->d.m.normals.l[i*3],
		    input->d.m.normals.l[i*3+1],
		    input->d.m.normals.l[i*3+2]);
	}
	fprintf(fp, "\t ]\n");
	fprintf(fp, "\t}\n");
	fprintf(fp, "\tNormalBinding {\n");
	fprintf(fp, "\t\tvalue PER_VERTEX_INDEXED\n");
	fprintf(fp, "\t}\n");
    }

    if ( input->data & GEOM_VCOLORS ) {
	fprintf(fp, "\tMaterial {\n");
	fprintf(fp, "\t diffuseColor [");
	for ( i = 0; i < input->d.m.colors.n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f,\n",
		    input->d.m.colors.l[i*3],
		    input->d.m.colors.l[i*3+1],
		    input->d.m.colors.l[i*3+2]);
	}
	fprintf(fp, "\t ]\n");
	fprintf(fp, "\t transparency %f\n", transparent);
	fprintf(fp, "\t}\n");
	fprintf(fp, "\tMaterialBinding {\n");
	fprintf(fp, "\t\tvalue PER_VERTEX_INDEXED\n");
	fprintf(fp, "\t}\n");
    } else {
	fprintf(fp, "\tMaterial {\n");
	fprintf(fp, "\t diffuseColor 1 1 1\n");
	fprintf(fp, "\t transparency %f\n", transparent);
	fprintf(fp, "\t}\n");
    }

    fprintf(fp, "\tIndexedFaceSet {\n");
    fprintf(fp, "\t coordIndex [\n");
    for ( j = 0; j < input->d.m.n -1; j++ )
	for ( i = 0; i < input->d.m.m -1; i++ )
	    fprintf(fp, "\t\t%d, %d, %d, %d, -1,\n",
		    i +j*input->d.m.m,
		    i+1 +j*input->d.m.m,
		    i+1+input->d.m.m +j*input->d.m.m,
		    i+input->d.m.m +j*input->d.m.m);
    fprintf(fp, "\t ]\n");
    fprintf(fp, "\t}\n");

    fprintf(fp, " }\n");

    return(1);
}

/*
 * OUTPUT SPHERES
 */
int
output_sphere(name, input)
char	*name;
GEOMobj	*input;
{
    int		i;

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    for ( i = 0; i < input->d.sp.verts.n; i++ ) {
	fprintf(fp, "  Separator {\n");

	fprintf(fp, "\tTransform { translation %f %f %f }\n",
		input->d.sp.verts.l[i*3],
		input->d.sp.verts.l[i*3+1],
		input->d.sp.verts.l[i*3+2]);

	if ( input->data & GEOM_VCOLORS ) {
	    fprintf(fp, "\tMaterial { diffuseColor %f %f %f }\n",
		    input->d.sp.colors.l[i*3],
		    input->d.sp.colors.l[i*3+1],
		    input->d.sp.colors.l[i*3+2]);
	    fprintf(fp, "\t transparency %f\n", transparent);
	}

	fprintf(fp, "\tSphere { radius %f }\n", input->d.sp.radii.l[i]);

	fprintf(fp, "  }\n");
    }

    fprintf(fp, " }\n");
    return(1);
}

/*
 * OUTPUT POLYHEDRON
 */
int
output_polyh(name, input)
char	*name;
GEOMobj	*input;
{
    int		i, j, *pp;

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    fprintf(fp, "\tCoordinate3 {\n");
    fprintf(fp, "\t point [ ");
    for ( i = 0; i < input->d.ph.verts.n; i++ ) {
	fprintf(fp, "\t\t%f %f %f,\n",
		input->d.ph.verts.l[i*3],
		input->d.ph.verts.l[i*3+1],
		input->d.ph.verts.l[i*3+2]);
    }
    fprintf(fp, "\t ]\n");
    fprintf(fp, "\t}\n");

    if ( input->data & GEOM_NORMALS ) {
	fprintf(fp, "\tNormal {\n");
	fprintf(fp, "\t vector [");
	for ( i = 0; i < input->d.ph.normals.n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f,\n",
		    input->d.ph.normals.l[i*3],
		    input->d.ph.normals.l[i*3+1],
		    input->d.ph.normals.l[i*3+2]);
	}
	fprintf(fp, "\t ]\n");
	fprintf(fp, "\t}\n");
	fprintf(fp, "\tNormalBinding {\n");
	fprintf(fp, "\t\tvalue PER_VERTEX\n");
	fprintf(fp, "\t}\n");
    }

    if ( input->data & GEOM_VCOLORS ) {
	fprintf(fp, "\tMaterial {\n");
	fprintf(fp, "\t diffuseColor [");
	for ( i = 0; i < input->d.ph.colors.n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f,\n",
		    input->d.ph.colors.l[i*3],
		    input->d.ph.colors.l[i*3+1],
		    input->d.ph.colors.l[i*3+2]);
	}
	fprintf(fp, "\t ]\n");
	fprintf(fp, "\t transparency %f\n", transparent);
	fprintf(fp, "\t}\n");
	fprintf(fp, "\tMaterialBinding {\n");
	fprintf(fp, "\t\tvalue PER_VERTEX\n");
	fprintf(fp, "\t}\n");
    } else {
	fprintf(fp, "\tMaterial {\n");
	fprintf(fp, "\t diffuseColor 1 1 1\n");
	fprintf(fp, "\t transparency %f\n", transparent);
	fprintf(fp, "\t}\n");
    }

    fprintf(fp, "\tIndexedFaceSet {\n");
    fprintf(fp, "\t coordIndex [ ");

    pp = input->d.ph.ptlist.l;
    for ( i = 0; i < input->d.ph.ptlist.nps; i++ ) {
	int	verts;
	verts = *pp; pp++;
	for ( j = 0; j < verts; j++, pp++ )
	    fprintf(fp, "%d, ", *pp -1);

	fprintf(fp, "-1,\n");
    }
    fprintf(fp, "\t ]\n");
    fprintf(fp, "\t}\n");

    fprintf(fp, " }\n");

    return(1);
}

/*
 * OUTPUT POLYLINES
 */
int
output_polyline(name, input)
char	*name;
GEOMobj	*input;
{
    int		i, j;

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    for ( j = 0; j < input->d.pt.npls; j++ ) {
	fprintf(fp, "\tCoordinate3 {\n");
	fprintf(fp, "\t point [ ");
	for ( i = 0; i < input->d.pt.plverts[j].n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f,\n",
		    input->d.pt.plverts[j].l[i*3],
		    input->d.pt.plverts[j].l[i*3+1],
		    input->d.pt.plverts[j].l[i*3+2]);
	}
	fprintf(fp, "\t ]\n");
	fprintf(fp, "\t}\n");

	if ( input->data & GEOM_VCOLORS ) {
	    fprintf(fp, "\tMaterial {\n");
	    fprintf(fp, "\t diffuseColor [");
	    for ( i = 0; i < input->d.pt.plverts[j].n; i++ ) {
		fprintf(fp, "\t\t%f %f %f,\n",
			input->d.pt.plcolors[j].l[i*3],
			input->d.pt.plcolors[j].l[i*3+1],
			input->d.pt.plcolors[j].l[i*3+2]);
	    }
	    fprintf(fp, "\t ]\n");
	    fprintf(fp, "\t}\n");
	    fprintf(fp, "\tMaterialBinding {\n");
	    fprintf(fp, "\t\tvalue PER_VERTEX\n");
	    fprintf(fp, "\t}\n");
	} else {
	    fprintf(fp, "\tMaterial {\n");
	    fprintf(fp, "\t diffuseColor 1 1 1\n");
	    fprintf(fp, "\t}\n");
	}

	fprintf(fp, "\tIndexedLineSet {\n");
	fprintf(fp, "\t coordIndex [\n");
	for ( i = 1; i < input->d.pt.plverts[j].n; i++ )
	    fprintf(fp, "\t\t%d, %d, -1,\n", i-1, i);
	fprintf(fp, "\t ]\n");
	fprintf(fp, "\t}\n");

    }

    fprintf(fp, " }\n");

    return(1);
}

/*
 * OUTPUT DISJOINT LINES
 */
int
output_djline(name, input)
char	*name;
GEOMobj	*input;
{
    int		i;

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    fprintf(fp, "\tCoordinate3 {\n");
    fprintf(fp, "\t point [ ");
    for ( i = 0; i < input->d.pt.dlverts.n; i++ ) {
	fprintf(fp, "\t\t%f %f %f,\n",
		input->d.pt.dlverts.l[i*3],
		input->d.pt.dlverts.l[i*3+1],
		input->d.pt.dlverts.l[i*3+2]);
    }
    fprintf(fp, "\t ]\n");
    fprintf(fp, "\t}\n");

    if ( input->data & GEOM_VCOLORS ) {
	fprintf(fp, "\tMaterial {\n");
	fprintf(fp, "\t diffuseColor [");
	for ( i = 0; i < input->d.pt.dlcolors.n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f,\n",
		    input->d.pt.dlcolors.l[i*3],
		    input->d.pt.dlcolors.l[i*3+1],
		    input->d.pt.dlcolors.l[i*3+2]);
	}
	fprintf(fp, "\t ]\n");
	fprintf(fp, "\t}\n");
	fprintf(fp, "\tMaterialBinding {\n");
	fprintf(fp, "\t\tvalue PER_VERTEX\n");
	fprintf(fp, "\t}\n");
    } else {
	fprintf(fp, "\tMaterial {\n");
	fprintf(fp, "\t diffuseColor  1 1 1\n");
	fprintf(fp, "\t}\n");
    }

    fprintf(fp, "\tIndexedLineSet {\n");
    fprintf(fp, "\t\tcoordIndex [ ");
    for ( i = 0; i < input->d.pt.dlverts.n / 2; i++ ) {
	fprintf(fp, "\t\t%d, %d, -1,\n", i*2, i*2 +1);
    }
    fprintf(fp, "\t ]\n");
    fprintf(fp, "\t}\n");

    fprintf(fp, " }\n");
    return(1);
}

/*
 * OUTPUT LABELS
 */
int
output_label(name, input)
char	*name;
GEOMobj	*input;
{
    int		i;
    int		flag;
    static char	*label_just[] = { "LEFT", "RIGHT", "CENTER" };

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    for ( i = 0; i < input->d.la.labels.n; i++ ) {
	flag = GEOMget_label_flags(input, i);

	/** Ignore Title Labels **/
	if ( flag & GEOM_LABEL_ABSOLUTE )
	    continue;

	fprintf(fp, "  Separator {\n");

	fprintf(fp, "\tFontStyle {\n");
	fprintf(fp, "\t\tsize    %f\n", input->d.la.heights.l[i]* LABEL_SCALE);
	fprintf(fp, "\t\tfamily  %s\n", label_font);
	fprintf(fp, "\t\tstyle   NONE\n");
	fprintf(fp, "\t}\n");

	fprintf(fp, "\tTransform { translation %f %f %f }\n",
		input->d.la.verts.l[i*3] + input->d.la.offsets.l[i*3],
		input->d.la.verts.l[i*3+1] + input->d.la.offsets.l[i*3+1],
		input->d.la.verts.l[i*3+2] + input->d.la.offsets.l[i*3+2]);

	if ( input->data & GEOM_VCOLORS ) {
	    fprintf(fp, "\tMaterial { diffuseColor %f %f %f }\n",
		    input->d.la.colors.l[i*3],
		    input->d.la.colors.l[i*3+1],
		    input->d.la.colors.l[i*3+2]);
	}

	fprintf(fp, "\tAsciiText {\n");
	fprintf(fp, "\t\tstring \"%s\"\n", input->d.la.labels.l[i]);

	if ( flag & GEOM_LABEL_CENTER )
	    fprintf(fp, "\t\tjustification  %s\n", label_just[2]);
	else if ( flag & GEOM_LABEL_RIGHT )
	    fprintf(fp, "\t\tjustification  %s\n", label_just[1]);
	else
	    fprintf(fp, "\t\tjustification  %s\n", label_just[0]);

	fprintf(fp, "\t}\n");

	fprintf(fp, "  }\n");
    }

    fprintf(fp, " }\n");
    return(1);
}

/*** EOF ***/
