/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

AUTHOR : Stardent Computer, Inc.
******************************************************************************/
/* write_a60rgb: write the input port image to an A60 RGB file 
 *               (Abekas A60 Video Disk format)
 *
 *     Author:  Ian Curington
 *              Stardent Computer Limited
 *              15 Frederick Sanger Road
 *              The Surrey Research Park
 *              Guildford
 *              Surrey    GU2 5YD
 *              United Kingdom
 *              +44-483-505388
 *              email: ianc@Stardent.COM

 * Derived from "output postscript"
 * revision history:  25 January  90   original
 *                     8 February 90 ianc: debugging: 1st image only.
 *                    28 February 90 ianc: debugging: format conversion.
 *                        input size must math exactly
 *                    13 March    90 variable size prototype
 *
 */

/* A routine to output an image file given an image */

#include <stdio.h>
#include <avs/vex.h>
#include <avs/flow.h>
#include <avs/field.h>

#define A60_Height 576    /* fixed size */
#define A60_Width  720

/* Description - Definition routine for linkage to AVS */
AVSinit_modules()
{
     int save_desc();
     AVSmodule_from_desc(save_desc);
}
static
save_desc()
{
    int write_a60rgb();
    int save_init();
	int param;

	AVSset_module_name("write abekas a60", MODULE_RENDER);
	AVScreate_input_port("Input Field",
               "field 2D 4-vector byte", REQUIRED);
	param = AVSadd_parameter("Write a60 Browser", "string", "", 0, 0);
    AVSconnect_widget(param, "browser");
		     
	AVSset_compute_proc(write_a60rgb);
}

/* Compute function, called every time module is active */
write_a60rgb(input, filename )
AVSfield_char *input;
char *filename;
{
    int size, i, j, x, y;
    char *inbuf;
    char   tmp_str[512];
    int fd;
    FILE *fp;
    int itop, jtop, ihalf, jhalf;
    int i_index, j_index;

    printf(" write_a60rgb: dump pixmap called.\n");

	if (!AVSparameter_changed("Write a60 Browser")) return(1);

	/* Wait for filename to be initialized */
	if (filename == NULL || *filename == '\0') return(1);

    /* copy data into output format */
    size =  A60_Width * A60_Height * 3;
    /* Allocate space for output image data */
    inbuf = malloc ( size );

    /* modify the format storage */
/* comment out.....
    j=0;
    for (i=0; i < size; i+=3)
    {
        inbuf[i  ] = input->data[j+1];
        inbuf[i+1] = input->data[j+2];
        inbuf[i+2] = input->data[j+3];
        j += 4;
    }
 ... end comment */

    /* 2d index format storage conversion */
    ihalf = jhalf = 0;
    if ( MAXY(input) < A60_Height )    /* set output picture dimensions */
    {
        jtop = MAXY(input);
        jhalf= (A60_Height-jtop)/2;
    }
    else
        jtop = A60_Height;
    if ( MAXX(input) < A60_Width )
    {
        itop = MAXX(input);
        ihalf= (A60_Width-itop)/2;
    }
    else
        itop = A60_Width;
    if ( (jtop*itop) < (A60_Height*A60_Width) )
    {
        printf (" write_a60rgb: small input %d x %d, black border.\n"
                  ,itop, jtop);
        for (i=0; i<size; i++ ) inbuf[i]=0;   /* pre-black */
    }
    for ( j=0; j<jtop; j++ )
    {
        for ( i=0; i<itop; i++ )
        {
        j_index = ((j+jhalf)*A60_Width+ihalf+i)*3;
        i_index = (j*MAXX(input)+i)*4;
        inbuf[j_index  ] = input->data[i_index+1];
        inbuf[j_index+1] = input->data[i_index+2];
        inbuf[j_index+2] = input->data[i_index+3];
        }
    }

    /* write field to file here... */
    if ((fp = fopen(filename, "w")) == NULL) {
        printf(" wrt_a60: Can't open output file %s\n",
                filename);
        return(0);
    }
    fd = fileno(fp);
    write(fd, inbuf, size);
    close (fd);
    free (inbuf);

    printf (" write_a60rgb: finished.\n");
	return(1);
}

