/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "write jpeg" (Output) (Subroutine)                       */
/* Author: John W. Langner                                               */
/* Date Created: Wed Oct 23 16:15:47 1991                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* input 0 "AVS image in" field 2D 4-vector byte REQUIRED                */
/* param 0 "Noninterleaved" toggle 0 0 1                                 */
/* param 1 "Quality" islider 75 0 100                                    */
/* param 2 "Arithmetic Coding" toggle 0 0 1                              */
/* param 3 "Entropy Optimization" toggle 0 0 1                           */
/* param 4 "JPEG Output File Name" browser                               */
/* End of Module Description Comments                                    */

#define _MEM_DEFS_defined 1	/* disable memory checking routines */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/

/*
 * DISCLAIMER
 * ==========
 *
 * THIS SOFTWARE IS NOT COMPLETE NOR FULLY DEBUGGED.  It is not guaranteed to be
 * useful for anything, nor to be compatible with subsequent releases, nor to be
 * an accurate implementation of the JPEG standard.  (See LEGAL ISSUES for even
 * more disclaimers.)
 */

#include "jinclude.h"
#include <setjmp.h>

extern char *getenv();
/* SRT 10/16/92 extern unsigned char *AVSfield_data_ptr(); */

static void c_ui_method_selection ();
void jselravs ();

static jmp_buf error_recovery_env;
static AVSfield_char *global_in_field_ptr;
static int next_row_in;

/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Specification                   */
/* *****************************************/
int write_jpeg_spec()
{

	int in_port, out_port, param;
	extern int write_jpeg_compute();

	AVSset_module_name("write jpeg", MODULE_RENDER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("AVS image in", 
		"field 2D 4-vector byte", REQUIRED);

	/* Parameter Specifications                */
	param = AVSadd_parameter("Noninterleaved", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Quality", "integer", 75, 0, 100);
	AVSconnect_widget(param, "islider");
	param = AVSadd_parameter("Arithmetic Coding", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Entropy Optimization", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("JPEG Output File Name", "string", " ", " ", 
		" ");
	AVSconnect_widget(param, "browser");

	AVSset_compute_proc(write_jpeg_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int write_jpeg_compute( AVS_image_in, Noninterleaved, Quality, 
Arithmetic_Coding, Entropy_Optimization, JPEG_Output_File_Name)
	AVSfield_char *AVS_image_in;
	int Noninterleaved;
	int Quality;
	int Arithmetic_Coding;
	int Entropy_Optimization;
	char *JPEG_Output_File_Name;
{

/*  THIS IS A 'HINTS' AREA - YOU MAY CUT AND PASTE AT WILL FROM IT       */
/*                                                                       */
/* free any locally allocated data                                       */
/* THIS IS THE END OF THE 'HINTS' AREA. ADD YOUR OWN CODE BETWEEN THE    */
/* FOLLOWING COMMENTS. THE CODE YOU SUPPLY WILL NOT BE OVERWRITTEN.      */
 
/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */

/*-------------------------------------------------------------------------
 * 
 * Based on:
 *
 * jcmain.c			last edit:  tgl  11-Aug-91
 *
 * Shoehorned in a few differences found in later version 1 which contained:
 *
 * Copyright (C) 1991, Thomas G. Lane.
 * This file is part of the Independent JPEG Group's software.
 * For conditions of distribution and use, see the accompanying README file.
 *
 *--------------------------------------------------------------------------*/


  struct compress_info_struct cinfo;
  struct compress_methods_struct c_methods;
  struct external_methods_struct e_methods;
  char *p;


  global_in_field_ptr = AVS_image_in;

/* 
 * Try to open output file.
 */
  if (JPEG_Output_File_Name == NULL || 
			*JPEG_Output_File_Name == '\0' ||
			*JPEG_Output_File_Name == ' ') {
      return (0);
  }

  cinfo.output_file = fopen (JPEG_Output_File_Name, "w");
  if (cinfo.output_file == NULL) {
      AVSerror ("Can't open output file:\n'%s'", JPEG_Output_File_Name);
      return (0);
  }

/* 
 * ERREXIT will display dialog box with message then come here.
 */
  if (setjmp (error_recovery_env) != 0) {
      fclose (cinfo.output_file);
      return (0);	/* failure */
  }


/*
 * Debug output.
 */
  e_methods.trace_level = 0;
  p = getenv("AVS_JPEG_DEBUG");
  if (p != NULL)
      e_methods.trace_level = atoi(p);


/* 
 * Initialize the system-dependent method pointers. 
 */
  cinfo.methods = &c_methods;
  cinfo.emethods = &e_methods;
  jselerror(&e_methods);	/* error/trace message routines */
  jselvirtmem(&e_methods);	/* memory allocation routines */
  c_methods.c_ui_method_selection = c_ui_method_selection;

  cinfo.input_file = NULL;	/* not used for AVS */

/* 
 * Set up parameters. 
 */
  j_default_compression(&cinfo, 75); /* default quality level */
  /* Note: for now, we leave force_baseline FALSE.
   * In a production user interface, probably should make it TRUE
   * unless overridden by a separate switch.
   */
  j_set_quality(&cinfo, Quality, FALSE);

  cinfo.interleave = ! Noninterleaved;
  cinfo.arith_code = Arithmetic_Coding;
#ifndef ARITH_CODING_SUPPORTED
  if (cinfo.arith_code) {
      AVSwarning ("Sorry, arithmetic coding not supported.");
      /* Send complaints to IBM. */
      cinfo.arith_code = FALSE;
  }
#endif
  cinfo.optimize_coding = Entropy_Optimization;

/* 
 * Set up to get input image from module input port. 
 */
  jselravs(&cinfo);

/* 
 * Do it to it! 
 */
  jpeg_compress(&cinfo);

/* 
 * All done. 
 */
  j_free_defaults(&cinfo);

  fclose (cinfo.output_file);

#ifdef MEM_STATS
  if (e_methods.trace_level > 0)
    j_mem_stats();
#endif

/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*filter_mod_list[])()) = {
	write_jpeg_spec,
};
#define NMODS (sizeof(filter_mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(filter_mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/


static void
c_ui_method_selection (compress_info_ptr cinfo)
{
  /* If the input is gray scale, generate a monochrome JPEG file. */
  /* Can't happen today.  Maybe we could accept a scalar field as */
  /* a grayscale image someday. */

  if (cinfo->in_color_space == CS_GRAYSCALE)
    j_monochrome_default(cinfo);
  /* For now, always select JFIF header format. */
#ifdef JFIF_SUPPORTED
  jselwjfif(cinfo);
#else
  ERREXIT(cinfo->emethods, "You shoulda defined JFIF_SUPPORTED");
#endif
}


/*--------------------------------------------------------------------------
 * 
 * Based on:
 *
 * jrdppm.c			last edit:  tgl  11-Aug-91
 *
 * These routines obtain an image from an AVS field.
 *
 * These routines are invoked via the methods get_input_row
 * and input_init/term.
 *
 *--------------------------------------------------------------------------*/

/*
 * Read the file header; return image size and component count.
 */

static void
input_init (compress_info_ptr cinfo)
{
  int dims[2];

  cinfo->input_components = 3;
  cinfo->in_color_space = CS_RGB;

  AVSfield_get_dimensions (global_in_field_ptr, dims);

  cinfo->image_width = dims[0];
  cinfo->image_height = dims[1];
  cinfo->data_precision = 8;

  next_row_in = 0;
}


/*
 * Read one row of pixels.
 */

static void
get_input_row (compress_info_ptr cinfo, JSAMPARRAY pixel_row)
{
  register JSAMPROW ptr0, ptr1, ptr2;
  register long col;
  register long width = cinfo->image_width;
  register unsigned char *pdata;
 

  pdata = AVSfield_data_ptr(global_in_field_ptr);
  pdata += next_row_in * width * 4;
  next_row_in++;

  ptr0 = pixel_row[0];
  ptr1 = pixel_row[1];
  ptr2 = pixel_row[2];
  for (col = 0; col < width; col++) {
    *ptr0++ = pdata[AVS_RED_BYTE];
    *ptr1++ = pdata[AVS_GREEN_BYTE];
    *ptr2++ = pdata[AVS_BLUE_BYTE];
    pdata += 4;
  }
}

/*
 * Finish up at the end of the file.
 */

static void
input_term (compress_info_ptr cinfo)
{
  /* no work required */
}


/*
 * The method selection routine for AVS format input.
 * Note that this must be called by the user interface before calling
 * jpeg_compress.  If multiple input formats are supported, the
 * user interface is responsible for discovering the file format and
 * calling the appropriate method selection routine.
 */

void
jselravs (compress_info_ptr cinfo)
{
  cinfo->methods->input_init = input_init;
  cinfo->methods->get_input_row = get_input_row;
  cinfo->methods->input_term = input_term;
}


/*--------------------------------------------------------------------------
 *
 * Based on:
 *
 * jerror.c			last edit:  tgl  4-Jul-91
 *
 * This file is part of the portable JPEG software.
 *
 * This file contains simple error-reporting and trace-message routines.
 * These are suitable for Unix-like systems and others where writing to
 * stderr is the right thing to do.  If the JPEG software is integrated
 * into a larger application, you may well need to replace these.
 *
 * The error_exit() routine should not return to its caller.  Within a
 * larger application, you might want to have it do a longjmp() to return
 * control to the outer user interface routine.  This should work since
 * the portable JPEG code doesn't use setjmp/longjmp.  However, this won't
 * release allocated memory or close temp files --- some bookkeeping would
 * need to be added to the memory manager module to make that work.
 *
 * These routines are used by both the compression and decompression code.
 *
 *-------------------------------------------------------------------------*/

static external_methods_ptr methods; /* saved for access to message_parm */


static void
trace_message (char *msgtext)
{
  fprintf(stderr, msgtext,
	  methods->message_parm[0], methods->message_parm[1],
	  methods->message_parm[2], methods->message_parm[3],
	  methods->message_parm[4], methods->message_parm[5],
	  methods->message_parm[6], methods->message_parm[7]);
  fprintf(stderr, "\n");
}

/*
 * Display a dialog box with error message.
 * Jump back to module's compute function.
 */
static void
error_exit (char *msgtext)
{
  AVSerror (msgtext,
	  methods->message_parm[0], methods->message_parm[1],
	  methods->message_parm[2], methods->message_parm[3],
	  methods->message_parm[4], methods->message_parm[5]);
  longjmp (error_recovery_env, 1);
}


/*
 * The method selection routine for simple error handling.
 * The system-dependent setup routine should call this routine
 * to install the necessary method pointers in the supplied struct.
 */

void
jselerror (external_methods_ptr emethods)
{
  methods = emethods;		/* save struct addr for msg parm access */

  emethods->error_exit = error_exit;
  emethods->trace_message = trace_message;

  emethods->trace_level = 0;	/* default = no tracing */
}

/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
