/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1992,  Regents  of  the
University  of  California.   Anyone may reproduce write_rect.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  write_rect.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  write_rect.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     write_rect.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
write_rect.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov

    July 30, 1992
    21 Jan 1993; bug fixes.
*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>

    /**
      * this module will read an ascii file into a rectilinear field.
      * the format of the file this module expects is:
      *
      * number_data_dimensions   // an integer
      *
      * length of dimension 1    // an integer
      * length of dimension 2    //
      *        .
      *        .
      *        .
      * length of dimension N    // an integer
      *
      * data vector length       // an integer
      *
      * X - coordinates delimited by whitespace.  the number of coords
      *  expected is the length of dimension 1.
      * Y - coordinates delimited by whitespace.  the number of coords
      *  expected is the length of dimension 2.
      *
      * this pattern repeats for each of the N data dimensions
      *
      * Data - the data is whitespace delimited ascii numbers in
      *  floating point format (ie, integer, exponential notation or
      *  decimal notation).  The data is ordered such that the
      *  first dimension varies the quickest, the second dimension the
      *  next quickest, etc.  In addition, if the data is a vector
      *  of length N, the first N items in the data portion of the file
      *  comprise the data (of vector length N) at the "first" grid
      *  location; the next N items comprise the next data vector at
      *  the next grid location, using the rules about quickest-varying
      *  coordinates above.
    **/
      

AVSinit_modules()
{
    int write_rect();
    AVSmodule_from_desc(write_rect);
}

int
write_rect()
{
    int p;
    int write_rect_p(),write_rect_init();
    
    AVSset_module_name("write rectilinear",MODULE_RENDER);
    p=AVSadd_parameter("Input File Name","string","",NULL,NULL);
    AVSconnect_widget(p,"browser");
    p=AVScreate_input_port("Output Rectilinear Field","field rectilinear float",REQUIRED);
    
    AVSset_compute_proc(write_rect_p);
/*    AVSset_init_proc(write_rect_init); */
}
#if 0
static char last_fname[128];

int
write_rect_init()
{
    strcpy(last_fname,"yo ho ho and a keg of rum!!");
}
#endif
int
write_rect_p(outf,fname)
AVSfield_float *outf;
char *fname;
{
    FILE *f;
    int num_data_dims;
    int *dims;
    float **coords;
    float *t;
    int i,j,total_num_pts,data_veclen;

    /* check to see if filename is null...return if so. */
    if ((fname == NULL) || (*fname == '\0'))
	return(0);

    f = fopen(fname,"w");
    if (f == NULL)
    {
	AVSwarning(" Unable to open the file named %s.",fname);
	return(0);
    }

    num_data_dims = outf->ndim;
    fprintf(f,"%d\n",num_data_dims);

    for (i=0,total_num_pts=1;i<num_data_dims;i++)
    {
	fprintf(f,"%d\n",outf->dimensions[i]);
	fflush(f);
	total_num_pts *= outf->dimensions[i];
    }

    /* allocate array of float pointers for coords. */
    coords = (float **)malloc(sizeof(float *)*num_data_dims);

    /* write the data vector length */
    data_veclen = outf->veclen;
    fprintf(f,"%d\n",data_veclen);
    total_num_pts *= data_veclen;

    /* set up coord pointers to write out  coords. */
    
    t = outf->points;
    for (i=0;i<num_data_dims;i++)
    {
	*(coords+i) = t;
	t += outf->dimensions[i];
    }
    
    /* write out the coords */
    for (i=0;i<num_data_dims;i++)
    {
	t = *(coords+i);
	for (j=0;j< outf->dimensions[i];j++,t++)
	{
	    fprintf(f,"%g ",*t);
	}
	fprintf(f,"\n");
    }

    /* set up to write out the data */
    
    t = outf->data;
    for (i=0;i<total_num_pts;i++,t++)
	fprintf(f,"%g\n",*t);



/* IAC CODE CHANGE :     free((char *)coords); */
     free(coords);

    fclose(f);
    
    return(1);
}
