#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>


#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int vabs_desc ()
{
   int in_port, out_port, param;
   extern int vabs_compute();

   AVSset_module_name("vabs",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");

   AVSset_compute_proc(vabs_compute);
   return(1);
}

int vclip_desc ()
{
   int in_port, out_port, param;
   extern int vclip_compute();

   AVSset_module_name("vclip",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_float_parameter("lower limit",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("upper limit",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);

   AVSset_compute_proc(vclip_compute);
   return(1);
}

int vconj_desc ()
{
   int in_port, out_port, param;
   extern int vconj_compute();

   AVSset_module_name("vconj",MODULE_FILTER);

   AVScreate_input_port("Input Image  ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image ","field 2D");

   AVSset_compute_proc(vconj_compute);
   return(1);
}

int vexp_desc ()
{
   int in_port, out_port, param;
   extern int vexp_compute();

   AVSset_module_name("vexp",MODULE_FILTER);

   AVScreate_input_port("Input Image  ","field 2D",REQUIRED);
   AVScreate_input_port("Masking Image","field 2D",OPTIONAL);

   AVScreate_output_port("Output Image ","field 2D");

   AVSadd_parameter("result","choice","result","result|result -1","|");

   AVSset_compute_proc(vexp_compute);
   return(1);
}

int vfloor_desc ()
{
   int in_port, out_port, param;
   extern int vfloor_compute();

   AVSset_module_name("vfloor",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_float_parameter("floor level",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);

   AVSset_compute_proc(vfloor_compute);
   return(1);
}

int vinvert_desc ()
{
   int in_port, out_port, param;
   extern int vinvert_compute();

   AVSset_module_name("vinvert",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");

   AVSset_compute_proc(vinvert_compute);
   return(1);
}

int vlog_desc ()
{
   int in_port, out_port, param;
   extern int vlog_compute();

   AVSset_module_name("vlog",MODULE_FILTER);

   AVScreate_input_port("Input Image  ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image ","field 2D");
   AVScreate_input_port("Masking Image","field 2D",OPTIONAL);
   AVSadd_parameter("which","choice","ln","log10|ln","|");
   AVSadd_parameter("result","choice","value","value|value+1","|");

   AVSset_compute_proc(vlog_compute);
   return(1);
}

int vnormal_desc ()
{
   int in_port, out_port, param;
   extern int vnormal_compute();

   AVSset_module_name("vnormal",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_float_parameter("Normalization",2.0,2.0,255.0);

   AVSset_compute_proc(vnormal_compute);
   return(1);
}

int vnot_desc ()
{
   int in_port, out_port, param;
   extern int vnot_compute();

   AVSset_module_name("vnot",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_float_parameter("Level",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);

   AVSset_compute_proc(vnot_compute);
   return(1);
}

float offset_param;

int voffset_desc ()
{
   int in_port, out_port, param;
   extern int voffset_compute();

   AVSset_module_name("voffset",MODULE_FILTER);

   AVScreate_input_port("Input Image  ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image ","field 2D");
   AVScreate_input_port("Masking Image","field 2D",OPTIONAL);
   AVSadd_float_parameter("Offset",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);

   AVSset_compute_proc(voffset_compute);
   return(1);
}

int vscale_desc ()
{
   int in_port, out_port, param;
   extern int vscale_compute();

   AVSset_module_name("vscale",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_float_parameter("multiply image by scale factor",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);

   AVSset_compute_proc(vscale_compute);
   return(1);
}

int vsqrt_desc ()
{
   int in_port, out_port, param;
   extern int vsqrt_compute();

   AVSset_module_name("vsqrt",MODULE_FILTER);

   AVScreate_input_port("Input Image  ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image ","field 2D");
   AVScreate_input_port("Masking Image","field 2D",OPTIONAL);

   AVSset_compute_proc(vsqrt_compute);
   return(1);
}

int vsubstit_desc ()
{
   int in_port, out_port, param;
   extern int vsubstit_compute();

   AVSset_module_name("vsubstit",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D byte scalar",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVSadd_parameter("replace","integer",0,INT_UNBOUND,INT_UNBOUND);
   AVSadd_parameter("with","integer",0,INT_UNBOUND,INT_UNBOUND);

   AVSset_compute_proc(vsubstit_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int vabs_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvabs(ki1);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vclip_compute (AVSfield *i1,AVSfield **o1,float *param1,float *param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvclip(ki1,*param1,*param2);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vconj_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvconj(ki1);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vexp_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,char *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ki2;
   char *program="vexp";
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   (void) proper_num_images(program,ki1,1,TRUE); 
   (void) proper_map_enable(program,ki1,VFF_MAP_OPTIONAL,TRUE);   

   if (i2)
   {
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
      (void) match_num_images(program,ki1,ki2,TRUE); 
      (void) match_num_bands(program,ki1,ki2,TRUE); 
      (void) match_map_enable(program,ki1,ki2,TRUE); 
      (void) matchsize(program,ki1,ki2,TRUE); 
      (void) matchtype(program,ki1,ki2,TRUE);
   }

   value=(int)lvexp(ki1,ki2,AVSchoice_number("result"),MAP(i2));

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vfloor_compute (AVSfield *i1,AVSfield **o1,float *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvfloor(ki1,*param1);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vinvert_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvinvert(ki1);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vlog_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,char *param1,char *param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ki2;
   char *program="vlog";
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
   {
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
      (void) match_num_images(program,ki1,ki2,TRUE); 
      (void) match_num_bands(program,ki1,ki2,TRUE); 
      (void) match_map_enable(program,ki1,ki2,TRUE); 
      (void) matchsize(program,ki1,ki2,TRUE); 
      (void) matchtype(program,ki1,ki2,TRUE);
   }

   value=(int)lvlog(ki1,ki2,MAP(ki2),AVSchoice_number("result"),AVSchoice_number("which"));

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vnormal_compute (AVSfield *i1,AVSfield **o1,float *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvconvert(ki1,ki1->data_storage_type,1,0,*param1,1.0,0);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vnot_compute (AVSfield *i1,AVSfield **o1,float *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvnot(ki1,*param1);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int voffset_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,float *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ki2;
   char *program="voffset";
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   (void) proper_num_images(program,ki1,1,TRUE); 
   (void) proper_map_enable(program,ki1,VFF_MAP_OPTIONAL,TRUE);

   if (i2)
   {
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
      (void) match_num_images(program,ki1,ki2,TRUE); 
      (void) match_num_bands(program,ki1,ki2,TRUE); 
      (void) match_map_enable(program,ki1,ki2,TRUE); 
      (void) matchsize(program,ki1,ki2,TRUE); 
      (void) matchtype(program,ki1,ki2,TRUE);
   }

   offset_param= *param1;

   value=(int)lvoffset(ki1,ki2,MAP(ki2));
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vscale_compute (AVSfield *i1,AVSfield **o1,float *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvconvert(ki1,ki1->data_storage_type,0,1,1.0,*param1,0);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vsqrt_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ki2;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvsqrt(ki1,ki2,(ki2==NULL) ? 0 : 1);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vsubstit_compute (AVSfield *i1,AVSfield **o1,int param1,int param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvsubstit(ki1,param1,param2);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   vabs_desc,
   vclip_desc,
   vconj_desc,
   vexp_desc,
   vfloor_desc,
   vinvert_desc,
   vlog_desc,
   vnormal_desc,
   vnot_desc,
   voffset_desc,
   vscale_desc,
   vsqrt_desc,
   vsubstit_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

