#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"

#include "avskhoros.h"

/* Currently ignoring Rectilinear Fields in AVS and ignoring
   MAP capability in Khoros  */

struct xvimage *field_to_viff (avs)
   AVSfield *avs;
{
   struct xvimage *khoros;
   int i,j,n;

   khoros=(struct xvimage *)createimage (
	MAXX(avs),
        MAXY(avs),
avs->type == AVS_TYPE_BYTE    ? VFF_TYP_1_BYTE : 
avs->type == AVS_TYPE_SHORT   ? VFF_TYP_2_BYTE :
avs->type == AVS_TYPE_INTEGER ? VFF_TYP_4_BYTE :
avs->type == AVS_TYPE_REAL    ? VFF_TYP_FLOAT  : AVS_TYPE_DOUBLE,
        1,
        avs->veclen,
	"AVS Image",
	0,
	0,
        VFF_MS_NONE,
	VFF_MAPTYP_NONE,
        avs->uniform == UNIFORM ? VFF_LOC_IMPLICIT : VFF_LOC_EXPLICIT,
        avs->uniform == UNIFORM ? 0 : avs->nspace );
  
   switch(avs->type)
   {
      case AVS_TYPE_BYTE :
         for (j=0;j<MAXY(avs);j++)
            for (i=0;i<MAXX(avs);i++)
               for (n=0;n<(avs->veclen);n++)
                  *XVIMAGE((char *)(khoros->imagedata),i,j,n,khoros->col_size,khoros->row_size)=(char)FIELD(((avs->field_union).field_data_char),avs,i,j)[n];
      break;	

      case AVS_TYPE_SHORT :
         for (j=0;j<MAXY(avs);j++)
            for (i=0;i<MAXX(avs);i++)
               for (n=0;n<(avs->veclen);n++)
                  *XVIMAGE((short *)khoros->imagedata,i,j,n,khoros->col_size,khoros->row_size)=
                     (short)FIELD(((avs->field_union).field_data_short_u),avs,i,j)[n];
      break;	
      case AVS_TYPE_INTEGER :
         for (j=0;j<MAXY(avs);j++)
            for (i=0;i<MAXX(avs);i++)
               for (n=0;n<(avs->veclen);n++)
                  *XVIMAGE((int *)khoros->imagedata,i,j,n,khoros->col_size,khoros->row_size)=(int)FIELD(((avs->field_union).field_data_int_u),avs,i,j)[n];
      break;	
      case AVS_TYPE_REAL :
         for (j=0;j<MAXY(avs);j++)
            for (i=0;i<MAXX(avs);i++)
               for (n=0;n<(avs->veclen);n++)
                  *XVIMAGE((float *)khoros->imagedata,i,j,n,khoros->col_size,khoros->row_size)=(float)FIELD(((avs->field_union).field_data_float_u),avs,i,j)[n];
       break;	
       case AVS_TYPE_DOUBLE :
          for (j=0;j<MAXY(avs);j++)
             for (i=0;i<MAXX(avs);i++)
                for (n=0;n<(avs->veclen);n++)
	           *XVIMAGE((double *)khoros->imagedata,i,j,n,khoros->col_size,khoros->row_size)=(double)FIELD(((avs->field_union).field_data_double_u),avs,i,j)[n];
       break;	
    }

   switch (avs->uniform)
   {
      case IRREGULAR : 
         khoros->location=(float *)avs->points;
      break;	
      case RECTILINEAR :
	 fprintf(stderr,"AVSkhoros port does not supprt rectilinear images - now \n");
         return(NULL);
      break;
      case UNIFORM : 
         khoros->location=NULL;
      break;
   }

   return (khoros);
}


AVSfield *viff_to_field(khoros)
   struct xvimage *khoros;
{
   AVSfield template,*avs;
   int dims[2];
   int i,j,n;

   memset((char *)&template,0,sizeof(AVSfield));
   template.ndim=2;
   template.nspace=khoros->location_dim;
   dims[0]=khoros->col_size;
   dims[1]=khoros->row_size;
   template.veclen=khoros->num_data_bands;
   template.type =
khoros->data_storage_type==VFF_TYP_1_BYTE ? AVS_TYPE_BYTE :
khoros->data_storage_type==VFF_TYP_2_BYTE ? AVS_TYPE_SHORT :
khoros->data_storage_type==VFF_TYP_4_BYTE ? AVS_TYPE_INTEGER :
khoros->data_storage_type==VFF_TYP_FLOAT  ? AVS_TYPE_REAL : AVS_TYPE_DOUBLE;
   template.size =
khoros->data_storage_type==VFF_TYP_1_BYTE ? sizeof(char) :
khoros->data_storage_type==VFF_TYP_2_BYTE ? sizeof(short) :
khoros->data_storage_type==VFF_TYP_4_BYTE ? sizeof(int) :
khoros->data_storage_type==VFF_TYP_FLOAT  ? sizeof(float) : sizeof(double);
    template.uniform =
khoros->location_type==VFF_LOC_IMPLICIT ? UNIFORM : IRREGULAR;

   if ((avs = (AVSfield *)AVSfield_alloc(&template,dims)) == NULL )
   {
      AVSwarning ("Can't malloc enough memory for output field.");
      return(0);
   }

   switch (avs->type)
   {
      case AVS_TYPE_BYTE :      
         for (j=0;j<MAXY(avs);j++)
            for (i=0;i<MAXX(avs);i++)
               for (n=0;n<(avs->veclen);n++)
                  FIELD(((avs->field_union).field_data_char),avs,i,j)[n]=
		     (char)*XVIMAGE((char *)khoros->imagedata,i,j,n,khoros->col_size,khoros->row_size);
      break;
      case AVS_TYPE_SHORT :
         for (j=0;j<MAXY(avs);j++)
            for (i=0;i<MAXX(avs);i++)
               for (n=0;n<(avs->veclen);n++)
                  FIELD(((avs->field_union).field_data_short_u),avs,i,j)[n]=
                     (short)*XVIMAGE((short *)khoros->imagedata,i,j,n,khoros->col_size,khoros->row_size);
      break;
      case AVS_TYPE_INTEGER :
         for (j=0;j<MAXY(avs);j++)
            for (i=0;i<MAXX(avs);i++)
               for (n=0;n<(avs->veclen);n++)
                  FIELD(((avs->field_union).field_data_int_u),avs,i,j)[n]=
                     (int)*XVIMAGE((int *)khoros->imagedata,i,j,n,khoros->col_size,khoros->row_size);
      break;
      case AVS_TYPE_REAL :
         for (j=0;j<MAXY(avs);j++)
            for (i=0;i<MAXX(avs);i++)
               for (n=0;n<(avs->veclen);n++)
                  FIELD(((avs->field_union).field_data_float_u),avs,i,j)[n]=
                     (float)*XVIMAGE((float *)khoros->imagedata,i,j,n,khoros->col_size,khoros->row_size);
      break;
      case AVS_TYPE_DOUBLE :
         for (j=0;j<MAXY(avs);j++)
            for (i=0;i<MAXX(avs);i++)
               for (n=0;n<(avs->veclen);n++)
                  FIELD(((avs->field_union).field_data_double_u),avs,i,j)[n]=
                     (double)*XVIMAGE((double *)khoros->imagedata,i,j,n,khoros->col_size,khoros->row_size);
      break;
   }

   if ((avs->uniform)==IRREGULAR)
      avs->points=(float *)memcpy(	(char *)avs->points,
   					(char *)khoros->location,
					(avs->nspace)*(dims[0])*(dims[1])
	 		         );

   return (avs);
}

