 /*
  * Khoros: $Id: lvinvert.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvinvert.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvinvert.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvinvert.c
 >>>>
 >>>>      Program Name: vinvert
 >>>>
 >>>> Date Last Updated: Wed Mar 27 13:25:15 1991 
 >>>>
 >>>>          Routines: lvinvert - the library call for vinvert
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvinvert - library call for vinvert
*
* Purpose:
*    
*    Inverts the gray-levels of a byte type image.
*    
*    
* Input:
*    
*         1. image -- xvimage structure
*    
*    
* Output:
*    
*         1. image -- holds the inverted image
*    
*         image is used for both the input xvimage structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*         _l_v_i_n_v_e_r_t always returns 1.
*    
*    
*
* Written By: Marcelo Teran, Ramiro Jordan
*    
*    Scott Wilson, Ron E. Neher
*    
*    
****************************************************************/


/* -library_def */
int
lvinvert(image)
struct xvimage *image;
/* -library_def_end */

/* -library_code */
{
    int  nr, nc, i;
    unsigned char *p;
 
    nr = image->col_size;
    nc = image->row_size;

    p = (unsigned char *)(image->imagedata);

    for (i=0; i<nr*nc*image->num_data_bands; i++)
    {
        *p = 255 - *p;  /* Invert gray levels */
         p++;
    }

    return(1);
}
/* -library_code_end */
