 /*
  * Khoros: $Id: lvlpr.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvlpr.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvlpr.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvlpr.c
 >>>>
 >>>>      Program Name: vlpr
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:10:11 1991 
 >>>>
 >>>>          Routines: lvlpr - the library call for vlpr
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
struct ostrike
{
    char *l1;
    char *l2;
    char *l3;
    char *l4;
    char *l5;
    int s1,s2,s3,s4,s5;  /* OK TO PRINT flags */
};

/* Set up the grey-scale strings */
/* The overstrike characters are generated according 
   to Gonzales and Wintz, "Digital Image Processing", p389. */
char map1[33] = "MMMMMMHHHHHXHXOZWMNOS=I*++=:-.-";
char map2[33] = "WWWWWW###*++----     =  -   -  ";
char map3[33] = "####0O+-                       ";
char map4[33] = "O0O                            ";
char map5[33] = "+                              ";
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvlpr - library call for vlpr
*
* Purpose:
*    
*    Format a Khoros image for output on a standard line printer
*    
*    
* Input:
*    
*    file           file descriptor to write output to
*    
*    image          pointer to xvimage structure to be processed
*    
*    width          width of lineprinter in characters
*    
*    
* Output:
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Mark Young, Mike Lang
*    
*    
****************************************************************/


/* -library_def */
int
lvlpr(file, image, width)
FILE *file;
struct xvimage *image;
int  width;
/* -library_def_end */

/* -library_code */
{

  char *malloc();
  int rows,cols,i,j,nstrips;
  struct ostrike line;


  /* See if we have an image of the proper type */
  if (image->data_storage_type != VFF_TYP_1_BYTE)
  {
      (void) fprintf(stderr,"\n\nlvlpr: Can ONLY operate on byte ");
      (void) fprintf(stderr,"images (VFF_TYP_1_BYTE)!\n\n");
      return(0);
  }

  line.l1 = malloc((unsigned int)width+1);
  line.l2 = malloc((unsigned int)width+1);
  line.l3 = malloc((unsigned int)width+1);
  line.l4 = malloc((unsigned int)width+1);
  line.l5 = malloc((unsigned int)width+1);
  if (line.l1 == NULL || line.l2 == NULL || line.l3 == NULL ||
      line.l4 == NULL || line.l5 == NULL )
  {
      (void) fprintf(stderr,"\n\nlvlpr: Not enough memory for temporary ");
      (void) fprintf(stderr,"line arrays!\n\n");
      return(0);
  }

  rows = image->col_size;
  cols = image->row_size;

  nstrips = (cols+width-1)/width;
  for (i=0; i < nstrips; i++)
  {
      for (j=0; j<rows;j++)
      {
          load_line(image,i,j,width,cols,&line);
          if (line.s1) (void) fprintf(file,"%s\r",line.l1); 
          if (line.s2) (void) fprintf(file,"%s\r",line.l2);
          if (line.s2) (void) fprintf(file,"%s\r",line.l3);
          if (line.s4) (void) fprintf(file,"%s\r",line.l4);
          if (line.s5) (void) fprintf(file,"%s\r",line.l5);
          (void) fprintf(file,"\n");
      }
      (void) fprintf(file,"\f");  /* Form feed to start next strip */
  }

  free(line.l1); free(line.l2); free(line.l3); 
  free(line.l4); free(line.l5);

  return(1);
}


/*********************************************************
                        load_line
*********************************************************/

load_line(image,strip,row,width,cols,lptr)

struct xvimage *image;
int strip,row,width,cols;
struct ostrike *lptr;
{
     int i,k,n;
     unsigned char c;

     /* Load the output line with the overstrike data */
     lptr->s1 = 0;
     lptr->s2 = 0;
     lptr->s3 = 0;
     lptr->s4 = 0;
     lptr->s5 = 0;
     if ((strip+1)*width > cols) n = cols-strip*width;
     else n = width;
     for (i=0; i<n; i++)
     {
         c = image->imagedata[(i+width*strip)+row*cols];
         k = c >> 3;
         lptr->l1[i] = map1[k];
         lptr->l2[i] = map2[k];
         lptr->l3[i] = map3[k];
         lptr->l4[i] = map4[k];
         lptr->l5[i] = map5[k];
         if (lptr->l1[i] != ' ') lptr->s1 = 1;
         if (lptr->l2[i] != ' ') lptr->s2 = 1;
         if (lptr->l3[i] != ' ') lptr->s3 = 1;
         if (lptr->l4[i] != ' ') lptr->s4 = 1;
         if (lptr->l5[i] != ' ') lptr->s5 = 1;
     }
     lptr->l1[n] = '\0';
     lptr->l2[n] = '\0';
     lptr->l3[n] = '\0';
     lptr->l4[n] = '\0';
     lptr->l5[n] = '\0';
     trim(lptr->l1,n);
     trim(lptr->l2,n);
     trim(lptr->l3,n);
     trim(lptr->l4,n);
     trim(lptr->l5,n);
}


/*********************************************************
                        trim
*********************************************************/

trim(c,width)

char *c;
int width;
{
    /* Strip blanks from end of string */
    char *c1;

    c1 = c + width - 1;
    while (*c1 == ' ') *c1-- = '\0';
}
/* -library_code_end */
