#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int vlpr_desc ()
{
   int in_port, out_port, param;
   extern int vlpr_compute();

   AVSset_module_name("vlpr",MODULE_RENDER);

   AVScreate_input_port("Input Image","field 2D byte",REQUIRED);
   AVSadd_parameter("printer width","integer",80,1,160);
   ADD_FILE;

   AVSset_compute_proc(vlpr_compute);
   return(1);
}

int vpostscr_desc ()
{
   int in_port, out_port, param;
   extern int vpostscr_compute();

   AVSset_module_name("vpostscr",MODULE_RENDER);

   AVScreate_input_port("Input Image","field 2D byte",REQUIRED);
   AVSadd_float_parameter("width (in)",4.0,0.1,11.0);
   AVSadd_float_parameter("height (in)",4.0,0.1,11.0);
   AVSadd_float_parameter("x offset",0.0,0.0,10.0);
   AVSadd_float_parameter("y offset",0.0,0.0,10.0);
   AVSadd_parameter("photoNEGATIVE","boolean",0,0,1);
   AVSadd_parameter("force page","boolean",0,0,1);
   AVSadd_parameter("color-to-grey","boolean",0,0,1);
   AVSadd_parameter("landscape","boolean",0,0,1);
   ADD_FILE;

   AVSset_compute_proc(vpostscr_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int vlpr_compute (AVSfield *i1,int param1, char *param2)
{
   int value;
   struct xvimage *ki1;
   FILE *fp;
   char *program="vlpr";

   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   FILE_OPEN(fp,param2);

   (void) proper_num_images(program,ki1,1,TRUE); 
   (void) proper_num_bands(program,ki1,1,TRUE); 
   (void) propertype(program,ki1,VFF_TYP_1_BYTE,TRUE); 
   (void) proper_map_enable(program,ki1,VFF_MAP_OPTIONAL,TRUE);

   value=(int)lvlpr(fp,ki1,param1);
 
   FILE_CLOSE(fp,param2); 
 
   return (value);
}
 
float def_width;
float def_height;
float def_xoffset;
float def_yoffset;

int vpostscr_compute (AVSfield *i1,float *param1,float *param2,float *param3,float *param4,int param5,int param6,int param7,int param8, char *fname)
{
   int value;
   struct xvimage *image;
   FILE *fp;
   char *program="vpostscr";

   if (i1)
      if ((image=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   FILE_OPEN(fp,fname);

   proper_num_images(program,image,1,TRUE);
   if (!proper_num_bands(program,image,1, FALSE) &&
       !proper_num_bands(program,image,3, FALSE))
   {
      fprintf(stderr,"vpostscr: Image must have either 1 or 3 bands of data\n");
      return(0);
   }
   if (propertype(program,image,VFF_TYP_2_BYTE,FALSE) ||
       propertype(program,image,VFF_TYP_4_BYTE,FALSE) ||
       propertype(program,image,VFF_TYP_FLOAT,FALSE) ||
       propertype(program,image,VFF_TYP_COMPLEX,FALSE)) 
   {
      fprintf(stderr, "Image data type should be BIT or BYTE\n");
      return(0);
   }

   if (param7)
   {
      if (image->map_enable == VFF_MAP_FORCE &&
          image->map_scheme == VFF_MS_ONEPERBAND ||
          image->map_scheme == VFF_MS_SHARED &&
          image->map_row_size == 3 &&
          image->map_storage_type == VFF_MAPTYP_1_BYTE)
      {
          if(!lvmsquish(image, TRUE, 1))
          {
             fprintf(stderr, "lvmsquish Failed\n");
             return(0);
          }
      }
   }

   def_width= *param1;
   def_height= *param2;
   def_xoffset= *param3;
   def_yoffset= *param4;
 
   value=(int)lvpostscr(fp,image,param6,param5,1,1,1,1,param8);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   vlpr_desc,
   vpostscr_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

