#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"

#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int dfft1d_desc ()
{
   int in_port, out_port, param;
   extern int dfft1d_compute();

   AVSset_module_name("dfft1d",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("scale","choice","1","1,1/N,1/sqrt(N)",",");
   AVSadd_parameter("center","choice","center","don't center,center",",");
   AVSadd_parameter("processing","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dfft1d_compute);
   return(1);
}

int dfht_desc ()
{
   int in_port, out_port, param;
   extern int dfht_compute();

   AVSset_module_name("dfht",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("scale","choice","1","1,1/N,1/sqrt(N)",",");
   AVSadd_parameter("center","choice","center","don't center,center",",");
   AVSadd_parameter("processing","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dfht_compute);
   return(1);
}

int dhart1d_desc ()
{
   int in_port, out_port, param;
   extern int dhart1d_compute();

   AVSset_module_name("dhart1d",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("scale","choice","1","1,1/N,1/sqrt(N)",",");
   AVSadd_parameter("center","choice","center","don't center,center",",");
   AVSadd_parameter("processing","choice","down vectors","down vectors,across bands",",");
   AVSadd_parameter("transform","choice","inverse","forward",",");

   AVSset_compute_proc(dhart1d_compute);
   return(1);
}

int difft1d_desc ()
{
   int in_port, out_port, param;
   extern int difft1d_compute();

   AVSset_module_name("difft1d",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("scale","choice","1","1,1/N,1/sqrt(N)",",");
   AVSadd_parameter("center","choice","center","don't center,center",",");
   AVSadd_parameter("processing","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(difft1d_compute);
   return(1);
}

int dihart1d_desc ()
{
   int in_port, out_port, param;
   extern int dihart1d_compute();

   AVSset_module_name("dihart1d",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("scale","choice","1","1,1/N,1/sqrt(N)",",");
   AVSadd_parameter("center","choice","center","don't center,center",",");
   AVSadd_parameter("processing","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dihart1d_compute);
   return(1);
}

int dmpp_desc ()
{
   int in_port, out_port, param;
   extern int dmpp_compute();

   AVSset_module_name("dmpp",MODULE_FILTER);

   AVScreate_input_port("Input file  ","field 2D",REQUIRED);
   AVScreate_output_port("Output file ","field 2D");
   AVSadd_parameter("output","choice","magnitude","magnitude,power,phase",",");
   AVSadd_parameter("scale","choice","magnitude","magnitude,log(magnitude),log(magnitude+1),ln(magnitude),ln(magnitude+1)",",");
   AVSadd_parameter("units","choice","radians","radians,degrees",",");
   AVSadd_parameter("phase","choice","-pi to pi","-pi to pi,0 to 2pi",",");
   AVSadd_parameter("processing","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dmpp_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int dfft1d_compute (AVSfield *i1,AVSfield **o1,char *param1,char *param2,char *param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldfft1d(ki1,AVSchoice_number("center"),AVSchoice_number("scale"),AVSchoice_number("processing"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dfht_compute (AVSfield *i1,AVSfield **o1,char *param1,char *param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldfht(ki1,AVSchoice_number("scale"),AVSchoice_number("processing"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dhart1d_compute (AVSfield *i1,AVSfield **o1,char *param1,char *param2,char *param3,char *param4)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldhart1d(ki1,1,AVSchoice_number("center"),AVSchoice_number("scale"),AVSchoice_number("processing"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int difft1d_compute (AVSfield *i1,AVSfield **o1,char *param1,char *param2,char *param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldifft1d(ki1,AVSchoice_number("center"),AVSchoice_number("scale"),AVSchoice_number("processing"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dihart1d_compute (AVSfield *i1,AVSfield **o1,char *param1,char *param2,char *param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldhart1d(ki1,0,AVSchoice_number("center"),AVSchoice_number("scale"),AVSchoice_number("processing"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dmpp_compute (AVSfield *i1,AVSfield **o1,char *param1,char *param2,char *param3,char *param4)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldmpp(ki1,AVSchoice_number("scale"),AVSchoice_number("output"),AVSchoice_number("phase"),AVSchoice_number("units"),AVSchoice_number("processing"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   dfft1d_desc,
   dfht_desc,
   dhart1d_desc,
   difft1d_desc,
   dihart1d_desc,
   dmpp_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

