C                  INTERNATIONAL AVS CENTER
C        (This disclaimer must remain at the top of all files)
C
C WARRANTY DISCLAIMER
C
C This module and the files associated with it are distributed free of charge.
C It is placed in the public domain and permission is granted for anyone to use,
C duplicate, modify, and redistribute it unless otherwise noted.  Some modules
C may be copyrighted.  You agree to abide by the conditions also included in
C the AVS Licensing Agreement, version 1.0, located in the main module
C directory located at the International AVS Center ftp site and to include
C the AVS Licensing Agreement when you distribute any files downloaded from
C that site.
C
C The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module provide absolutely
C NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
C the quality and performance of this software is with the user.  IN NO EVENT
C WILL The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module BE LIABLE TO
C ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
C WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
C SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.
C
C This AVS module and associated files are public domain software unless
C otherwise noted.  Permission is hereby granted to do whatever you like with
C it, subject to the conditions that may exist in copyrighted materials. Should
C you wish to make a contribution toward the improvement, modification, or
C general performance of this module, please send us your comments:  why you
C liked or disliked it, how you use it, and most important, how it helps your
C work. We will receive your comments at avs@ncsc.org.
C
C Please send AVS module bug reports to avs@ncsc.org.
C
C
C			Copyright (c) 1995 by
C			Kubota Graphics Technology Inc.
C			All Rights Reserved
C	
C	This software comprises unpublished confidential information of
C	Kubota Graphics Technology Inc. and may not be used, copied or
C	made available to anyone, except in accordance with the license
C	under which it is furnished.
C	
C       module name   :  2D bounds
C       file name     :  bounds.f
C       exe           :  bounds
C
C       creates bounding box of 2D field.
C	
C **********************************************************************
C  Module Description
C **********************************************************************
      integer function Mesh_2d_desc()
C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
      integer in_port,out_port,param
      external Mesh_2d_compute
      integer Mesh_2d_compute

C Set the module name and type
      call AVSset_module_name('2D bounds', 'mapper')
      call AVSset_module_flags(single_arg_data)

C Create an input port (name,type)
      in_port = AVScreate_input_port('field input'
     *          ,'field 2D 3-space real irregular',REQUIRED)

C Create an output port (name,type)
      out_port = AVScreate_output_port('2D bounds','geom')
      call AVSautofree_output(out_port)
      
C Add parameter
      param = AVSadd_parameter('On/Off', 'boolean',1,0,1)
      param = AVSadd_parameter
     &      ('mesh/outline', 'choice','mesh','mesh@outline','@')
      
      call AVSset_compute_proc(Mesh_2d_compute)

      Mesh_2d_desc = 1
      return
      end
C **********************************************************************
C  Compute routine
C **********************************************************************
      integer function Mesh_2d_compute(input1,output1,ionoff,imesh)
C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
C   IAC CODE CHANGE :       include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'
 
#ifdef OSF1
      integer*8 input1,output1
      integer*8 pcoords
      integer*8 obj1
#else
      integer input1,output1
      integer pcoords
      integer obj1
#endif
      integer idim,dims(2),ni,nj,nvlen
      integer ionoff
      character*(*) imesh

      real verts(1)
#ifdef OSF1
      integer*8 pverts,overts
#else
      integer pverts,overts
#endif

C Visible/Invisible
      if( ionoff .eq. 0 ) then
         obj1 = GEOM_create_obj(GEOM_POLYTRI,GEOM_NULL)
         output1 = GEOM_init_edit_list(output1)
         call GEOM_edit_geometry(output1,'2d bounds',obj1)
         call GEOM_destroy_obj(obj1)
         Mesh_2d_compute=1
         return
      endif

C Get input data
      idim = AVSfield_get_dimensions(input1,dims)
      ni = dims(1)
      nj = dims(2)
      pcoords = AVSfield_points_ptr(input1)
 
C Create obj
      obj1 = GEOM_create_obj(GEOM_POLYTRI,GEOM_NULL)
      num = AVSchoice_number('mesh/outline',imesh)
 
C Mesh
      if( num .eq. 1) then
         isize = ni*(nj-1) + nj*(ni-1) 
#ifdef OSF1
         call falloc(isize*6,4,0,verts,pverts,overts)
#else
         call ffalloc(isize*6,4,0,verts,pverts,overts)
#endif
         call iregmesh(verts(overts+1),ni,nj,%val(pcoords),inum)
         isize = inum
      else
C Outline 
         isize = (ni+nj-2) * 2
#ifdef OSF1
         call falloc(isize*6,4,0,verts,pverts,overts)
#else
         call ffalloc(isize*6,4,0,verts,pverts,overts)
#endif
         call iregout(verts(overts+1),ni,nj,%val(pcoords),inum)
         isize = inum
      endif
 
C Create line object
      call GEOM_add_disjoint_line
     &     (obj1,verts(overts+1),GEOM_NULL,isize*2,GEOM_COPY_DATA)
C Set geometry
      output1 = GEOM_init_edit_list(output1)
      call GEOM_edit_geometry(output1,'2d bounds',obj1)
      call GEOM_destroy_obj(obj1)
#ifdef OSF1
      call free(pverts)
#else
      call ffree(pverts)
#endif
         
      Mesh_2d_compute=1
      return
      end
C **********************************************************************
C  Initialization for modules contained in this file.
C **********************************************************************
      subroutine AVSinit_modules
C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
      external Mesh_2d_desc
      integer Mesh_2d_desc
      call AVSmodule_from_desc(Mesh_2d_desc)
      end
C **********************************************************************
C  User routine 
C **********************************************************************
C   create mesh line
C
      subroutine iregmesh(verts,nnx,nny,xyz,inum)
      real verts(6,*),xyz(nnx,nny,*)
      integer nnx,nny
 
C j~j+1 line
      inum = 0
      do i = 1,nnx
       do j = 1,nny-1
        inum = inum+1
        verts(1,inum) = xyz(i,j,1)
        verts(2,inum) = xyz(i,j,2)
        verts(3,inum) = xyz(i,j,3)
        verts(4,inum) = xyz(i,j+1,1)
        verts(5,inum) = xyz(i,j+1,2)
        verts(6,inum) = xyz(i,j+1,3)
       enddo
      enddo
C i~i+1 line
      do j = 1,nny
       do i = 1,nnx-1
        inum = inum+1
        verts(1,inum) = xyz(i,j,1)
        verts(2,inum) = xyz(i,j,2)
        verts(3,inum) = xyz(i,j,3)
        verts(4,inum) = xyz(i+1,j,1)
        verts(5,inum) = xyz(i+1,j,2)
        verts(6,inum) = xyz(i+1,j,3)
       enddo
      enddo
      return
      end
C
C Outline
C
      subroutine iregout(verts,nnx,nny,xyz,inum)
      real*4 verts(6,*),xyz(nnx,nny,*)
      integer nnx,nny,inum
 
C j~j+1 
      inum = 0
      do j = 1,nny-1
        inum = inum + 1
        verts(1,inum) = xyz(1,j,1)
        verts(2,inum) = xyz(1,j,2)
        verts(3,inum) = xyz(1,j,3)
        verts(4,inum) = xyz(1,j+1,1)
        verts(5,inum) = xyz(1,j+1,2)
        verts(6,inum) = xyz(1,j+1,3)
      enddo
      do j = 1,nny-1
        inum = inum + 1
        verts(1,inum) = xyz(nnx,j,1)
        verts(2,inum) = xyz(nnx,j,2)
        verts(3,inum) = xyz(nnx,j,3)
        verts(4,inum) = xyz(nnx,j+1,1)
        verts(5,inum) = xyz(nnx,j+1,2)
        verts(6,inum) = xyz(nnx,j+1,3)
      enddo
C i~i+1
      do i = 1,nnx-1
        inum = inum + 1
        verts(1,inum) = xyz(i,1,1)
        verts(2,inum) = xyz(i,1,2)
        verts(3,inum) = xyz(i,1,3)
        verts(4,inum) = xyz(i+1,1,1)
        verts(5,inum) = xyz(i+1,1,2)
        verts(6,inum) = xyz(i+1,1,3)
      enddo
      do i = 1,nnx-1
        inum = inum + 1
        verts(1,inum) = xyz(i,nny,1)
        verts(2,inum) = xyz(i,nny,2)
        verts(3,inum) = xyz(i,nny,3)
        verts(4,inum) = xyz(i+1,nny,1)
        verts(5,inum) = xyz(i+1,nny,2)
        verts(6,inum) = xyz(i+1,nny,3)
      enddo

      return
      end
