C                  INTERNATIONAL AVS CENTER
C        (This disclaimer must remain at the top of all files)
C
C WARRANTY DISCLAIMER
C
C This module and the files associated with it are distributed free of charge.
C It is placed in the public domain and permission is granted for anyone to use,
C duplicate, modify, and redistribute it unless otherwise noted.  Some modules
C may be copyrighted.  You agree to abide by the conditions also included in
C the AVS Licensing Agreement, version 1.0, located in the main module
C directory located at the International AVS Center ftp site and to include
C the AVS Licensing Agreement when you distribute any files downloaded from
C that site.
C
C The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module provide absolutely
C NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
C the quality and performance of this software is with the user.  IN NO EVENT
C WILL The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module BE LIABLE TO
C ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
C WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
C SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.
C
C This AVS module and associated files are public domain software unless
C otherwise noted.  Permission is hereby granted to do whatever you like with
C it, subject to the conditions that may exist in copyrighted materials. Should
C you wish to make a contribution toward the improvement, modification, or
C general performance of this module, please send us your comments:  why you
C liked or disliked it, how you use it, and most important, how it helps your
C work. We will receive your comments at avs@ncsc.org.
C
C Please send AVS module bug reports to avs@ncsc.org.
C
C
C			Copyright (c) 1995 by
C			Kubota Graphics Technology Inc.
C			All Rights Reserved
C	
C	This software comprises unpublished confidential information of
C	Kubota Graphics Technology Inc. and may not be used, copied or
C	made available to anyone, except in accordance with the license
C	under which it is furnished.
C
C	
C       module name   :  CFD object contour 
C       file name     :  objectcont.f
C       exe           :  objectcont
C
C       This module create the contour object 
C                                from the flag data.
C
C       2-vector input data
C          component 1 : scalar value (for color)
C                    2 : flag data
C 
C          1 = fluid node 
C          0 = non-fluid node (obstacle)
C
C          1---1---1             
C          |   |   |            
C          1---0---0  ----->       +---+
C          |   |   |               |   |  : contour 
C          1---0---0               +---+
C
C
C **********************************************************************
C  Module Description
C **********************************************************************
       integer function Create_GEOM_desc()
C   IAC CODE CHANGE :        include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
C   IAC CODE CHANGE :        include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'
       integer in_port, out_port, param, iresult
       external Create_GEOM_compute
       integer Create_GEOM_compute

C Set the module name
       call AVSset_module_name('CFD object contour', 'mapper')
       call AVSset_module_flags(single_arg_data)

C Create an input port
       in_port = AVScreate_input_port('input1', 
     $    'field 3D 3-space 2-vector float irregular', REQUIRED)
       in_port2 = AVScreate_input_port
     $            ('color','colormap',REQUIRED)

C Create an output port
       out_port = AVScreate_output_port('output1', 'geom')

C Add parameter
       param = AVSadd_parameter('On/Off','boolean',1,0,1)

       call AVSset_compute_proc(Create_GEOM_compute)
       Create_GEOM_desc = 1
       return
       end
C **********************************************************************
C  Module Compute Routine
C **********************************************************************
       integer function Create_GEOM_compute
     *                 (input1, colormap, output1, ionoff)
C   IAC CODE CHANGE :        include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
C   IAC CODE CHANGE :        include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'
C DEC Alpha/osf1
#ifdef OSF1
       integer*8 input1,colormap
       integer*8 output1,obj0
       integer*8 pfield,pcoords
#else
       integer input1,colormap
       integer output1,obj0
       integer pfield,pcoords
#endif
       integer idim,dims(3),ni,nj,nk

       integer size
       real lower,upper
       real hue(256),sat(256),val(256),alpha(256)
       real color_tbl(3,256)

C Switch on/off
       if( ionoff.eq.0 ) then
          obj0 = geom_create_obj(GEOM_POLYTRI,GEOM_NULL)
          output1 = geom_init_edit_list(output1)
          call geom_edit_geometry(output1,'output1',obj0)
          call geom_destroy_obj(obj0)
          Create_GEOM_compute = 1
          return
      endif

C Create object
       obj0 = geom_create_obj(GEOM_POLYHEDRON,GEOM_NULL)

C input dimensions
       idim = AVSfield_get_dimensions(input1,dims)
       ni = dims(1)
       nj = dims(2)
       nk = dims(3)
       pfield = AVSfield_data_ptr(input1)
       pcoords = AVSfield_points_ptr(input1)

       write(6,*) ' ni,nj,nk = ',ni,nj,nk

        iresult = AVScolormap_get
     $      (colormap,256, size, lower, upper, hue, sat, val, alpha)

       do L=1,256
         call hsv_to_rgb(color_tbl(1,L),color_tbl(2,L),
     $                   color_tbl(3,L),hue(L),sat(L),val(L))
       enddo

       factor = 0.0
       if((upper-lower).ne.0.) then
         factor = 1/(upper-lower)
       endif

C Create Geometry
       call make_geom(%val(pfield),%val(pcoords),ni,nj,nk,obj0
     $               ,color_tbl,lower,factor)

       call geom_gen_normals(obj0,0)
       output1 = geom_init_edit_list(output1)
       call geom_edit_geometry(output1, 'output1', obj0)
       call geom_destroy_obj(obj0)
       Create_GEOM_compute = 1
       return
       end

C **********************************************************************
C  Initialization for modules contained in this file.
C **********************************************************************
       subroutine AVSinit_modules
C   IAC CODE CHANGE :        include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
C   IAC CODE CHANGE :        include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'
       external Create_GEOM_desc
       integer Create_GEOM_desc
       call AVSmodule_from_desc(Create_GEOM_desc)
       end

C **********************************************************************
C  User routine 
C **********************************************************************
       subroutine make_geom
     *           (data,xyz,ni,nj,nk,obj,color_tbl,lower,factor)
       real data(2,ni,nj,nk),xyz(ni,nj,nk,3)
#ifdef OSF1
       integer*8 obj
#else
       integer obj
#endif
       real verts(3,4)
       real color_tbl(3,256)
       real lower,factor
C
C data(1,ni,nj,nk)  : scalar data (for contour map) 
C data(2,ni,nj,nk)  : flag data of node
C
        do k = 1,nk-1
         do j = 1,nj-1
          do i = 1,ni-1
            if((data(2,i  ,j  ,k  ).eq.0.) .and.
     &         (data(2,i+1,j  ,k  ).eq.0.) .and.
     &         (data(2,i  ,j+1,k  ).eq.0.) .and.
     &         (data(2,i  ,j  ,k+1).eq.0.) .and.
     &         (data(2,i+1,j+1,k  ).eq.0.) .and.
     &         (data(2,i  ,j+1,k+1).eq.0.) .and.
     &         (data(2,i+1,j+1,k+1).eq.0.)) then
              call make_box(verts,i,j,k,xyz,ni,nj,nk
     &                     ,obj,data,color_tbl,lower,factor)
            endif
          enddo
         enddo
        enddo
       return
       end

C **********************************************************************
C  make box 
C **********************************************************************
       subroutine make_box(verts,i,j,k,xyz,ni,nj,nk,obj,data
     $                    ,color_tbl,pmin,fact)
C   IAC CODE CHANGE :        include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'
       real verts(3,4),xyz(ni,nj,nk,3),data(2,ni,nj,nk)
#ifdef OSF1
       integer*8 obj
#else
       integer obj
#endif
       real color_tbl(3,256)
       real pmin,fact
       real colors(3,4)

       if( k .ge. 2 ) then
         f1 = data(2,i  ,j  ,k-1)
         f2 = data(2,i+1,j  ,k-1)
         f3 = data(2,i  ,j+1,k-1)
         f4 = data(2,i+1,j+1,k-1)
         if((f1.eq.0.) .and.
     &      (f2.eq.0.) .and. 
     &      (f3.eq.0.) .and. 
     &      (f4.eq.0.)) goto 11
       endif

       index1 = 255*max(0.,min(1.,(data(1,i,j,k)-pmin)*fact))+1
       index2 = 255*max(0.,min(1.,(data(1,i+1,j,k)-pmin)*fact))+1
       index3 = 255*max(0.,min(1.,(data(1,i+1,j+1,k)-pmin)*fact))+1
       index4 = 255*max(0.,min(1.,(data(1,i,j+1,k)-pmin)*fact))+1


       do L = 1,3
         verts(L,1) = xyz(i  ,j  ,k  ,L)
         verts(L,2) = xyz(i+1,j  ,k  ,L)
         verts(L,3) = xyz(i+1,j+1,k  ,L)
         verts(L,4) = xyz(i  ,j+1,k  ,L)
         colors(L,1) = color_tbl(L,index1)
         colors(L,2) = color_tbl(L,index2)
         colors(L,3) = color_tbl(L,index3)
         colors(L,4) = color_tbl(L,index4)
       enddo
       call GEOM_add_disjoint_polygon(obj,verts,GEOM_NULL
     &            ,colors,4,GEOM_NOT_SHARED,GEOM_COPY_DATA)
  11   continue
       if( k .le. nk-2 ) then
         f1 = data(2,i  ,j  ,k+2)
         f2 = data(2,i+1,j  ,k+2)
         f3 = data(2,i  ,j+1,k+2)
         f4 = data(2,i+1,j+1,k+2)
         if((f1.eq.0.) .and.
     &      (f2.eq.0.) .and. 
     &      (f3.eq.0.) .and. 
     &      (f4.eq.0.)) goto 12
       endif

       index1 = 255*max(0.,min(1.,(data(1,i,j,k+1)-pmin)*fact))+1
       index2 = 255*max(0.,min(1.,(data(1,i+1,j,k+1)-pmin)*fact))+1
       index3 = 255*max(0.,min(1.,(data(1,i+1,j+1,k+1)-pmin)*fact))+1
       index4 = 255*max(0.,min(1.,(data(1,i,j+1,k+1)-pmin)*fact))+1

       do L = 1,3
         verts(L,1) = xyz(i  ,j  ,k+1,L)
         verts(L,2) = xyz(i+1,j  ,k+1,L)
         verts(L,3) = xyz(i+1,j+1,k+1,L)
         verts(L,4) = xyz(i  ,j+1,k+1,L)
         colors(L,1) = color_tbl(L,index1)
         colors(L,2) = color_tbl(L,index2)
         colors(L,3) = color_tbl(L,index3)
         colors(L,4) = color_tbl(L,index4)
       enddo
       call GEOM_add_disjoint_polygon(obj,verts,GEOM_NULL
     &            ,colors,4,GEOM_NOT_SHARED,GEOM_COPY_DATA)
  12   continue
       if( j .ge. 2 ) then
         f1 = data(2,i  ,j-1,k  )
         f2 = data(2,i+1,j-1,k  )
         f3 = data(2,i  ,j-1,k+1)
         f4 = data(2,i+1,j-1,k+1)
         if((f1.eq.0.) .and.
     &      (f2.eq.0.) .and. 
     &      (f3.eq.0.) .and. 
     &      (f4.eq.0.)) goto 13
       endif

       index1 = 255*max(0.,min(1.,(data(1,i  ,j  ,k  )-pmin)*fact))+1
       index2 = 255*max(0.,min(1.,(data(1,i+1,j  ,k  )-pmin)*fact))+1
       index3 = 255*max(0.,min(1.,(data(1,i+1,j  ,k+1)-pmin)*fact))+1
       index4 = 255*max(0.,min(1.,(data(1,i  ,j  ,k+1)-pmin)*fact))+1

       do L = 1,3
         verts(L,1) = xyz(i  ,j  ,k  ,L)
         verts(L,2) = xyz(i+1,j  ,k  ,L)
         verts(L,3) = xyz(i+1,j  ,k+1,L)
         verts(L,4) = xyz(i  ,j  ,k+1,L)
         colors(L,1) = color_tbl(L,index1)
         colors(L,2) = color_tbl(L,index2)
         colors(L,3) = color_tbl(L,index3)
         colors(L,4) = color_tbl(L,index4)
       enddo
       call GEOM_add_disjoint_polygon(obj,verts,GEOM_NULL
     &            ,colors,4,GEOM_NOT_SHARED,GEOM_COPY_DATA)
  13   continue
       if( j .le. nj-2 ) then
         f1 = data(2,i  ,j+2,k  )
         f2 = data(2,i+1,j+2,k  )
         f3 = data(2,i  ,j+2,k+1)
         f4 = data(2,i+1,j+2,k+1)
         if((f1.eq.0.) .and.
     &      (f2.eq.0.) .and. 
     &      (f3.eq.0.) .and. 
     &      (f4.eq.0.)) goto 14
       endif

       index1 = 255*max(0.,min(1.,(data(1,i  ,j+1,k  )-pmin)*fact))+1
       index2 = 255*max(0.,min(1.,(data(1,i+1,j+1,k  )-pmin)*fact))+1
       index3 = 255*max(0.,min(1.,(data(1,i+1,j+1,k+1)-pmin)*fact))+1
       index4 = 255*max(0.,min(1.,(data(1,i  ,j+1,k+1)-pmin)*fact))+1

       do L = 1,3
         verts(L,1) = xyz(i  ,j+1,k  ,L)
         verts(L,2) = xyz(i+1,j+1,k  ,L)
         verts(L,3) = xyz(i+1,j+1,k+1,L)
         verts(L,4) = xyz(i  ,j+1,k+1,L)
         colors(L,1) = color_tbl(L,index1)
         colors(L,2) = color_tbl(L,index2)
         colors(L,3) = color_tbl(L,index3)
         colors(L,4) = color_tbl(L,index4)
       enddo
       call GEOM_add_disjoint_polygon(obj,verts,GEOM_NULL
     &            ,colors,4,GEOM_NOT_SHARED,GEOM_COPY_DATA)
  14   continue
       if( i .ge. 2 ) then
         f1 = data(2,i-1,j  ,k  )
         f2 = data(2,i-1,j+1,k  )
         f3 = data(2,i-1,j  ,k+1)
         f4 = data(2,i-1,j+1,k+1)
         if((f1.eq.0.) .and.
     &      (f2.eq.0.) .and. 
     &      (f3.eq.0.) .and. 
     &      (f4.eq.0.)) goto 15
       endif

       index1 = 255*max(0.,min(1.,(data(1,i  ,j  ,k  )-pmin)*fact))+1
       index2 = 255*max(0.,min(1.,(data(1,i  ,j+1,k  )-pmin)*fact))+1
       index3 = 255*max(0.,min(1.,(data(1,i  ,j+1,k+1)-pmin)*fact))+1
       index4 = 255*max(0.,min(1.,(data(1,i  ,j  ,k+1)-pmin)*fact))+1

       do L = 1,3
         verts(L,1) = xyz(i  ,j  ,k  ,L)
         verts(L,2) = xyz(i  ,j+1,k  ,L)
         verts(L,3) = xyz(i  ,j+1,k+1,L)
         verts(L,4) = xyz(i  ,j  ,k+1,L)
         colors(L,1) = color_tbl(L,index1)
         colors(L,2) = color_tbl(L,index2)
         colors(L,3) = color_tbl(L,index3)
         colors(L,4) = color_tbl(L,index4)
       enddo
       call GEOM_add_disjoint_polygon(obj,verts,GEOM_NULL
     &            ,colors,4,GEOM_NOT_SHARED,GEOM_COPY_DATA)
  15   continue
       if( i .le. ni-2 ) then
         f1 = data(2,i+2,j  ,k  )
         f2 = data(2,i+2,j+1,k  )
         f3 = data(2,i+2,j  ,k+1)
         f4 = data(2,i+2,j+1,k+1)
         if((f1.eq.0.) .and.
     &      (f2.eq.0.) .and. 
     &      (f3.eq.0.) .and. 
     &      (f4.eq.0.)) goto 16
       endif

       index1 = 255*max(0.,min(1.,(data(1,i+1,j  ,k  )-pmin)*fact))+1
       index2 = 255*max(0.,min(1.,(data(1,i+1,j+1,k  )-pmin)*fact))+1
       index3 = 255*max(0.,min(1.,(data(1,i+1,j+1,k+1)-pmin)*fact))+1
       index4 = 255*max(0.,min(1.,(data(1,i+1,j  ,k+1)-pmin)*fact))+1

       do L = 1,3
         verts(L,1) = xyz(i+1,j  ,k  ,L)
         verts(L,2) = xyz(i+1,j+1,k  ,L)
         verts(L,3) = xyz(i+1,j+1,k+1,L)
         verts(L,4) = xyz(i+1,j  ,k+1,L)
         colors(L,1) = color_tbl(L,index1)
         colors(L,2) = color_tbl(L,index2)
         colors(L,3) = color_tbl(L,index3)
         colors(L,4) = color_tbl(L,index4)
       enddo
       call GEOM_add_disjoint_polygon(obj,verts,GEOM_NULL
     &            ,colors,4,GEOM_NOT_SHARED,GEOM_COPY_DATA)
  16   continue
       return
       end

C **********************************************************************
C  hsv to rgb 
C **********************************************************************
       subroutine hsv_to_rgb(r,g,b,ht,s,v)
       real f, p, q, t
       real r, g, b
       real ht, s, v
       real h
C Make sure not to trash the input colormap
       h = ht
       if(v.eq.0) then
        r=0
        g=0
        b=0
        goto 100
       elseif(s.eq.0) then
        r = v
        g = v
        b = v
        goto 100
       else
        h = h * 6.0
        if(h.ge.6.0) then
          h = 0.0
        endif

        i = h
        f = h - i
        p = v*(1.0-s)
        q = v*(1.0-s*f)
        t = v*(1.0-s*(1.0-f))
       endif

       if(i.eq.0) then
          r = v
          g = t
          b = p
      elseif(i.eq.1) then
         r = q
         g = v
         b = p
      elseif(i.eq.2) then
         r = p
         g = v
         b = t
      elseif(i.eq.3) then
         r = p
         g = q
         b = v
      elseif(i.eq.4) then
         r = t
         g = p
         b = v
      elseif(i.eq.5) then
         r = v
         g = p
         b = q
      endif
  100 continue
      return
      end
